/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.admin.utils.cli;

import io.confluent.admin.utils.ClusterStatus;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperReadyCommand {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperReadyCommand.class);
    public static final String ZK_READY = "zk-ready";

    private static ArgumentParser createArgsParser() {
        ArgumentParser zkReady = ArgumentParsers.newArgumentParser((String)ZK_READY).defaultHelp(true).description("Check if ZK is ready.");
        zkReady.addArgument(new String[]{"zookeeper_connect"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).metavar(new String[]{"ZOOKEEPER_CONNECT"}).help("Zookeeper connect string.");
        zkReady.addArgument(new String[]{"timeout"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"TIMEOUT_IN_MS"}).help("Time (in ms) to wait for service to be ready.");
        return zkReady;
    }

    public static void main(String[] args) {
        boolean success;
        ArgumentParser parser = ZookeeperReadyCommand.createArgsParser();
        try {
            Namespace res = parser.parseArgs(args);
            log.debug("Arguments {}. ", (Object)res);
            success = ClusterStatus.isZookeeperReady(res.getString("zookeeper_connect"), res.getInt("timeout"));
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                success = true;
            } else {
                parser.handleError(e);
                success = false;
            }
        }
        catch (Exception e) {
            log.error("Error while running zk-ready {}.", (Throwable)e);
            success = false;
        }
        if (success) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

