/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.admin.utils;

import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZookeeperConnectionWatcher
implements Watcher {
    private CountDownLatch connectSignal;
    private boolean isSuccessful = true;
    private String failureMessage = null;
    private boolean isSaslEnabled = false;

    public ZookeeperConnectionWatcher(CountDownLatch connectSignal, boolean isSaslEnabled) {
        this.connectSignal = connectSignal;
        this.isSaslEnabled = isSaslEnabled;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    if (this.isSaslEnabled) break;
                    this.connectSignal.countDown();
                    break;
                }
                case Expired: {
                    this.failureMessage = "Session expired.";
                    this.isSuccessful = false;
                    this.connectSignal.countDown();
                    break;
                }
                case Disconnected: {
                    this.failureMessage = "Disconnected from the server.";
                    this.isSuccessful = false;
                    this.connectSignal.countDown();
                    break;
                }
                case AuthFailed: {
                    this.failureMessage = "Authentication failed.";
                    this.isSuccessful = false;
                    this.connectSignal.countDown();
                    break;
                }
                case SaslAuthenticated: {
                    this.connectSignal.countDown();
                    break;
                }
            }
        }
    }
}

