/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkaensure.cli;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.confluent.kafkaensure.TopicEnsure;
import io.confluent.kafkaensure.TopicSpec;
import java.io.File;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicEnsureCommand {
    private static final Logger log = LoggerFactory.getLogger(TopicEnsureCommand.class);
    public static final String TOPIC_ENSURE = "topic-ensure";

    private static ArgumentParser createArgsParser() {
        ArgumentParser topicEnsure = ArgumentParsers.newArgumentParser((String)TOPIC_ENSURE).defaultHelp(true).description("Check if topic exists and is valid.");
        topicEnsure.addArgument(new String[]{"--timeout", "-t"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"TIMEOUT_IN_MS"}).help("Time (in ms) to wait for service to be ready.");
        topicEnsure.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"CONFIG"}).required(true).help("Client config.");
        topicEnsure.addArgument(new String[]{"--file", "-f"}).action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"FILE_CONFIG"}).required(true).help("Topic config file.");
        topicEnsure.addArgument(new String[]{"--create-if-not-exists"}).action((ArgumentAction)Arguments.store()).type(Boolean.class).setDefault((Object)false).help("Create topic if it does not exist.");
        return topicEnsure;
    }

    public static void main(String[] args) {
        ArgumentParser parser = TopicEnsureCommand.createArgsParser();
        boolean success = false;
        try {
            Namespace res = parser.parseArgs(args);
            log.debug("Arguments {}. ", (Object)res);
            TopicEnsure topicEnsure = new TopicEnsure(Utils.loadProps((String)res.getString("config")));
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            TopicSpec.Topics topics = (TopicSpec.Topics)mapper.readValue(new File(res.getString("file")), TopicSpec.Topics.class);
            for (TopicSpec spec : topics.topics()) {
                success = topicEnsure.topicExists(spec, res.getInt("timeout"));
                System.err.printf("Topic [ %s ] exists ? %s\n", spec.name(), success);
                if (success) {
                    success = topicEnsure.validateTopic(spec, res.getInt("timeout"));
                    System.err.printf("Topic spec [ %s ] valid ? %s\n", spec, success);
                    if (success) continue;
                    break;
                }
                if (!res.getBoolean("create_if_not_exists").booleanValue()) continue;
                success = topicEnsure.createTopic(spec, res.getInt("timeout"));
                System.err.printf("Topic [ %s ] created with spec: [ %s ] \n", spec.name(), spec);
            }
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                success = true;
            } else {
                parser.handleError(e);
            }
        }
        catch (Exception e) {
            log.error("Error while running topic-ensure {}.", (Throwable)e);
            success = false;
        }
        if (success) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

