/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.common.record.RecordVersion;

public enum MetadataVersion {
    IBP_0_8_0(-1, "0.8.0", ""),
    IBP_0_8_1(-1, "0.8.1", ""),
    IBP_0_8_2(-1, "0.8.2", ""),
    IBP_0_9_0(-1, "0.9.0", ""),
    IBP_0_10_0_IV0(-1, "0.10.0", "IV0"),
    IBP_0_10_0_IV1(-1, "0.10.0", "IV1"),
    IBP_0_10_1_IV0(-1, "0.10.1", "IV0"),
    IBP_0_10_1_IV1(-1, "0.10.1", "IV1"),
    IBP_0_10_1_IV2(-1, "0.10.1", "IV2"),
    IBP_0_10_2_IV0(-1, "0.10.2", "IV0"),
    IBP_0_11_0_IV0(-1, "0.11.0", "IV0"),
    IBP_0_11_0_IV1(-1, "0.11.0", "IV1"),
    IBP_0_11_0_IV2(-1, "0.11.0", "IV2"),
    IBP_1_0_IV0(-1, "1.0", "IV0"),
    IBP_1_1_IV0(-1, "1.1", "IV0"),
    IBP_2_0_IV0(-1, "2.0", "IV0"),
    IBP_2_0_IV1(-1, "2.0", "IV1"),
    IBP_2_1_IV0(-1, "2.1", "IV0"),
    IBP_2_1_IV1(-1, "2.1", "IV1"),
    IBP_2_1_IV2(-1, "2.1", "IV2"),
    IBP_2_2_IV0(-1, "2.2", "IV0"),
    IBP_2_2_IV1(-1, "2.2", "IV1"),
    IBP_2_3_IV0(-1, "2.3", "IV0"),
    IBP_2_3_IV1(-1, "2.3", "IV1"),
    IBP_2_4_IV0(-1, "2.4", "IV0"),
    IBP_2_4_IV1(-1, "2.4", "IV1"),
    IBP_2_5_IV0(-1, "2.5", "IV0"),
    IBP_2_6_IV0(-1, "2.6", "IV0"),
    IBP_2_7_IV0(-1, "2.7", "IV0"),
    IBP_2_7_IV1(-1, "2.7", "IV1"),
    IBP_2_7_IV2(-1, "2.7", "IV2"),
    IBP_2_8_IV0(-1, "2.8", "IV0"),
    IBP_2_8_IV1(-1, "2.8", "IV1"),
    IBP_3_0_IV0(-1, "3.0", "IV0"),
    IBP_3_0_IV1(1, "3.0", "IV1", true),
    IBP_3_1_IV0(2, "3.1", "IV0", false),
    IBP_3_2_IV0(3, "3.2", "IV0", true),
    IBP_3_3_IV0(4, "3.3", "IV0", false),
    IBP_3_3_IV1(5, "3.3", "IV1", true),
    IBP_3_3_IV2(6, "3.3", "IV2", true),
    IBP_3_3_IV3(7, "3.3", "IV3", true),
    IBP_3_4_IV0(8, "3.4", "IV0", true),
    IBP_3_5_IV0(9, "3.5", "IV0", false),
    IBP_3_5_IV1(10, "3.5", "IV1", false),
    IBP_3_5_IV2(11, "3.5", "IV2", true),
    IBP_3_6_IV0(12, "3.6", "IV0", false),
    IBP_3_6_IV1(13, "3.6", "IV1", true),
    IBP_3_6_IV2(14, "3.6", "IV2", true);

    public static final String FEATURE_NAME = "metadata.version";
    public static final MetadataVersion MINIMUM_KRAFT_VERSION;
    public static final MetadataVersion MINIMUM_BOOTSTRAP_VERSION;
    public static final MetadataVersion[] VERSIONS;
    private final short featureLevel;
    private final String release;
    private final String ibpVersion;
    private final boolean didMetadataChange;
    private static final Map<String, MetadataVersion> IBP_VERSIONS;

    private MetadataVersion(int featureLevel, String release, String subVersion) {
        this(featureLevel, release, subVersion, true);
    }

    private MetadataVersion(int featureLevel, String release, String subVersion, boolean didMetadataChange) {
        this.featureLevel = (short)featureLevel;
        this.release = release;
        this.ibpVersion = subVersion.isEmpty() ? release : String.format("%s-%s", release, subVersion);
        this.didMetadataChange = didMetadataChange;
    }

    public short featureLevel() {
        return this.featureLevel;
    }

    public boolean isSaslInterBrokerHandshakeRequestEnabled() {
        return this.isAtLeast(IBP_0_10_0_IV1);
    }

    public boolean isOffsetForLeaderEpochSupported() {
        return this.isAtLeast(IBP_0_11_0_IV2);
    }

    public boolean isFeatureVersioningSupported() {
        return this.isAtLeast(IBP_2_7_IV0);
    }

    public boolean isTruncationOnFetchSupported() {
        return this.isAtLeast(IBP_2_7_IV1);
    }

    public boolean isAlterPartitionSupported() {
        return this.isAtLeast(IBP_2_7_IV2);
    }

    public boolean isTopicIdsSupported() {
        return this.isAtLeast(IBP_2_8_IV0);
    }

    public boolean isAllocateProducerIdsSupported() {
        return this.isAtLeast(IBP_3_0_IV0);
    }

    public boolean isLeaderRecoverySupported() {
        return this.isAtLeast(IBP_3_2_IV0);
    }

    public boolean isNoOpRecordSupported() {
        return this.isAtLeast(IBP_3_3_IV1);
    }

    public boolean isApiForwardingEnabled() {
        return this.isAtLeast(IBP_3_4_IV0);
    }

    public boolean isScramSupported() {
        return this.isAtLeast(IBP_3_5_IV2);
    }

    public boolean isLeaderEpochBumpRequiredOnIsrShrink() {
        return !this.isAtLeast(IBP_3_6_IV0);
    }

    public boolean isMetadataTransactionSupported() {
        return this.isAtLeast(IBP_3_6_IV1);
    }

    public boolean isDelegationTokenSupported() {
        return this.isAtLeast(IBP_3_6_IV2);
    }

    public boolean isKRaftSupported() {
        return this.featureLevel > 0;
    }

    public RecordVersion highestSupportedRecordVersion() {
        if (this.isLessThan(IBP_0_10_0_IV0)) {
            return RecordVersion.V0;
        }
        if (this.isLessThan(IBP_0_11_0_IV0)) {
            return RecordVersion.V1;
        }
        return RecordVersion.V2;
    }

    public boolean isBrokerRegistrationChangeRecordSupported() {
        return this.isAtLeast(IBP_3_3_IV2);
    }

    public boolean isInControlledShutdownStateSupported() {
        return this.isAtLeast(IBP_3_3_IV3);
    }

    public boolean isMigrationSupported() {
        return this.isAtLeast(IBP_3_4_IV0);
    }

    public short registerBrokerRecordVersion() {
        if (this.isMigrationSupported()) {
            return 2;
        }
        if (this.isInControlledShutdownStateSupported()) {
            return 1;
        }
        return 0;
    }

    public short fetchRequestVersion() {
        if (this.isAtLeast(IBP_3_5_IV1)) {
            return 15;
        }
        if (this.isAtLeast(IBP_3_5_IV0)) {
            return 14;
        }
        if (this.isAtLeast(IBP_3_1_IV0)) {
            return 13;
        }
        if (this.isAtLeast(IBP_2_7_IV1)) {
            return 12;
        }
        if (this.isAtLeast(IBP_2_3_IV1)) {
            return 11;
        }
        if (this.isAtLeast(IBP_2_1_IV2)) {
            return 10;
        }
        if (this.isAtLeast(IBP_2_0_IV1)) {
            return 8;
        }
        if (this.isAtLeast(IBP_1_1_IV0)) {
            return 7;
        }
        if (this.isAtLeast(IBP_0_11_0_IV1)) {
            return 5;
        }
        if (this.isAtLeast(IBP_0_11_0_IV0)) {
            return 4;
        }
        if (this.isAtLeast(IBP_0_10_1_IV1)) {
            return 3;
        }
        if (this.isAtLeast(IBP_0_10_0_IV0)) {
            return 2;
        }
        if (this.isAtLeast(IBP_0_9_0)) {
            return 1;
        }
        return 0;
    }

    public short offsetForLeaderEpochRequestVersion() {
        if (this.isAtLeast(IBP_2_8_IV0)) {
            return 4;
        }
        if (this.isAtLeast(IBP_2_3_IV1)) {
            return 3;
        }
        if (this.isAtLeast(IBP_2_1_IV1)) {
            return 2;
        }
        if (this.isAtLeast(IBP_2_0_IV0)) {
            return 1;
        }
        return 0;
    }

    public short listOffsetRequestVersion() {
        if (this.isAtLeast(IBP_3_5_IV0)) {
            return 8;
        }
        if (this.isAtLeast(IBP_3_0_IV1)) {
            return 7;
        }
        if (this.isAtLeast(IBP_2_8_IV0)) {
            return 6;
        }
        if (this.isAtLeast(IBP_2_2_IV1)) {
            return 5;
        }
        if (this.isAtLeast(IBP_2_1_IV1)) {
            return 4;
        }
        if (this.isAtLeast(IBP_2_0_IV1)) {
            return 3;
        }
        if (this.isAtLeast(IBP_0_11_0_IV0)) {
            return 2;
        }
        if (this.isAtLeast(IBP_0_10_1_IV2)) {
            return 1;
        }
        return 0;
    }

    public short groupMetadataValueVersion() {
        if (this.isLessThan(IBP_0_10_1_IV0)) {
            return 0;
        }
        if (this.isLessThan(IBP_2_1_IV0)) {
            return 1;
        }
        if (this.isLessThan(IBP_2_3_IV0)) {
            return 2;
        }
        return 3;
    }

    public short offsetCommitValueVersion(boolean expireTimestampMs) {
        if (this.isLessThan(IBP_2_1_IV0) || expireTimestampMs) {
            return 1;
        }
        if (this.isLessThan(IBP_2_1_IV1)) {
            return 2;
        }
        return 3;
    }

    public String shortVersion() {
        return this.release;
    }

    public String version() {
        return this.ibpVersion;
    }

    public boolean didMetadataChange() {
        return this.didMetadataChange;
    }

    Optional<MetadataVersion> previous() {
        int idx = this.ordinal();
        if (idx > 0) {
            return Optional.of(VERSIONS[idx - 1]);
        }
        return Optional.empty();
    }

    public static MetadataVersion fromVersionString(String versionString) {
        String[] versionSegments = versionString.split(Pattern.quote("."));
        int numSegments = versionString.startsWith("0.") ? 3 : 2;
        String key = numSegments >= versionSegments.length ? versionString : String.join((CharSequence)".", Arrays.copyOfRange(versionSegments, 0, numSegments));
        return Optional.ofNullable(IBP_VERSIONS.get(key)).orElseThrow(() -> new IllegalArgumentException("Version " + versionString + " is not a valid version"));
    }

    public static MetadataVersion fromFeatureLevel(short version) {
        for (MetadataVersion metadataVersion : MetadataVersion.values()) {
            if (metadataVersion.featureLevel() != version) continue;
            return metadataVersion;
        }
        throw new IllegalArgumentException("No MetadataVersion with metadata version " + version);
    }

    public static MetadataVersion minSupportedFor(RecordVersion recordVersion) {
        switch (recordVersion) {
            case V0: {
                return IBP_0_8_0;
            }
            case V1: {
                return IBP_0_10_0_IV0;
            }
            case V2: {
                return IBP_0_11_0_IV0;
            }
        }
        throw new IllegalArgumentException("Invalid message format version " + recordVersion);
    }

    public static MetadataVersion latest() {
        return VERSIONS[VERSIONS.length - 1];
    }

    public static boolean checkIfMetadataChanged(MetadataVersion sourceVersion, MetadataVersion targetVersion) {
        MetadataVersion lowVersion;
        MetadataVersion highVersion;
        if (sourceVersion == targetVersion) {
            return false;
        }
        if (sourceVersion.compareTo(targetVersion) < 0) {
            highVersion = targetVersion;
            lowVersion = sourceVersion;
        } else {
            highVersion = sourceVersion;
            lowVersion = targetVersion;
        }
        return MetadataVersion.checkIfMetadataChangedOrdered(highVersion, lowVersion);
    }

    private static boolean checkIfMetadataChangedOrdered(MetadataVersion highVersion, MetadataVersion lowVersion) {
        Optional<MetadataVersion> prev;
        MetadataVersion version = highVersion;
        while (!version.didMetadataChange() && version != lowVersion && (prev = version.previous()).isPresent()) {
            version = prev.get();
        }
        return version != lowVersion;
    }

    public boolean isAtLeast(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isLessThan(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public String toString() {
        return this.ibpVersion;
    }

    static {
        MINIMUM_KRAFT_VERSION = IBP_3_0_IV1;
        MINIMUM_BOOTSTRAP_VERSION = IBP_3_3_IV0;
        MetadataVersion[] enumValues = MetadataVersion.values();
        VERSIONS = Arrays.copyOf(enumValues, enumValues.length);
        IBP_VERSIONS = new HashMap<String, MetadataVersion>();
        HashMap<String, MetadataVersion> maxInterVersion = new HashMap<String, MetadataVersion>();
        for (MetadataVersion metadataVersion : VERSIONS) {
            maxInterVersion.put(metadataVersion.release, metadataVersion);
            IBP_VERSIONS.put(metadataVersion.ibpVersion, metadataVersion);
        }
        IBP_VERSIONS.putAll(maxInterVersion);
    }
}

