/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.UnifiedLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\u0007\u000e\u0001QA\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\f\u0001B\u0001B\u0003%a\fC\u0003b\u0001\u0011\u0005!\rC\u0004i\u0001\t\u0007I\u0011B5\t\rQ\u0004\u0001\u0015!\u0003k\u0011\u001d)\bA1A\u0005\nYDa! \u0001!\u0002\u00139\b\"\u0002@\u0001\t\u0003z\bbBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003s\u0001A\u0011IA\u001e\u0005U\u0019un\u001c:eS:\fGo\u001c:M_\u0006$WM]%na2T!AD\b\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005A\t\u0012aC2p_J$\u0017N\\1u_JT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001+\t)Rf\u0005\u0003\u0001-yI\u0004CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007}I3&D\u0001!\u0015\t\t#%A\u0004sk:$\u0018.\\3\u000b\u00059\u0019#B\u0001\t%\u0015\t\u0011RE\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<\u0017B\u0001\u0016!\u0005E\u0019un\u001c:eS:\fGo\u001c:M_\u0006$WM\u001d\t\u0003Y5b\u0001\u0001B\u0003/\u0001\t\u0007qFA\u0001U#\t\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$GA\u0004O_RD\u0017N\\4\u0011\u0005E:\u0014B\u0001\u001d3\u0005\r\te.\u001f\t\u0003uuj\u0011a\u000f\u0006\u0003yE\tQ!\u001e;jYNL!AP\u001e\u0003\u000f1{wmZ5oO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA!E\u001b\u0005\u0011%BA\"\u0012\u0003\u0019\u0019XM\u001d<fe&\u0011QI\u0011\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u00031!Wm]3sS\u0006d\u0017N_3s!\rA%l\u000b\b\u0003\u0013bs!AS,\u000f\u0005-3fB\u0001'V\u001d\tiEK\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011kE\u0001\u0007yI|w\u000e\u001e \n\u0003!J!AJ\u0014\n\u0005I)\u0013B\u0001\t%\u0013\tq1%\u0003\u0002\"E%\u0011\u0011\fI\u0001\u0012\u0007>|'\u000fZ5oCR|'\u000fT8bI\u0016\u0014\u0018BA.]\u00051!Um]3sS\u0006d\u0017N_3s\u0015\tI\u0006%\u0001\bm_\u0006$')\u001e4gKJ\u001c\u0016N_3\u0011\u0005Ez\u0016B\u000113\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r,gm\u001a\t\u0004I\u0002YS\"A\u0007\t\u000b}\"\u0001\u0019\u0001!\t\u000b\u0019#\u0001\u0019A$\t\u000bu#\u0001\u0019\u00010\u0002\u0013%\u001c(+\u001e8oS:<W#\u00016\u0011\u0005-\u0014X\"\u00017\u000b\u00055t\u0017AB1u_6L7M\u0003\u0002pa\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005ET\u0012\u0001B;uS2L!a\u001d7\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003)I7OU;o]&tw\rI\u0001\ng\u000eDW\rZ;mKJ,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003cjT!a\u0011\u0013\n\u0005qL(AD&bM.\f7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013\u0001\u00027pC\u0012$b!!\u0001\u0002\u0010\u0005}\u0001CBA\u0002\u0003\u000b\tI!D\u0001o\u0013\r\t9A\u001c\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007cA\f\u0002\f%\u0019\u0011Q\u0002\r\u0003\tY{\u0017\u000e\u001a\u0005\b\u0003#I\u0001\u0019AA\n\u0003\t!\b\u000f\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\u0002J\u0001\u0007G>lWn\u001c8\n\t\u0005u\u0011q\u0003\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0001\u0012\u00021\u0001\u0002\"A!q$a\t,\u0013\r\t)\u0003\t\u0002\u0014\u0007>|'\u000fZ5oCR|'\u000f\u00157bs\n\f7m[\u0001\u0007I>du.\u00193\u0015\u0011\u0005-\u0012\u0011GA\u001a\u0003k\u00012!MA\u0017\u0013\r\tyC\r\u0002\u0005+:LG\u000fC\u0004\u0002\u0012)\u0001\r!a\u0005\t\rAQ\u0001\u0019AA\u0011\u0011\u001d\t9D\u0003a\u0001\u0003\u0003\taAZ;ukJ,\u0017!B2m_N,GCAA\u0016\u0001")
public class CoordinatorLoaderImpl<T>
implements CoordinatorLoader<T>,
Logging {
    private final ReplicaManager replicaManager;
    private final CoordinatorLoader.Deserializer<T> deserializer;
    private final int loadBufferSize;
    private final AtomicBoolean isRunning;
    private final KafkaScheduler scheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public CompletableFuture<Void> load(TopicPartition tp, CoordinatorPlayback<T> coordinator) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.scheduler().scheduleOnce(new StringBuilder(22).append("Load coordinator from ").append(tp).toString(), () -> this.doLoad(tp, coordinator, future)).isCancelled()) {
            future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
        }
        return future;
    }

    private void doLoad(TopicPartition tp, CoordinatorPlayback<T> coordinator, CompletableFuture<Void> future) {
        block14: {
            try {
                Option<UnifiedLog> option = this.replicaManager.getLog(tp);
                if (None$.MODULE$.equals(option)) {
                    future.completeExceptionally(new NotLeaderOrFollowerException(new StringBuilder(60).append("Could not load records from ").append(tp).append(" because the log does not exist.").toString()));
                    break block14;
                }
                if (option instanceof Some) {
                    UnifiedLog log = (UnifiedLog)((Some)option).value();
                    ByteBuffer buffer = ByteBuffer.allocate(0);
                    LongRef currentOffset = LongRef.create((long)log.logStartOffset());
                    boolean readAtLeastOneRecord = true;
                    while (currentOffset.elem < this.logEndOffset$1(tp) && readAtLeastOneRecord && this.isRunning().get()) {
                        MemoryRecords memoryRecords;
                        FetchDataInfo fetchDataInfo = log.read(currentOffset.elem, this.loadBufferSize, FetchIsolation.LOG_END, true);
                        readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                        Records records = fetchDataInfo.records;
                        if (records instanceof MemoryRecords) {
                            memoryRecords = (MemoryRecords)records;
                        } else if (records instanceof FileRecords) {
                            FileRecords fileRecords = (FileRecords)records;
                            int sizeInBytes = fileRecords.sizeInBytes();
                            int bytesNeeded = Math.max(this.loadBufferSize, sizeInBytes);
                            if (buffer.capacity() < bytesNeeded) {
                                if (this.loadBufferSize < bytesNeeded) {
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Loaded metadata from ").append(tp).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured buffer size (").append($this.loadBufferSize).append(" bytes).").toString());
                                }
                                buffer = ByteBuffer.allocate(bytesNeeded);
                            } else {
                                buffer.clear();
                            }
                            fileRecords.readInto(buffer, 0);
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else {
                            throw new MatchError((Object)records);
                        }
                        memoryRecords.batches().forEach(batch -> {
                            if (batch.isControlBatch()) {
                                throw new IllegalStateException("Control batches are not supported yet.");
                            }
                            CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                CoordinatorLoaderImpl.$anonfun$doLoad$4(this, coordinator, tp, record);
                                return BoxedUnit.UNIT;
                            });
                            currentOffset$1.elem = batch.nextOffset();
                        });
                    }
                    if (this.isRunning().get()) {
                        future.complete(null);
                    } else {
                        future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
                    }
                    break block14;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
        }
    }

    public void close() {
        if (!this.isRunning().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Coordinator loader is already shutting down.");
            return;
        }
        this.scheduler().shutdown();
    }

    private final long logEndOffset$1(TopicPartition tp$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(tp$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$doLoad$4(CoordinatorLoaderImpl $this, CoordinatorPlayback coordinator$2, TopicPartition tp$2, Record record) {
        try {
            coordinator$2.replay($this.deserializer.deserialize(record.key(), record.value()));
            return;
        }
        catch (CoordinatorLoader.UnknownRecordTypeException ex) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Unknown record type ").append(ex.unknownType()).append(" while loading offsets and group metadata ").append("from ").append(tp$2).append(". Ignoring it. It could be a left over from an aborted upgrade.").toString());
            return;
        }
    }

    public CoordinatorLoaderImpl(ReplicaManager replicaManager, CoordinatorLoader.Deserializer<T> deserializer, int loadBufferSize) {
        this.replicaManager = replicaManager;
        this.deserializer = deserializer;
        this.loadBufferSize = loadBufferSize;
        this.isRunning = new AtomicBoolean(true);
        this.scheduler = new KafkaScheduler(1);
        this.scheduler().startup();
    }
}

