/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.util.FutureUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005x!\u0002\u0014(\u0011\u0003qc!\u0002\u0019(\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003Yd!\u0002\u0019(\u0001\u001dj\u0004\u0002\u0003\u0016\u0005\u0005\u000b\u0007I\u0011B)\t\u0011Q#!\u0011!Q\u0001\nIC\u0001\"\u0016\u0003\u0003\u0006\u0004%IA\u0016\u0005\t?\u0012\u0011\t\u0011)A\u0005/\")\u0001\b\u0002C\u0001A\")1\r\u0002C!I\"9\u0011\u0011\u0001\u0003\u0005B\u0005\r\u0001bBA\f\t\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003o!A\u0011IA\u001d\u0011\u001d\ty\u0005\u0002C!\u0003#Bq!!\u001a\u0005\t\u0003\n9\u0007C\u0004\u0002|\u0011!\t%! \t\u000f\u0005EE\u0001\"\u0011\u0002\u0014\"9\u00111\u001a\u0003\u0005B\u00055\u0007bBAs\t\u0011\u0005\u0013q\u001d\u0005\b\u0005+!A\u0011\tB\f\u0011\u001d\u0011y\u0002\u0002C\u0005\u0005CAqA!\u0014\u0005\t\u0003\u0012y\u0005C\u0004\u0003f\u0011!\tEa\u001a\t\u000f\tuD\u0001\"\u0003\u0003\u0000!9!\u0011\u0017\u0003\u0005B\tM\u0006b\u0002Be\t\u0011\u0005#1\u001a\u0005\b\u0007\u0007!A\u0011IB\u0003\u0011\u001d\u0019I\u0001\u0002C!\u0007\u0017Aqaa\u0007\u0005\t\u0003\u001ai\u0002C\u0004\u0004.\u0011!\tea\f\t\u000f\reB\u0001\"\u0011\u0004<!91q\t\u0003\u0005B\r%\u0003bBB3\t\u0011\u00053q\r\u0005\b\u0007_\"A\u0011IB9\u0011\u001d\u0019\u0019\t\u0002C!\u0007\u000bCqaa\"\u0005\t\u0003\u001aI\tC\u0004\u0004 \u0012!\te!)\u0002/\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018\tZ1qi\u0016\u0014(B\u0001\u0015*\u0003\u00159'o\\;q\u0015\tQ3&A\u0006d_>\u0014H-\u001b8bi>\u0014(\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001A\u0011q&A\u0007\u0002O\t9rI]8va\u000e{wN\u001d3j]\u0006$xN]!eCB$XM]\n\u0003\u0003I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/\u0003\u0015\t\u0007\u000f\u001d7z)%a4qWBd\u0007#\u001c\u0019\u000e\u0005\u00020\tM\u0019AA\u0010$\u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u00027b]\u001eT\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n1qJ\u00196fGR\u0004\"aR(\u000e\u0003!S!\u0001K%\u000b\u0005)R%B\u0001\u0017L\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AC%\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s+\u0005\u0011\u0006CA\u0018T\u0013\t\u0001v%\u0001\u0007d_>\u0014H-\u001b8bi>\u0014\b%\u0001\u0003uS6,W#A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016!B;uS2\u001c(B\u0001/K\u0003\u0019\u0019w.\\7p]&\u0011a,\u0017\u0002\u0005)&lW-A\u0003uS6,\u0007\u0005F\u0002=C\nDQAK\u0005A\u0002ICQ!V\u0005A\u0002]\u000bacY8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e\u000b\u0004KN\\\bc\u00014l[6\tqM\u0003\u0002iS\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005)\u0014\u0015\u0001B;uS2L!\u0001\\4\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0002oc6\tqN\u0003\u0002q7\u00069Q.Z:tC\u001e,\u0017B\u0001:p\u0005\t\u001auN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$(+Z:q_:\u001cX\rR1uC\")AO\u0003a\u0001k\u000691m\u001c8uKb$\bC\u0001<z\u001b\u00059(B\u0001=\\\u0003!\u0011X-];fgR\u001c\u0018B\u0001>x\u00059\u0011V-];fgR\u001cuN\u001c;fqRDQ\u0001 \u0006A\u0002u\fqA]3rk\u0016\u001cH\u000f\u0005\u0002o}&\u0011qp\u001c\u0002\"\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+\u0017/^3ti\u0012\u000bG/Y\u0001\u0014g\"\f'/Z$s_V\u0004\b*Z1si\n,\u0017\r\u001e\u000b\u0007\u0003\u000b\ti!a\u0004\u0011\t\u0019\\\u0017q\u0001\t\u0004]\u0006%\u0011bAA\u0006_\ny2\u000b[1sK\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+7\u000f]8og\u0016$\u0015\r^1\t\u000bQ\\\u0001\u0019A;\t\rq\\\u0001\u0019AA\t!\rq\u00171C\u0005\u0004\u0003+y'AH*iCJ,wI]8va\"+\u0017M\u001d;cK\u0006$(+Z9vKN$H)\u0019;b\u0003%Qw.\u001b8He>,\b\u000f\u0006\u0005\u0002\u001c\u0005\r\u0012QEA\u0017!\u001117.!\b\u0011\u00079\fy\"C\u0002\u0002\"=\u0014QCS8j]\u001e\u0013x.\u001e9SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0003u\u0019\u0001\u0007Q\u000f\u0003\u0004}\u0019\u0001\u0007\u0011q\u0005\t\u0004]\u0006%\u0012bAA\u0016_\n!\"j\\5o\u000fJ|W\u000f\u001d*fcV,7\u000f\u001e#bi\u0006Dq!a\f\r\u0001\u0004\t\t$\u0001\bck\u001a4WM]*vaBd\u0017.\u001a:\u0011\u0007a\u000b\u0019$C\u0002\u00026e\u0013aBQ;gM\u0016\u00148+\u001e9qY&,'/A\u0005ts:\u001cwI]8vaRA\u00111HA\"\u0003\u000b\ni\u0005\u0005\u0003gW\u0006u\u0002c\u00018\u0002@%\u0019\u0011\u0011I8\u0003+MKhnY$s_V\u0004(+Z:q_:\u001cX\rR1uC\")A/\u0004a\u0001k\"1A0\u0004a\u0001\u0003\u000f\u00022A\\A%\u0013\r\tYe\u001c\u0002\u0015'ft7m\u0012:pkB\u0014V-];fgR$\u0015\r^1\t\u000f\u0005=R\u00021\u0001\u00022\u0005I\u0001.Z1si\n,\u0017\r\u001e\u000b\u0007\u0003'\nY&!\u0018\u0011\t\u0019\\\u0017Q\u000b\t\u0004]\u0006]\u0013bAA-_\n)\u0002*Z1si\n,\u0017\r\u001e*fgB|gn]3ECR\f\u0007\"\u0002;\u000f\u0001\u0004)\bB\u0002?\u000f\u0001\u0004\ty\u0006E\u0002o\u0003CJ1!a\u0019p\u0005QAU-\u0019:uE\u0016\fGOU3rk\u0016\u001cH\u000fR1uC\u0006QA.Z1wK\u001e\u0013x.\u001e9\u0015\r\u0005%\u0014\u0011OA:!\u001117.a\u001b\u0011\u00079\fi'C\u0002\u0002p=\u0014a\u0003T3bm\u0016<%o\\;q%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006i>\u0001\r!\u001e\u0005\u0007y>\u0001\r!!\u001e\u0011\u00079\f9(C\u0002\u0002z=\u0014Q\u0003T3bm\u0016<%o\\;q%\u0016\fX/Z:u\t\u0006$\u0018-\u0001\u0006mSN$xI]8vaN$b!a \u0002\b\u0006%\u0005\u0003\u00024l\u0003\u0003\u00032A\\AB\u0013\r\t)i\u001c\u0002\u0017\u0019&\u001cHo\u0012:pkB\u001c(+Z:q_:\u001cX\rR1uC\")A\u000f\u0005a\u0001k\"1A\u0010\u0005a\u0001\u0003\u0017\u00032A\\AG\u0013\r\tyi\u001c\u0002\u0016\u0019&\u001cHo\u0012:pkB\u001c(+Z9vKN$H)\u0019;b\u00039!Wm]2sS\n,wI]8vaN$b!!&\u0002.\u0006=\u0006\u0003\u00024l\u0003/\u0003b!!'\u0002\u001c\u0006}U\"A5\n\u0007\u0005u\u0015N\u0001\u0003MSN$\b\u0003BAQ\u0003Os1A\\AR\u0013\r\t)k\\\u0001\u001b\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003S\u000bYK\u0001\bEKN\u001c'/\u001b2fI\u001e\u0013x.\u001e9\u000b\u0007\u0005\u0015v\u000eC\u0003u#\u0001\u0007Q\u000fC\u0004\u00022F\u0001\r!a-\u0002\u0011\u001d\u0014x.\u001e9JIN\u0004b!!'\u0002\u001c\u0006U\u0006\u0003BA\\\u0003\u000btA!!/\u0002BB\u0019\u00111\u0018\u001b\u000e\u0005\u0005u&bAA`[\u00051AH]8pizJ1!a15\u0003\u0019\u0001&/\u001a3fM&!\u0011qYAe\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0019\u001b\u0002\u0019\u0011,G.\u001a;f\u000fJ|W\u000f]:\u0015\u0011\u0005=\u0017q\\Aq\u0003G\u0004BAZ6\u0002RB!\u00111[Am\u001d\rq\u0017Q[\u0005\u0004\u0003/|\u0017\u0001\u0007#fY\u0016$Xm\u0012:pkB\u001c(+Z:q_:\u001cX\rR1uC&!\u00111\\Ao\u0005y!U\r\\3uC\ndWm\u0012:pkB\u0014Vm];mi\u000e{G\u000e\\3di&|gNC\u0002\u0002X>DQ\u0001\u001e\nA\u0002UDq!!-\u0013\u0001\u0004\t\u0019\fC\u0004\u00020I\u0001\r!!\r\u0002\u001f\u0019,Go\u00195BY2|eMZ:fiN$\u0002\"!;\u0002z\u0006m(1\u0002\t\u0005M.\fY\u000f\u0005\u0003\u0002n\u0006Mhb\u00018\u0002p&\u0019\u0011\u0011_8\u0002/=3gm]3u\r\u0016$8\r\u001b*fgB|gn]3ECR\f\u0017\u0002BA{\u0003o\u0014\u0001d\u00144gg\u0016$h)\u001a;dQJ+7\u000f]8og\u0016<%o\\;q\u0015\r\t\tp\u001c\u0005\u0006iN\u0001\r!\u001e\u0005\u0007yN\u0001\r!!@\u0011\t\u0005}(Q\u0001\b\u0004]\n\u0005\u0011b\u0001B\u0002_\u00061rJ\u001a4tKR4U\r^2i%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0003\b\t%!aF(gMN,GOR3uG\"\u0014V-];fgR<%o\\;q\u0015\r\u0011\u0019a\u001c\u0005\b\u0005\u001b\u0019\u0002\u0019\u0001B\b\u00035\u0011X-];je\u0016\u001cF/\u00192mKB\u00191G!\u0005\n\u0007\tMAGA\u0004C_>dW-\u00198\u0002\u0019\u0019,Go\u00195PM\u001a\u001cX\r^:\u0015\u0011\u0005%(\u0011\u0004B\u000e\u0005;AQ\u0001\u001e\u000bA\u0002UDa\u0001 \u000bA\u0002\u0005u\bb\u0002B\u0007)\u0001\u0007!qB\u0001\u0012Q\u0006tG\r\\3GKR\u001c\u0007n\u00144gg\u0016$H\u0003CAu\u0005G\u00119C!\u000b\t\u000f\t\u0015R\u00031\u0001\u00026\u00069qM]8va&#\u0007b\u0002B\u0007+\u0001\u0007!q\u0002\u0005\b\u0005W)\u0002\u0019\u0001B\u0017\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006g\t=\"1G\u0005\u0004\u0005c!$AB(qi&|g\u000e\u0005\u0004\u00036\t}\"Q\t\b\u0005\u0005o\u0011YD\u0004\u0003\u0002<\ne\u0012\"A\u001b\n\u0007\tuB'A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0005#1\t\u0002\u0004'\u0016\f(b\u0001B\u001fiA!!q\tB%\u001b\u0005Y\u0016b\u0001B&7\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!D2p[6LGo\u00144gg\u0016$8\u000f\u0006\u0005\u0003R\te#1\fB2!\u001117Na\u0015\u0011\u00079\u0014)&C\u0002\u0003X=\u0014\u0001d\u00144gg\u0016$8i\\7nSR\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015!h\u00031\u0001v\u0011\u0019ah\u00031\u0001\u0003^A\u0019aNa\u0018\n\u0007\t\u0005tNA\fPM\u001a\u001cX\r^\"p[6LGOU3rk\u0016\u001cH\u000fR1uC\"9\u0011q\u0006\fA\u0002\u0005E\u0012AG2p[6LG\u000f\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cH\u0003\u0003B5\u0005c\u0012\u0019Ha\u001f\u0011\t\u0019\\'1\u000e\t\u0004]\n5\u0014b\u0001B8_\nYB\u000b\u001f8PM\u001a\u001cX\r^\"p[6LGOU3ta>t7/\u001a#bi\u0006DQ\u0001^\fA\u0002UDa\u0001`\fA\u0002\tU\u0004c\u00018\u0003x%\u0019!\u0011P8\u00035QChn\u00144gg\u0016$8i\\7nSR\u0014V-];fgR$\u0015\r^1\t\u000f\u0005=r\u00031\u0001\u00022\u000592M]3bi\u0016|eMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u000b\u000f\u0005\u0003\u0013YI!&\u0003\u001a\n\r&q\u0015BV!\u0011\u0011\u0019Ia\"\u000e\u0005\t\u0015%B\u0001/,\u0013\u0011\u0011II!\"\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003\u000eb\u0001\rAa$\u0002\u001b\r,(O]3oiRKW.Z't!\r\u0019$\u0011S\u0005\u0004\u0005'#$\u0001\u0002'p]\u001eDqAa&\u0019\u0001\u0004\u0011y)\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u00057C\u0002\u0019\u0001BO\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0007M\u0012y*C\u0002\u0003\"R\u00121!\u00138u\u0011\u001d\u0011)\u000b\u0007a\u0001\u0003k\u000b\u0001\"\\3uC\u0012\fG/\u0019\u0005\b\u0005SC\u0002\u0019\u0001BH\u0003=\u0019w.\\7jiRKW.Z:uC6\u0004\bb\u0002BW1\u0001\u0007!qV\u0001\u0010Kb\u0004\u0018N]3US6,7\u000f^1naB)1Ga\f\u0003\u0010\u0006iA-\u001a7fi\u0016|eMZ:fiN$\u0002B!.\u0003>\n}&q\u0019\t\u0005M.\u00149\fE\u0002o\u0005sK1Aa/p\u0005ayeMZ:fi\u0012+G.\u001a;f%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006if\u0001\r!\u001e\u0005\u0007yf\u0001\rA!1\u0011\u00079\u0014\u0019-C\u0002\u0003F>\u0014qc\u00144gg\u0016$H)\u001a7fi\u0016\u0014V-];fgR$\u0015\r^1\t\u000f\u0005=\u0012\u00041\u0001\u00022\u0005\u00192m\\7qY\u0016$X\r\u0016:b]N\f7\r^5p]Rq!Q\u001aBk\u00053\u0014iNa:\u0003l\nU\b\u0003\u00024l\u0005\u001f\u00042a\u0010Bi\u0013\r\u0011\u0019\u000e\u0011\u0002\u0005->LG\rC\u0004\u0003Xj\u0001\rA!\u0012\u0002\u0005Q\u0004\bb\u0002Bn5\u0001\u0007!qR\u0001\u000baJ|G-^2fe&#\u0007b\u0002Bp5\u0001\u0007!\u0011]\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007M\u0012\u0019/C\u0002\u0003fR\u0012Qa\u00155peRDqA!;\u001b\u0001\u0004\u0011i*\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"9!Q\u001e\u000eA\u0002\t=\u0018A\u0002:fgVdG\u000fE\u0002w\u0005cL1Aa=x\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0005oT\u0002\u0019\u0001B}\u0003\u001d!\u0018.\\3pkR\u0004BAa?\u0003\u00006\u0011!Q \u0006\u0003+\nKAa!\u0001\u0003~\nAA)\u001e:bi&|g.\u0001\u0007qCJ$\u0018\u000e^5p]\u001a{'\u000f\u0006\u0003\u0003\u001e\u000e\u001d\u0001b\u0002B\u00137\u0001\u0007\u0011QW\u0001\u0017_:$&/\u00198tC\u000e$\u0018n\u001c8D_6\u0004H.\u001a;fIRA!QZB\u0007\u0007\u001f\u00199\u0002C\u0004\u0003\\r\u0001\rAa$\t\u000f\t-B\u00041\u0001\u0004\u0012A)qha\u0005\u0003F%\u00191Q\u0003!\u0003\u0011%#XM]1cY\u0016Dqa!\u0007\u001d\u0001\u0004\u0011y/A\tue\u0006t7/Y2uS>t'+Z:vYR\f1c\u001c8QCJ$\u0018\u000e^5p]N$U\r\\3uK\u0012$baa\b\u0004&\r-\u0002cA\u001a\u0004\"%\u001911\u0005\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007Oi\u0002\u0019AB\u0015\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bCBAM\u00037\u0013)\u0005C\u0004\u00020u\u0001\r!!\r\u0002\u0015=tW\t\\3di&|g\u000e\u0006\u0004\u0004 \rE2Q\u0007\u0005\b\u0007gq\u0002\u0019\u0001BO\u0003m9'o\\;q\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t\u0017J\u001c3fq\"91q\u0007\u0010A\u0002\tu\u0015!I4s_V\u0004X*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0017!D8o%\u0016\u001c\u0018n\u001a8bi&|g\u000e\u0006\u0004\u0004 \ru2q\b\u0005\b\u0007gy\u0002\u0019\u0001BO\u0011\u001d\u00199d\ba\u0001\u0007\u0003\u0002B!!'\u0004D%\u00191QI5\u0003\u0017=\u0003H/[8oC2Le\u000e^\u0001\u0013_:tUm^'fi\u0006$\u0017\r^1J[\u0006<W\r\u0006\u0004\u0004 \r-31\f\u0005\b\u0007\u001b\u0002\u0003\u0019AB(\u0003!qWm^%nC\u001e,\u0007\u0003BB)\u0007/j!aa\u0015\u000b\u0007\rU#*A\u0003j[\u0006<W-\u0003\u0003\u0004Z\rM#!D'fi\u0006$\u0017\r^1J[\u0006<W\rC\u0004\u0004^\u0001\u0002\raa\u0018\u0002\u000b\u0011,G\u000e^1\u0011\t\rE3\u0011M\u0005\u0005\u0007G\u001a\u0019FA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u001aOJ|W\u000f]'fi\u0006$\u0017\r^1U_BL7mQ8oM&<7\u000f\u0006\u0002\u0004jA!\u0011\u0011TB6\u0013\r\u0019i'\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018aB:uCJ$X\u000f\u001d\u000b\u0005\u0007?\u0019\u0019\bC\u0004\u0004v\t\u0002\raa\u001e\u0002A\u001d\u0014x.\u001e9NKR\fG-\u0019;b)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\t\u0005\u0007s\u001ay(\u0004\u0002\u0004|)\u00191QP5\u0002\u0011\u0019,hn\u0019;j_:LAa!!\u0004|\tY\u0011J\u001c;TkB\u0004H.[3s\u0003!\u0019\b.\u001e;e_^tGCAB\u0010\u0003U\u0019wN\\:v[\u0016\u0014xI]8va\u0012+7o\u0019:jE\u0016$baa#\u0004\u001c\u000eu\u0005\u0003\u00024l\u0007\u001b\u0003b!!'\u0002\u001c\u000e=\u0005\u0003BBI\u0007/s1A\\BJ\u0013\r\u0019)j\\\u0001\"\u0007>t7/^7fe\u001e\u0013x.\u001e9EKN\u001c'/\u001b2f%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003S\u001bIJC\u0002\u0004\u0016>DQ\u0001\u001e\u0013A\u0002UDq!!-%\u0001\u0004\t\u0019,\u0001\ntQ\u0006\u0014Xm\u0012:pkB$Um]2sS\n,GCBBR\u0007g\u001b)\f\u0005\u0003gW\u000e\u0015\u0006CBAM\u00037\u001b9\u000b\u0005\u0003\u0004*\u000e=fb\u00018\u0004,&\u00191QV8\u0002=MC\u0017M]3He>,\b\u000fR3tGJL'-\u001a*fgB|gn]3ECR\f\u0017\u0002BAU\u0007cS1a!,p\u0011\u0015!X\u00051\u0001v\u0011\u001d\t\t,\na\u0001\u0003gCqa!/\u0004\u0001\u0004\u0019Y,\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0007{\u001b\u0019-\u0004\u0002\u0004@*\u00191\u0011Y\u0016\u0002\rM,'O^3s\u0013\u0011\u0019)ma0\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0007\u0013\u001c\u0001\u0019ABf\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004Ba!0\u0004N&!1qZB`\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDQ!V\u0002A\u0002]Cqa!6\u0004\u0001\u0004\u00199.A\u0004nKR\u0014\u0018nY:\u0011\t\re7Q\\\u0007\u0003\u00077T1a!6\\\u0013\u0011\u0019yna7\u0003\u000f5+GO]5dg\u0002")
public class GroupCoordinatorAdapter
implements org.apache.kafka.coordinator.group.GroupCoordinator {
    private final GroupCoordinator coordinator;
    private final Time time;

    public static GroupCoordinatorAdapter apply(KafkaConfig config, ReplicaManager replicaManager, Time time, Metrics metrics) {
        return GroupCoordinatorAdapter$.MODULE$.apply(config, replicaManager, time, metrics);
    }

    private GroupCoordinator coordinator() {
        return this.coordinator;
    }

    private Time time() {
        return this.time;
    }

    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_HEARTBEAT.name).append(" API.").toString()));
    }

    public CompletableFuture<ShareGroupHeartbeatResponseData> shareGroupHeartbeat(RequestContext context, ShareGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.SHARE_GROUP_HEARTBEAT.name).append(" API.").toString()));
    }

    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<JoinGroupResponseData> future = new CompletableFuture<JoinGroupResponseData>();
        Option groupInstanceId = Option$.MODULE$.apply((Object)request.groupInstanceId());
        boolean requireKnownMemberId = context.apiVersion() >= 4 && groupInstanceId.isEmpty();
        List protocols = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(request.protocols().valuesList()).asScala().map((Function1 & Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()))).toList();
        boolean supportSkippingAssignment = context.apiVersion() >= 9;
        this.coordinator().handleJoinGroup(request.groupId(), request.memberId(), (Option<String>)groupInstanceId, requireKnownMemberId, supportSkippingAssignment, context.clientId(), context.clientAddress.toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable)joinResult -> {
            GroupCoordinatorAdapter.callback$1(joinResult, future);
            return BoxedUnit.UNIT;
        }, (Option<String>)Option$.MODULE$.apply((Object)request.reason()), new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<SyncGroupResponseData> future = new CompletableFuture<SyncGroupResponseData>();
        Builder assignmentMap = Map$.MODULE$.newBuilder();
        request.assignments().forEach(assignment -> assignmentMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignment.memberId()), (Object)assignment.assignment())));
        this.coordinator().handleSyncGroup(request.groupId(), request.generationId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.protocolType()), (Option<String>)Option$.MODULE$.apply((Object)request.protocolName()), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), (Map<String, byte[]>)((Map)assignmentMap.result()), (Function1<SyncGroupResult, BoxedUnit>)(Function1 & Serializable)syncGroupResult -> {
            GroupCoordinatorAdapter.callback$2(syncGroupResult, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        CompletableFuture<HeartbeatResponseData> future = new CompletableFuture<HeartbeatResponseData>();
        this.coordinator().handleHeartbeat(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            future.complete(new HeartbeatResponseData().setErrorCode(error.code()));
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        CompletableFuture<LeaveGroupResponseData> future = new CompletableFuture<LeaveGroupResponseData>();
        this.coordinator().handleLeaveGroup(request.groupId(), (List<LeaveGroupRequestData.MemberIdentity>)CollectionConverters$.MODULE$.ListHasAsScala(request.members()).asScala().toList(), (Function1<LeaveGroupResult, BoxedUnit>)(Function1 & Serializable)leaveGroupResult -> {
            GroupCoordinatorAdapter.callback$3(leaveGroupResult, future);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        void var5_5;
        void var4_4;
        Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups((Set<String>)((Set)Option$.MODULE$.apply((Object)request.statesFilter()).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1).asScala().toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())), (Set<String>)((Set)Option$.MODULE$.apply((Object)request.typesFilter()).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        List groups = (List)tuple2._2();
        ListGroupsResponseData response = new ListGroupsResponseData().setErrorCode(var4_4.code());
        var5_5.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$listGroups$5(response, group)));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, java.util.List<String> groupIds) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().map((Function1 & Serializable)groupId -> this.describeGroup$1((String)groupId))).asJava());
    }

    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, java.util.List<String> groupIds, BufferSupplier bufferSupplier) {
        DeleteGroupsResponseData.DeletableGroupResultCollection results = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        this.coordinator().handleDeleteGroups((Set<String>)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().toSet(), new RequestLocal(bufferSupplier)).foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(groupId, error) -> BoxesRunTime.boxToBoolean((boolean)results.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code()))), arg_0, arg_1));
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)None$.MODULE$);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        ArrayBuffer topicPartitions = new ArrayBuffer();
        request.topics().forEach(topic -> topic.partitionIndexes().forEach(partition -> topicPartitions.$plus$eq((Object)new TopicPartition(topic.name(), Predef$.MODULE$.Integer2int(partition)))));
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)new Some((Object)topicPartitions.toSeq()));
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> handleFetchOffset(String groupId, boolean requireStable, Option<scala.collection.immutable.Seq<TopicPartition>> partitions) {
        void var5_5;
        Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple2 = this.coordinator().handleFetchOffsets(groupId, requireStable, partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map results = (Map)tuple2._2();
        CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> future = new CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup>();
        void v0 = var5_5;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally(var5_5.exception());
        } else {
            void var6_6;
            ArrayList topicsList = new ArrayList();
            HashMap topicsMap = new HashMap();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, offset) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$handleFetchOffset$1(topicsMap, topicsList, tp, offset));
            var6_6.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var11_11 = null;
            future.complete(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(topicsList));
        }
        return future;
    }

    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<OffsetCommitResponseData> future = new CompletableFuture<OffsetCommitResponseData>();
        long l = request.retentionTimeMs();
        None$ expireTimeMs = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(currentTimeMs + l)));
        HashMap partitions = new HashMap();
        request.topics().forEach(arg_0 -> GroupCoordinatorAdapter.$anonfun$commitOffsets$2(this, partitions, currentTimeMs, (Option)expireTimeMs, arg_0));
        this.coordinator().handleCommitOffsets(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationIdOrMemberEpoch(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)commitStatus -> {
            GroupCoordinatorAdapter.callback$4(commitStatus, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<TxnOffsetCommitResponseData> future = new CompletableFuture<TxnOffsetCommitResponseData>();
        HashMap partitions = new HashMap();
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.createOffsetAndMetadata(currentTimeMs, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), -1L, (Option<Object>)None$.MODULE$)));
        }));
        this.coordinator().handleTxnCommitOffsets(request.groupId(), request.transactionalId(), request.producerId(), request.producerEpoch(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)results -> {
            GroupCoordinatorAdapter.callback$5(results, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier), context.apiVersion());
        return future;
    }

    private OffsetAndMetadata createOffsetAndMetadata(long currentTimeMs, long offset, int leaderEpoch, String metadata, long commitTimestamp, Option<Object> expireTimestamp) {
        String string;
        Optional<Integer> optional;
        switch (leaderEpoch) {
            case -1: {
                optional = Optional.empty();
                break;
            }
            default: {
                optional = Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
            }
        }
        switch (metadata == null ? 0 : metadata.hashCode()) {
            case 0: {
                if (metadata == null) {
                    string = OffsetAndMetadata$.MODULE$.NoMetadata();
                    break;
                }
            }
            default: {
                string = metadata;
            }
        }
        return new OffsetAndMetadata(offset, optional, string, -1L == commitTimestamp ? currentTimeMs : commitTimestamp, expireTimestamp);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        void var7_7;
        CompletableFuture<OffsetDeleteResponseData> future = new CompletableFuture<OffsetDeleteResponseData>();
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> partitions.$plus$eq((Object)new TopicPartition(topic.name(), partition.partitionIndex()))));
        Tuple2<Errors, Map<TopicPartition, Errors>> tuple2 = this.coordinator().handleDeleteOffsets(request.groupId(), (Seq<TopicPartition>)partitions, new RequestLocal(bufferSupplier));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors groupError = (Errors)tuple2._1();
        Map topicPartitionResults = (Map)tuple2._2();
        void v0 = var7_7;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally(var7_7.exception());
        } else {
            void var8_8;
            OffsetDeleteResponseData response = new OffsetDeleteResponseData();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$deleteOffsets$3(response, topicPartition, error));
            var8_8.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var11_11 = null;
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<Void> completeTransaction(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, Duration timeout) {
        return FutureUtils.failedFuture((Throwable)new IllegalStateException("The old group coordinator does not support `completeTransaction` API."));
    }

    public int partitionFor(String groupId) {
        return this.coordinator().partitionFor(groupId);
    }

    public CompletableFuture<Void> onTransactionCompleted(long producerId, java.lang.Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        try {
            return this.coordinator().scheduleHandleTxnCompletion(producerId, (Iterable<TopicPartition>)CollectionConverters$.MODULE$.IterableHasAsScala(partitions).asScala(), transactionResult);
        }
        catch (Throwable throwable) {
            return FutureUtils.failedFuture((Throwable)throwable);
        }
    }

    public void onPartitionsDeleted(java.util.List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) {
        this.coordinator().handleDeletedPartitions((Seq<TopicPartition>)CollectionConverters$.MODULE$.ListHasAsScala(topicPartitions).asScala(), new RequestLocal(bufferSupplier));
    }

    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onResignation(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
    }

    public Properties groupMetadataTopicConfigs() {
        return this.coordinator().offsetsTopicConfigs();
    }

    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        this.coordinator().startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> groupMetadataTopicPartitionCount.getAsInt(), this.coordinator().startup$default$2());
    }

    public void shutdown() {
        this.coordinator().shutdown();
    }

    public CompletableFuture<java.util.List<ConsumerGroupDescribeResponseData.DescribedGroup>> consumerGroupDescribe(RequestContext context, java.util.List<String> groupIds) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_DESCRIBE.name).append(" API.").toString()));
    }

    public CompletableFuture<java.util.List<ShareGroupDescribeResponseData.DescribedGroup>> shareGroupDescribe(RequestContext context, java.util.List<String> groupIds) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.SHARE_GROUP_DESCRIBE.name).append(" API.").toString()));
    }

    private static final void callback$1(JoinGroupResult joinResult, CompletableFuture future$1) {
        future$1.complete(new JoinGroupResponseData().setErrorCode(joinResult.error().code()).setGenerationId(joinResult.generationId()).setProtocolType((String)joinResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)joinResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setLeader(joinResult.leaderId()).setSkipAssignment(joinResult.skipAssignment()).setMemberId(joinResult.memberId()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava(joinResult.members()).asJava()));
    }

    private static final void callback$2(SyncGroupResult syncGroupResult, CompletableFuture future$2) {
        future$2.complete(new SyncGroupResponseData().setErrorCode(syncGroupResult.error().code()).setProtocolType((String)syncGroupResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)syncGroupResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setAssignment(syncGroupResult.memberAssignment()));
    }

    private static final void callback$3(LeaveGroupResult leaveGroupResult, CompletableFuture future$4) {
        future$4.complete(new LeaveGroupResponseData().setErrorCode(leaveGroupResult.topLevelError().code()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaveGroupResult.memberResponses().map((Function1 & Serializable)member -> new LeaveGroupResponseData.MemberResponse().setErrorCode(member.error().code()).setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$listGroups$5(ListGroupsResponseData response$1, GroupOverview group) {
        return response$1.groups().add(new ListGroupsResponseData.ListedGroup().setGroupId(group.groupId()).setProtocolType(group.protocolType()).setGroupState(group.state()).setGroupType(group.groupType()));
    }

    /*
     * WARNING - void declaration
     */
    private final DescribeGroupsResponseData.DescribedGroup describeGroup$1(String groupId) {
        void var4_4;
        void var3_3;
        Tuple2<Errors, GroupSummary> tuple2 = this.coordinator().handleDescribeGroup(groupId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        GroupSummary summary = (GroupSummary)tuple2._2();
        return new DescribeGroupsResponseData.DescribedGroup().setErrorCode(var3_3.code()).setGroupId(groupId).setGroupState(var4_4.state()).setProtocolType(var4_4.protocolType()).setProtocolData(var4_4.protocol()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)var4_4.members().map((Function1 & Serializable)member -> new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setClientId(member.clientId()).setClientHost(member.clientHost()).setMemberAssignment(member.assignment()).setMemberMetadata(member.metadata()))).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchOffset$1(HashMap topicsMap$1, ArrayList topicsList$1, TopicPartition tp, OffsetFetchResponse.PartitionData offset) {
        OffsetFetchResponseData.OffsetFetchResponseTopics offsetFetchResponseTopics;
        Option option = topicsMap$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetFetchResponseTopics = (OffsetFetchResponseData.OffsetFetchResponseTopics)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicOffsets = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp.topic());
            topicsMap$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicOffsets));
            topicsList$1.add(topicOffsets);
            offsetFetchResponseTopics = topicOffsets;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetFetchResponseTopics.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp.partition()).setMetadata(offset.metadata).setCommittedOffset(offset.offset).setCommittedLeaderEpoch(Predef$.MODULE$.Integer2int(offset.leaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1)))).setErrorCode(offset.error.code()));
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$1(HashMap byTopics$1, OffsetCommitResponseData response$2, TopicIdPartition tp, Errors error) {
        OffsetCommitResponseData.OffsetCommitResponseTopic offsetCommitResponseTopic;
        Option option = byTopics$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetCommitResponseTopic = (OffsetCommitResponseData.OffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetCommitResponseData.OffsetCommitResponseTopic newTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(tp.topic());
            byTopics$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$2.topics().add(newTopic);
            offsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetCommitResponseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$4(scala.collection.immutable.Map commitStatus, CompletableFuture future$5) {
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitOffsets$1(byTopics, response, tp, error));
        commitStatus.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var4_4 = null;
        future$5.complete(response);
    }

    public static final /* synthetic */ void $anonfun$commitOffsets$2(GroupCoordinatorAdapter $this, HashMap partitions$1, long currentTimeMs$1, Option expireTimeMs$1, OffsetCommitRequestData.OffsetCommitRequestTopic topic) {
        topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)$this.createOffsetAndMetadata(currentTimeMs$1, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), partition.commitTimestamp(), (Option<Object>)expireTimeMs$1)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$commitTransactionalOffsets$1(HashMap byTopics$2, TxnOffsetCommitResponseData response$3, TopicIdPartition tp, Errors error) {
        TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic txnOffsetCommitResponseTopic;
        Option option = byTopics$2.get((Object)tp.topic());
        if (option instanceof Some) {
            txnOffsetCommitResponseTopic = (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic newTopic = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(tp.topic());
            byTopics$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$3.topics().add(newTopic);
            txnOffsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return txnOffsetCommitResponseTopic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$5(scala.collection.immutable.Map results, CompletableFuture future$6) {
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitTransactionalOffsets$1(byTopics, response, tp, error));
        results.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var4_4 = null;
        future$6.complete(response);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOffsets$3(OffsetDeleteResponseData response$4, TopicPartition topicPartition, Errors error) {
        OffsetDeleteResponseData.OffsetDeleteResponseTopic topic = response$4.topics().find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicPartition.topic());
            response$4.topics().add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code()));
    }

    public GroupCoordinatorAdapter(GroupCoordinator coordinator, Time time) {
        this.coordinator = coordinator;
        this.time = time;
    }
}

