/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.http.authenticator;

import com.sun.net.httpserver.BasicAuthenticator;
import io.prometheus.jmx.common.http.authenticator.CacheKey;
import io.prometheus.jmx.common.util.Precondition;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class MessageDigestAuthenticator
extends BasicAuthenticator {
    private static final int MAXIMUM_INVALID_CACHE_KEY_ENTRIES = 16;
    private final String username;
    private final String passwordHash;
    private final String algorithm;
    private final String salt;
    private final Set<CacheKey> validCacheKeys;
    private final LinkedList<CacheKey> invalidCacheKeys;

    public MessageDigestAuthenticator(String realm, String username, String passwordHash, String algorithm, String salt) throws GeneralSecurityException {
        super(realm);
        Precondition.notNullOrEmpty(username);
        Precondition.notNullOrEmpty(passwordHash);
        Precondition.notNullOrEmpty(algorithm);
        Precondition.notNullOrEmpty(salt);
        MessageDigest.getInstance(algorithm);
        this.username = username;
        this.passwordHash = passwordHash.toLowerCase().replace(":", "");
        this.algorithm = algorithm;
        this.salt = salt;
        this.validCacheKeys = Collections.synchronizedSet(new HashSet());
        this.invalidCacheKeys = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCredentials(String username, String password) {
        boolean isValid;
        if (username == null || password == null) {
            return false;
        }
        CacheKey cacheKey = new CacheKey(username, password);
        if (this.validCacheKeys.contains(cacheKey)) {
            return true;
        }
        LinkedList<CacheKey> linkedList = this.invalidCacheKeys;
        synchronized (linkedList) {
            if (this.invalidCacheKeys.contains(cacheKey)) {
                return false;
            }
        }
        boolean bl = isValid = this.username.equals(username) && this.passwordHash.equals(MessageDigestAuthenticator.generatePasswordHash(this.algorithm, this.salt, password));
        if (isValid) {
            this.validCacheKeys.add(cacheKey);
        } else {
            LinkedList<CacheKey> linkedList2 = this.invalidCacheKeys;
            synchronized (linkedList2) {
                this.invalidCacheKeys.add(cacheKey);
                if (this.invalidCacheKeys.size() > 16) {
                    this.invalidCacheKeys.removeFirst();
                }
            }
        }
        return isValid;
    }

    private static String generatePasswordHash(String algorithm, String salt, String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest((salt + ":" + password).getBytes(StandardCharsets.UTF_8));
            BigInteger number = new BigInteger(1, hash);
            return number.toString(16).toLowerCase();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

