/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.PlatformUtils;
import org.jolokia.jvmagent.client.util.ProcessDescription;
import org.jolokia.jvmagent.client.util.ProcessingException;
import org.jolokia.jvmagent.client.util.ToolsClassFinder;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;

class VirtualMachineHandler
implements VirtualMachineHandlerOperations {
    private final OptionsAndArgs options;

    VirtualMachineHandler(OptionsAndArgs pOptions) {
        this.options = pOptions;
    }

    @Override
    public Object attachVirtualMachine() throws ProcessingException {
        if (this.options.getPid() == null && this.options.getProcessPattern() == null) {
            return null;
        }
        Class<?> vmClass = this.lookupVirtualMachineClass();
        String pid = null;
        try {
            Method method = vmClass.getMethod("attach", String.class);
            pid = PlatformUtils.getProcessId(this, this.options);
            return method.invoke(null, pid);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Internal: No method 'attach' found on " + vmClass, e, this.options);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException(this.getPidErrorMesssage(pid, "InvocationTarget", vmClass), e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException(this.getPidErrorMesssage(pid, "IllegalAccessException", vmClass), e, this.options);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingException("Illegal Argument", e, this.options);
        }
    }

    private String getPidErrorMesssage(String pid, String label, Class<?> vmClass) {
        return pid != null ? String.format("Cannot attach to process-ID %s (%s %s).\nSee --help for possible reasons.", pid, label, vmClass.getName()) : String.format("%s %s", label, vmClass.getName());
    }

    @Override
    public void detachAgent(Object pVm) {
        try {
            if (pVm != null) {
                Class<?> clazz = pVm.getClass();
                Method method = clazz.getMethod("detach", new Class[0]);
                method.setAccessible(true);
                method.invoke(pVm, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
    }

    @Override
    public List<ProcessDescription> listProcesses() {
        ArrayList<ProcessDescription> ret = new ArrayList<ProcessDescription>();
        Class<?> vmClass = this.lookupVirtualMachineClass();
        try {
            Method method = vmClass.getMethod("list", new Class[0]);
            List vmDescriptors = (List)method.invoke(null, new Object[0]);
            for (Object descriptor : vmDescriptors) {
                Method idMethod = descriptor.getClass().getMethod("id", new Class[0]);
                String id = (String)idMethod.invoke(descriptor, new Object[0]);
                Method displayMethod = descriptor.getClass().getMethod("displayName", new Class[0]);
                String display = (String)displayMethod.invoke(descriptor, new Object[0]);
                ret.add(new ProcessDescription(id, display));
            }
            return ret;
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Error while listing JVM processes", e, this.options);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("Error while listing JVM processes", e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("Error while listing JVM processes", e, this.options);
        }
    }

    @Override
    public ProcessDescription findProcess(Pattern pPattern) {
        return PlatformUtils.findProcess(pPattern, this.listProcesses());
    }

    @Override
    public void loadAgent(Object pVm, String jarFilePath, String args) throws ProcessingException {
        Class<?> clazz = pVm.getClass();
        try {
            Method method = clazz.getMethod("loadAgent", String.class, String.class);
            method.invoke(pVm, jarFilePath, args);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Error while loading Jolokia agent to a JVM process", e, this.options);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("Error while loading Jolokia agent to a JVM process", e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("Error while loading Jolokia agent to a JVM process", e, this.options);
        }
    }

    @Override
    public Properties getSystemProperties(Object pVm) {
        Class<?> clazz = pVm.getClass();
        try {
            Method method = clazz.getMethod("getSystemProperties", new Class[0]);
            return (Properties)method.invoke(pVm, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Error while getting system properties from a JVM process", e, this.options);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("Error while getting system properties from a JVM process", e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("Error while getting system properties from a JVM process", e, this.options);
        }
    }

    private Class<?> lookupVirtualMachineClass() {
        try {
            return ToolsClassFinder.lookupClass("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException exp) {
            throw new ProcessingException("Cannot find classes from tools.jar. The heuristics for loading tools.jar which contains\nessential classes (i.e. com.sun.tools.attach.VirtualMachine) for attaching to a running JVM\n ould not locate the necessary jar file.\n\nPlease call this launcher with a qualified classpath on the command line like\n\n   java -cp path/to/tools.jar:" + this.options.getJarFileName() + " org.jolokia.jvmagent.client.AgentLauncher [options] <command> <ppid>\n", exp, this.options);
        }
    }
}

