/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.admin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterStatus {
    private static final Logger log = LogManager.getLogger(ClusterStatus.class);
    public static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final String BROKERS_IDS_PATH = "/brokers/ids";
    public static final int BROKER_METADATA_REQUEST_BACKOFF_MS = 1000;

    public static boolean isKafkaReady(Map<String, String> config, int minBrokerCount, int timeoutMs) {
        AdminClient adminClient = AdminClient.create(new HashMap<String, String>(config));
        long begin = System.currentTimeMillis();
        long remainingWaitMs = timeoutMs;
        Collection brokers = new ArrayList();
        while (remainingWaitMs > 0L) {
            try {
                brokers = (Collection)adminClient.describeCluster(new DescribeClusterOptions().timeoutMs(Integer.valueOf((int)Math.min(Integer.MAX_VALUE, remainingWaitMs)))).nodes().get();
                log.debug("Broker list: {}", brokers != null ? brokers : "[]");
                if (brokers != null && brokers.size() >= minBrokerCount) {
                    return true;
                }
            }
            catch (Exception e) {
                log.error("Error while getting broker list.", (Throwable)e);
            }
            ClusterStatus.sleep(Math.min(1000L, remainingWaitMs));
            log.info("Expected {} brokers but found only {}. Trying to query Kafka for metadata again ...", (Object)minBrokerCount, (Object)(brokers == null ? 0 : brokers.size()));
            long elapsed = System.currentTimeMillis() - begin;
            remainingWaitMs = (long)timeoutMs - elapsed;
        }
        log.error("Expected {} brokers but found only {}. Brokers found {}.", (Object)minBrokerCount, (Object)(brokers == null ? 0 : brokers.size()), brokers != null ? brokers : "[]");
        return false;
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

