/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.admin.utils.cli;

import io.confluent.admin.utils.ClusterStatus;
import java.util.HashMap;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaReadyCommand {
    private static final Logger log = LogManager.getLogger(KafkaReadyCommand.class);
    public static final String KAFKA_READY = "kafka-ready";

    private static ArgumentParser createArgsParser() {
        ArgumentParser kafkaReady = ArgumentParsers.newArgumentParser((String)KAFKA_READY).defaultHelp(true).description("Check if Kafka is ready.");
        kafkaReady.addArgument(new String[]{"min-expected-brokers"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"MIN_EXPECTED_BROKERS"}).help("Minimum number of brokers to wait for.");
        kafkaReady.addArgument(new String[]{"timeout"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"TIMEOUT_IN_MS"}).help("Time (in ms) to wait for service to be ready.");
        kafkaReady.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"CONFIG"}).help("List of bootstrap brokers.");
        MutuallyExclusiveGroup kafkaOrZK = kafkaReady.addMutuallyExclusiveGroup();
        kafkaOrZK.addArgument(new String[]{"--bootstrap-servers", "-b"}).action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"BOOTSTRAP_SERVERS"}).help("List of bootstrap brokers.");
        kafkaOrZK.addArgument(new String[]{"--zookeeper-connect", "-z"}).action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"ZOOKEEPER_CONNECT"}).help("Zookeeper connect string.");
        kafkaReady.addArgument(new String[]{"--security-protocol", "-s"}).action((ArgumentAction)Arguments.store()).type(String.class).metavar(new String[]{"SECURITY_PROTOCOL"}).setDefault((Object)"PLAINTEXT").help("Which endpoint to connect to ? ");
        return kafkaReady;
    }

    public static void main(String[] args) {
        ArgumentParser parser = KafkaReadyCommand.createArgsParser();
        boolean success = false;
        try {
            Namespace res = parser.parseArgs(args);
            log.debug("Arguments {}. ", (Object)res);
            HashMap<String, String> workerProps = new HashMap<String, String>();
            if (res.getString("config") == null && !res.getString("security_protocol").equals("PLAINTEXT")) {
                log.error("config is required for all protocols except PLAINTEXT");
                success = false;
            } else {
                if (res.getString("config") != null) {
                    workerProps = Utils.propsToStringMap((Properties)Utils.loadProps((String)res.getString("config")));
                }
                if (res.getString("bootstrap_servers") == null) {
                    log.error("Bootstrap servers should be provided through config or bootstrap_servers");
                    throw new RuntimeException("Bootstrap servers should be provided through config or bootstrap_servers");
                }
                workerProps.put("bootstrap.servers", res.getString("bootstrap_servers"));
                success = ClusterStatus.isKafkaReady(workerProps, res.getInt("min_expected_brokers"), res.getInt("timeout"));
            }
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                success = true;
            } else {
                parser.handleError(e);
                success = false;
            }
        }
        catch (Exception e) {
            log.error("Error while running kafka-ready.", (Throwable)e);
            success = false;
        }
        if (success) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

