/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkaensure;

import io.confluent.kafkaensure.TopicSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;

public class TopicEnsure {
    private final AdminClient adminClient;

    public TopicEnsure(Properties props) {
        this.adminClient = AdminClient.create((Properties)props);
    }

    public boolean createTopic(TopicSpec spec, int timeOut) throws Exception {
        NewTopic newTopic = new NewTopic(spec.name(), spec.partitions(), (short)spec.replicationFactor());
        newTopic.configs(spec.config());
        CreateTopicsResult result = this.adminClient.createTopics(Collections.singletonList(newTopic), new CreateTopicsOptions().timeoutMs(Integer.valueOf(timeOut)));
        result.all().get();
        return true;
    }

    public boolean validateTopic(TopicSpec spec, int timeOut) throws Exception {
        DescribeTopicsResult topicDescribeResult = this.adminClient.describeTopics(Collections.singletonList(spec.name()), new DescribeTopicsOptions().timeoutMs(Integer.valueOf(timeOut)));
        TopicDescription topic = (TopicDescription)((Map)topicDescribeResult.allTopicNames().get()).get(spec.name());
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, spec.name());
        DescribeConfigsResult configResult = this.adminClient.describeConfigs(Collections.singletonList(configResource));
        Map resultMap = (Map)configResult.all().get();
        Config config = (Config)resultMap.get(configResource);
        HashMap<String, String> actualConfig = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : spec.config().entrySet()) {
            ConfigEntry actualConfigEntry = config.get(entry.getKey());
            if (actualConfigEntry == null) continue;
            actualConfig.put(entry.getKey(), actualConfigEntry.value());
        }
        TopicSpec actualSpec = new TopicSpec(topic.name(), topic.partitions().size(), ((TopicPartitionInfo)topic.partitions().get(0)).replicas().size(), actualConfig);
        boolean isTopicValid = actualSpec.equals(spec);
        if (!isTopicValid) {
            System.err.printf("Invalid topic [ %s ] ! Expected %s but got %s\n", spec.name(), spec, actualSpec);
        }
        return isTopicValid;
    }

    public boolean topicExists(TopicSpec spec, Integer timeOut) throws Exception {
        try {
            DescribeTopicsResult topicDescribeResult = this.adminClient.describeTopics(Collections.singletonList(spec.name()), new DescribeTopicsOptions().timeoutMs(timeOut));
            ((Map)topicDescribeResult.allTopicNames().get()).get(spec.name());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw e;
        }
        return true;
    }
}

