/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkaensure;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TopicSpec {
    public String name;
    public int partitions;
    public int replicationFactor;
    public Map<String, String> config;

    public TopicSpec() {
    }

    public TopicSpec(String name, int partitions, int replicationFactor, Map<String, String> config) {
        this.name = name;
        this.partitions = partitions;
        this.replicationFactor = replicationFactor;
        this.config = config;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int partitions() {
        return this.partitions;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public Map<String, String> config() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public void putInConfig(String key, String value) {
        this.config.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicSpec topicSpec = (TopicSpec)o;
        return this.partitions == topicSpec.partitions && this.replicationFactor == topicSpec.replicationFactor && Objects.equals(this.name, topicSpec.name) && Objects.equals(this.config, topicSpec.config);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.partitions, this.replicationFactor, this.config);
    }

    public String toString() {
        return "TopicSpec={name='" + this.name() + "', partitions='" + this.partitions() + "', replicationFactor=" + this.replicationFactor() + ", config=" + String.valueOf(this.config()) + "}";
    }

    public static class Topics {
        public List<TopicSpec> topics;

        public List<TopicSpec> topics() {
            return this.topics;
        }

        public void setTopics(List<TopicSpec> topics) {
            this.topics = topics;
        }

        public String toString() {
            return "Topics{topics=" + String.valueOf(this.topics) + "}";
        }
    }
}

