/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test;

import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.FaultHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockFaultHandler
implements FaultHandler {
    private static final Logger log = LoggerFactory.getLogger(MockFaultHandler.class);
    private final String name;
    private FaultHandlerException firstException = null;
    private boolean ignore = false;

    public MockFaultHandler(String name) {
        this.name = name;
    }

    public synchronized RuntimeException handleFault(String failureMessage, Throwable cause) {
        FaultHandlerException e;
        if (cause == null) {
            log.error("Encountered {} fault: {}", (Object)this.name, (Object)failureMessage);
        } else {
            log.error("Encountered {} fault: {}", new Object[]{this.name, failureMessage, cause});
        }
        FaultHandlerException faultHandlerException = e = cause == null ? new FaultHandlerException(this.name + ": " + failureMessage) : new FaultHandlerException(this.name + ": " + failureMessage + ": " + cause.getMessage(), cause);
        if (this.firstException == null) {
            this.firstException = e;
        }
        return this.firstException;
    }

    public synchronized void maybeRethrowFirstException() {
        if (this.firstException != null && !this.ignore) {
            throw this.firstException;
        }
    }

    public synchronized FaultHandlerException firstException() {
        return this.firstException;
    }

    public synchronized void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }
}

