/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Enumeration
extends SimpleCollector<Child>
implements Collector.Describable {
    private final Set<String> states;

    Enumeration(Builder b) {
        super(b);
        for (String label : this.labelNames) {
            if (!label.equals(this.fullname)) continue;
            throw new IllegalStateException("Enumeration cannot have a label named the same as its metric name.");
        }
        this.states = b.states;
        this.initializeNoLabelsChild();
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child(this.states);
    }

    public void state(String s) {
        ((Child)this.noLabelsChild).state(s);
    }

    public void state(Enum e) {
        ((Child)this.noLabelsChild).state(e);
    }

    public String get() {
        return ((Child)this.noLabelsChild).get();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            String v = ((Child)c.getValue()).get();
            ArrayList<String> labelNamesWithState = new ArrayList<String>(this.labelNames);
            labelNamesWithState.add(this.fullname);
            for (String s : this.states) {
                ArrayList<String> labelValuesWithState = new ArrayList<String>((Collection)c.getKey());
                labelValuesWithState.add(s);
                samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, labelNamesWithState, labelValuesWithState, s.equals(v) ? 1.0 : 0.0));
            }
        }
        return this.familySamplesList(Collector.Type.STATE_SET, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.fullname, Collector.Type.STATE_SET, this.help, Collections.<Collector.MetricFamilySamples.Sample>emptyList()));
    }

    public static class Child {
        private String value;
        private final Set<String> states;

        private Child(Set<String> states) {
            this.states = states;
            this.value = states.iterator().next();
        }

        public void state(String s) {
            if (!this.states.contains(s)) {
                throw new IllegalArgumentException("Unknown state " + s);
            }
            this.value = s;
        }

        public void state(Enum e) {
            this.state(e.name());
        }

        public String get() {
            return this.value;
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Enumeration> {
        private Set<String> states;

        public Builder states(String ... s) {
            if (s.length == 0) {
                throw new IllegalArgumentException("There must be at least one state");
            }
            this.states = new LinkedHashSet<String>();
            this.states.addAll(Arrays.asList(s));
            return this;
        }

        public Builder states(Class e) {
            T[] vals = e.getEnumConstants();
            String[] s = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                s[i] = ((Enum)vals[i]).name();
            }
            return this.states(s);
        }

        @Override
        public Enumeration create() {
            if (this.states == null) {
                throw new IllegalStateException("Enumeration states must be specified.");
            }
            if (!this.unit.isEmpty()) {
                throw new IllegalStateException("Enumeration metrics cannot have a unit.");
            }
            this.dontInitializeNoLabelsChild = true;
            return new Enumeration(this);
        }
    }
}

