/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.AuditJobHandle;
import io.confluent.rest.AuditJobHandler;
import io.confluent.rest.AuditJobRestApiResponseStatus;
import io.confluent.rest.ResponseContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class AuditJobHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Map<String, Set<Integer>> TOPIC_PARTITIONS_MAP = new HashMap<String, Set<Integer>>();
    private static final Map<String, String> AUDIT_JOB_STATUS_SUMMARY = new HashMap<String, String>();
    private static final Map<String, String> AUDIT_JOB_STATUS_DETAIL = new HashMap<String, String>();
    private MockedStatic<Content.Source> mockedContentSource;
    private MockedStatic<Content.Sink> mockedContentSink;

    @BeforeEach
    public void setUp() {
        this.mockedContentSource = Mockito.mockStatic(Content.Source.class);
        this.mockedContentSink = Mockito.mockStatic(Content.Sink.class);
    }

    @AfterEach
    public void tearDown() {
        this.mockedContentSource.close();
        this.mockedContentSink.close();
    }

    @Test
    public void testStartAuditJob() throws Exception {
        this.populateTopicPartitionsMap();
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("jobId", String.valueOf(1));
        responseMap.put("newJob", String.valueOf(true));
        responseMap.put("status", String.valueOf(AuditJobRestApiResponseStatus.success));
        AuditJobHandle handle = (AuditJobHandle)Mockito.mock(AuditJobHandle.class);
        Mockito.when((Object)handle.mayBeStartAuditJob(ArgumentMatchers.anyMap(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn(responseMap);
        AuditJobHandler auditJobHandler = new AuditJobHandler(handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/audit/start-audit-job");
        AuditJobHandler.StartAuditJobRequest startAuditJobRequest = new AuditJobHandler.StartAuditJobRequest(TOPIC_PARTITIONS_MAP, 0, false, false);
        byte[] startAuditJobRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)startAuditJobRequest);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(startAuditJobRequestBytes);
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        boolean result = auditJobHandler.handle(request, response, callback);
        Assertions.assertTrue((boolean)result);
        ((AuditJobHandle)Mockito.verify((Object)handle)).mayBeStartAuditJob(ArgumentMatchers.anyMap(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        String responseContent = outputStream.toString();
        Assertions.assertFalse((boolean)responseContent.isEmpty());
        ResponseContainer responseContainer = (ResponseContainer)OBJECT_MAPPER.readValue(responseContent, (TypeReference)new TypeReference<ResponseContainer<AuditJobHandler.StartAuditJobResponse>>(){});
        Assertions.assertEquals((int)1, (Integer)((AuditJobHandler.StartAuditJobResponse)responseContainer.data.attributes).jobId);
        Assertions.assertEquals((int)AuditJobRestApiResponseStatus.success, (Integer)((AuditJobHandler.StartAuditJobResponse)responseContainer.data.attributes).status);
        Assertions.assertTrue((boolean)((AuditJobHandler.StartAuditJobResponse)responseContainer.data.attributes).newJobStarted);
    }

    @Test
    public void testGetAuditJobStatus() throws Exception {
        this.populateTopicPartitionsMap();
        this.populateGetAuditJobStatusResponseSummaryMap();
        AuditJobHandle handle = (AuditJobHandle)Mockito.mock(AuditJobHandle.class);
        Mockito.when((Object)handle.mayBeGetAuditJobStatusSummary()).thenReturn(AUDIT_JOB_STATUS_SUMMARY);
        AuditJobHandler auditJobHandler = new AuditJobHandler(handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/audit/get-audit-job-status");
        AuditJobHandler.GetAuditJobStatusRequest getAuditJobStatusRequest = new AuditJobHandler.GetAuditJobStatusRequest(false);
        byte[] getAuditJobStatusRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)getAuditJobStatusRequest);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(getAuditJobStatusRequestBytes);
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        boolean result = auditJobHandler.handle(request, response, callback);
        Assertions.assertTrue((boolean)result);
        ((AuditJobHandle)Mockito.verify((Object)handle)).mayBeGetAuditJobStatusSummary();
        String responseContent = outputStream.toString();
        Assertions.assertFalse((boolean)responseContent.isEmpty());
        ResponseContainer responseContainer = (ResponseContainer)OBJECT_MAPPER.readValue(responseContent, (TypeReference)new TypeReference<ResponseContainer<AuditJobHandler.GetAuditJobStatusResponseSummary>>(){});
        Assertions.assertEquals((int)100, (Integer)((AuditJobHandler.GetAuditJobStatusResponseSummary)responseContainer.data.attributes).jobId);
        Assertions.assertEquals((Object)"InProgress", (Object)((AuditJobHandler.GetAuditJobStatusResponseSummary)responseContainer.data.attributes).status);
        Assertions.assertEquals((int)100000, (Integer)((AuditJobHandler.GetAuditJobStatusResponseSummary)responseContainer.data.attributes).totalOffsetCountAcrossPartitions);
        Assertions.assertEquals((int)0, (Integer)((AuditJobHandler.GetAuditJobStatusResponseSummary)responseContainer.data.attributes).totalGapCountAcrossPartitions);
    }

    private void populateTopicPartitionsMap() {
        TOPIC_PARTITIONS_MAP.put("topicA", new HashSet());
        TOPIC_PARTITIONS_MAP.get("topicA").add(0);
        TOPIC_PARTITIONS_MAP.get("topicA").add(1);
        TOPIC_PARTITIONS_MAP.get("topicA").add(2);
        TOPIC_PARTITIONS_MAP.get("topicA").add(3);
    }

    private void populateGetAuditJobStatusResponseSummaryMap() {
        AUDIT_JOB_STATUS_SUMMARY.put("jobId", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionsRequested", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("status", "InProgress");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionScannedSuccess", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionSkipped", "0");
        AUDIT_JOB_STATUS_SUMMARY.put("topicPartitionScanned", "100");
        AUDIT_JOB_STATUS_SUMMARY.put("totalTierCompactedPartitionsRequested", "0");
        AUDIT_JOB_STATUS_SUMMARY.put("totalOffsetCountAcrossPartitions", "100000");
        AUDIT_JOB_STATUS_SUMMARY.put("totalGapCountAcrossPartitions", "0");
        AUDIT_JOB_STATUS_SUMMARY.put("totalTimeTakeInMillis", "20000");
        AUDIT_JOB_STATUS_SUMMARY.put("jobType", "OnDemand");
        AUDIT_JOB_STATUS_SUMMARY.put("startTime", "123456");
        AUDIT_JOB_STATUS_SUMMARY.put("completionTime", "123457");
    }

    private void populateGetAuditJobStatusDetailMap() {
        AUDIT_JOB_STATUS_DETAIL.put("detail", "detail");
        AUDIT_JOB_STATUS_DETAIL.put("jobId", "100");
    }
}

