/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.ControllerRollHandler;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ControllerRollHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private MockedStatic<Content.Source> mockedContentSource;
    private MockedStatic<Content.Sink> mockedContentSink;

    @BeforeEach
    public void setUp() {
        this.mockedContentSource = Mockito.mockStatic(Content.Source.class);
        this.mockedContentSink = Mockito.mockStatic(Content.Sink.class);
    }

    @AfterEach
    public void tearDown() {
        this.mockedContentSource.close();
        this.mockedContentSink.close();
    }

    @Test
    public void testRollableStatusReport() throws Exception {
        MockUtil.MockControllerShutdownHandle handle = new MockUtil.MockControllerShutdownHandle();
        handle.rollable = true;
        handle.reason = "";
        ControllerRollHandler rollHandler = new ControllerRollHandler((BeginShutdownControllerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/status");
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<BeginShutdownControllerStatus>>(){});
        BeginShutdownControllerStatus expected = handle.generateRollableStatus();
        Assertions.assertEquals((Object)expected.rollable(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).rollable());
        Assertions.assertEquals((Object)expected.reason(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).reason());
    }

    @Test
    public void testNotRollableStatusReport() throws Exception {
        MockUtil.MockControllerShutdownHandle handle = new MockUtil.MockControllerShutdownHandle();
        handle.rollable = false;
        handle.reason = "The reason why";
        ControllerRollHandler rollHandler = new ControllerRollHandler((BeginShutdownControllerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/status");
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<BeginShutdownControllerStatus>>(){});
        BeginShutdownControllerStatus expected = handle.generateRollableStatus();
        Assertions.assertEquals((Object)expected.rollable(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).rollable());
        Assertions.assertEquals((Object)expected.reason(), (Object)((BeginShutdownControllerStatus)statusResponse.data.attributes).reason());
    }
}

