/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.rest.ForceRollSegmentsHandle;
import io.confluent.rest.ForceRollSegmentsHandler;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ForceRollSegmentsHandlerTest {
    private MockedStatic<Content.Source> mockedContentSource;
    private MockedStatic<Content.Sink> mockedContentSink;

    @BeforeEach
    public void setUp() {
        this.mockedContentSource = Mockito.mockStatic(Content.Source.class);
        this.mockedContentSink = Mockito.mockStatic(Content.Sink.class);
    }

    @AfterEach
    public void tearDown() {
        this.mockedContentSource.close();
        this.mockedContentSink.close();
    }

    @Test
    public void testForceRollSegments() throws Exception {
        Map<String, List<TopicPartition>> lkcToFailedPartitions = Map.of("lkc-1234", new ArrayList(), "lkc-5678", Arrays.asList(new TopicPartition("tp", 0), new TopicPartition("tp", 1)));
        ForceRollSegmentsHandle handle = (ForceRollSegmentsHandle)Mockito.mock(ForceRollSegmentsHandle.class);
        for (Map.Entry<String, List<TopicPartition>> entry : lkcToFailedPartitions.entrySet()) {
            Mockito.when((Object)handle.maybeForceRollSegments((String)ArgumentMatchers.eq((Object)entry.getKey()))).thenReturn(entry.getValue());
        }
        ForceRollSegmentsHandler forceRollSegmentsHandler = new ForceRollSegmentsHandler(handle);
        for (Map.Entry<String, List<TopicPartition>> entry : lkcToFailedPartitions.entrySet()) {
            Request request = (Request)Mockito.mock(Request.class);
            Response response = (Response)Mockito.mock(Response.class);
            HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
            Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
            Callback callback = (Callback)Mockito.mock(Callback.class);
            HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
            Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
            Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/tiertools/forcerollsegments");
            String lkc = entry.getKey();
            List failedPartitions = entry.getValue().stream().map(TopicPartition::toString).collect(Collectors.toList());
            ForceRollSegmentsHandler.ForceRollSegmentsRequest forceRollSegmentsRequest = new ForceRollSegmentsHandler.ForceRollSegmentsRequest(lkc);
            byte[] forceRollSegmentsRequestBytes = ForceRollSegmentsHandler.OBJECT_MAPPER.writeValueAsBytes((Object)forceRollSegmentsRequest);
            MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(forceRollSegmentsRequestBytes));
            this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
            MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
            this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
            forceRollSegmentsHandler.handle(request, response, callback);
            ResponseContainer stateResponse = (ResponseContainer)ForceRollSegmentsHandler.OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<ForceRollSegmentsHandler.ForceRollSegmentsResponse>>(){});
            Assertions.assertEquals(failedPartitions, (Object)((ForceRollSegmentsHandler.ForceRollSegmentsResponse)stateResponse.data.attributes).failedPartitions());
            Assertions.assertEquals((Object)failedPartitions.isEmpty(), (Object)((ForceRollSegmentsHandler.ForceRollSegmentsResponse)stateResponse.data.attributes).success());
        }
    }
}

