/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.CheckReadyControllerHandle;
import io.confluent.rest.CheckReadyControllerStatus;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.TierPartitionStateResponse;
import io.confluent.rest.TierRecordMetadataResponse;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Optional;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import scala.Tuple2;

public class MockUtil {

    public static class MockCheckReadyControllerHandle
    implements CheckReadyControllerHandle {
        boolean ready;
        String reason;

        public CheckReadyControllerStatus generateReadinessStatus() {
            return new CheckReadyControllerStatus(this.ready, this.reason);
        }

        public void close() {
        }
    }

    public static class MockControllerShutdownHandle
    implements BeginShutdownControllerHandle {
        boolean rollable;
        String reason;

        public BeginShutdownControllerStatus generateRollableStatus() {
            return new BeginShutdownControllerStatus(this.rollable, this.reason);
        }

        public void close() {
        }
    }

    public static class MockKafkaRestorePartitionHandle
    implements KafkaRestorePartitionHandle {
        int leaderReplica;
        TierPartitionStateResponse tierPartitionState = new TierPartitionStateResponse("test", 0, 1L, "");
        TierRecordMetadataResponse tierRecordMetadata = new TierRecordMetadataResponse("test_0", System.currentTimeMillis(), 1L, 0);
        int preCheckResult;

        public int leaderReplica(String topic, int partition) {
            return this.leaderReplica;
        }

        public TierPartitionStateResponse tierPartitionStatus(String topic, int partition) {
            return this.tierPartitionState;
        }

        public Optional<File> ftpsFile(String topic, int partition) {
            return Optional.empty();
        }

        public TierRecordMetadataResponse setFenceTierTopicPartition(String topic, int partition) {
            return this.tierRecordMetadata;
        }

        public TierRecordMetadataResponse setForceRestoreTierPartition(String topic, int partition, long startOffset, long endOffset, String contentHash, byte checksumAlgorithm) {
            return this.tierRecordMetadata;
        }

        public TierRecordMetadataResponse setUnfreezeLogStartOffset(String topic, int partition) {
            return this.tierRecordMetadata;
        }

        public int validateLogRange(String topic, int partition, long startOffset, long endOffset) {
            return 1;
        }

        public int preChecksForRestore(String topic, int partition) {
            return this.preCheckResult;
        }
    }

    public static class MockServletInputStream
    extends ServletInputStream {
        public final ByteArrayInputStream bais;

        MockServletInputStream(ByteArrayInputStream bais) {
            this.bais = bais;
        }

        public boolean isFinished() {
            return this.bais.available() > 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() {
            return this.bais.read();
        }
    }

    public static class MockServletOutputStream
    extends ServletOutputStream {
        public final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        MockServletOutputStream() {
        }

        public void write(int i) {
            this.baos.write(i);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    public static class MockBrokerShutdownHandle
    implements BeginShutdownBrokerHandle {
        long brokerId;
        long brokerEpoch;
        Integer controllerId;
        long underReplicatedPartitions;
        boolean shutdownTriggered = false;
        Tuple2<Boolean, String> rollable;

        public long brokerId() {
            return this.brokerId;
        }

        public long brokerEpoch() {
            return this.brokerEpoch;
        }

        public Integer controllerId() {
            return this.controllerId;
        }

        public long underReplicatedPartitions() {
            return this.underReplicatedPartitions;
        }

        public Tuple2<Boolean, String> rollable() {
            return this.rollable;
        }

        public void beginShutdown(long brokerEpoch) throws StaleBrokerEpochException {
            if (this.brokerEpoch != brokerEpoch) {
                throw new StaleBrokerEpochException("");
            }
            this.shutdownTriggered = true;
        }
    }
}

