/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RestoreHandler;
import io.confluent.rest.RollHandler;
import io.confluent.rest.TierPartitionStateResponse;
import io.confluent.rest.TierRecordMetadataResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Optional;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class RestoreHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private MockedStatic<Content.Source> mockedContentSource;
    private MockedStatic<Content.Sink> mockedContentSink;

    @BeforeEach
    public void setUp() {
        this.mockedContentSource = Mockito.mockStatic(Content.Source.class);
        this.mockedContentSink = Mockito.mockStatic(Content.Sink.class);
    }

    @AfterEach
    public void tearDown() {
        this.mockedContentSource.close();
        this.mockedContentSink.close();
    }

    @Test
    public void testFtpsFileDownloadNotFound() throws Exception {
        KafkaRestorePartitionHandle handle = (KafkaRestorePartitionHandle)Mockito.mock(KafkaRestorePartitionHandle.class);
        RestoreHandler restoreHandler = new RestoreHandler(handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/ftps");
        RestoreHandler.FtpsDownloadRequest ftpsDownloadRequest = new RestoreHandler.FtpsDownloadRequest("test", 0);
        byte[] ftpsDownloadRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)ftpsDownloadRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(ftpsDownloadRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertNull((Object)statusResponse.data, (String)"expected no data in response");
        Assertions.assertEquals((int)statusResponse.errors.size(), (int)1, (String)"expected one error struct");
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).status, (int)500);
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).id, (int)0);
    }

    @Test
    public void testFtpsFileDownload() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5000; ++i) {
            sb.append("a");
        }
        String inputFtpsContent = sb.toString();
        File ftpsFile = File.createTempFile("ftps-temp", null);
        FileOutputStream ftpsOutputStream = new FileOutputStream(ftpsFile.getAbsolutePath());
        byte[] strToBytes = inputFtpsContent.getBytes();
        ftpsOutputStream.write(strToBytes);
        ftpsOutputStream.close();
        ftpsFile.deleteOnExit();
        KafkaRestorePartitionHandle handle = (KafkaRestorePartitionHandle)Mockito.mock(KafkaRestorePartitionHandle.class);
        Mockito.when((Object)handle.ftpsFile(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(ftpsFile));
        RestoreHandler restoreHandler = new RestoreHandler(handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/ftps");
        RestoreHandler.FtpsDownloadRequest ftpsDownloadRequest = new RestoreHandler.FtpsDownloadRequest("test", 0);
        byte[] ftpsDownloadRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)ftpsDownloadRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(ftpsDownloadRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        byte[] outputFtpsContent = outputStream.baos.toByteArray();
        Assertions.assertEquals((Object)inputFtpsContent, (Object)new String(outputFtpsContent));
    }

    @Test
    public void testGetTierState() throws Exception {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        handle.leaderReplica = 1;
        handle.tierPartitionState = new TierPartitionStateResponse("test", 0, 1L, "");
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/tier-state");
        RestoreHandler.TierPartitionStatusRequest tierPartitionStateRequest = new RestoreHandler.TierPartitionStatusRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionStateRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<TierPartitionStateResponse>>(){});
        Assertions.assertEquals((long)handle.leaderReplica, (long)((TierPartitionStateResponse)stateResponse.data.attributes).tierPartitionState);
    }

    @Test
    public void testGetLeaderReplica() throws Exception {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        handle.leaderReplica = 1;
        handle.tierPartitionState = new TierPartitionStateResponse("test", 0, 1L, "");
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/leader-replica");
        RestoreHandler.LeaderReplicaRequest tierPartitionStateRequest = new RestoreHandler.LeaderReplicaRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionStateRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.LeaderReplicaResponse>>(){});
        Assertions.assertEquals((int)handle.leaderReplica, (int)((RestoreHandler.LeaderReplicaResponse)stateResponse.data.attributes).broker);
    }

    @Test
    public void testSetFenceTierPartitionState() throws Exception {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/fence");
        RestoreHandler.TierPartitionFenceRequest tierPartitionFenceRequest = new RestoreHandler.TierPartitionFenceRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionFenceRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<TierRecordMetadataResponse>>(){});
        Assertions.assertNotNull((Object)stateResponse);
        Assertions.assertEquals((long)1L, (long)((TierRecordMetadataResponse)stateResponse.data.attributes).offset);
    }

    @Test
    public void testUnfreezeTierPartitionState() throws Exception {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/unfreeze");
        RestoreHandler.TierPartitionUnfreezeRequest tierPartitionUnfreezeRequest = new RestoreHandler.TierPartitionUnfreezeRequest("test", 0);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionUnfreezeRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<TierRecordMetadataResponse>>(){});
        Assertions.assertNotNull((Object)stateResponse);
        Assertions.assertEquals((long)1L, (long)((TierRecordMetadataResponse)stateResponse.data.attributes).offset);
    }

    @Test
    public void testRestoreTierPartitionState() throws Exception {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/restore");
        RestoreHandler.TierPartitionRestoreRequest tierPartitionRestoreRequest = new RestoreHandler.TierPartitionRestoreRequest("test", 0, 0L, 100L, "testHash", 1);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)tierPartitionRestoreRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<TierRecordMetadataResponse>>(){});
        Assertions.assertNotNull((Object)stateResponse);
        Assertions.assertEquals((long)1L, (long)((TierRecordMetadataResponse)stateResponse.data.attributes).offset);
    }

    @Test
    public void validateLogRangeTest() throws Exception {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/validate-log-range");
        RestoreHandler.ValidateLogRangeRequest validateLogRangeRequest = new RestoreHandler.ValidateLogRangeRequest("test", 0, 0L, 100L);
        byte[] tierPartitionRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)validateLogRangeRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(tierPartitionRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.TierPartitionStateSetResponse>>(){});
        Assertions.assertEquals((int)1, (int)((RestoreHandler.TierPartitionStateSetResponse)stateResponse.data.attributes).response);
    }

    @Test
    public void testPreChecks() throws Exception {
        MockUtil.MockKafkaRestorePartitionHandle handle = new MockUtil.MockKafkaRestorePartitionHandle();
        handle.preCheckResult = 1;
        RestoreHandler restoreHandler = new RestoreHandler((KafkaRestorePartitionHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/restore/pre-checks");
        RestoreHandler.PreChecksRequest preChecksRequest = new RestoreHandler.PreChecksRequest("test", 0);
        byte[] preChecksRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)preChecksRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(preChecksRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        restoreHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RestoreHandler.TierPartitionStateSetResponse>>(){});
        Assertions.assertEquals((int)1, (int)((RestoreHandler.TierPartitionStateSetResponse)stateResponse.data.attributes).response);
    }
}

