/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.rest.GetTierRecoveryDataUploadJobResultRequest;
import io.confluent.rest.GetTierRecoveryDataUploadJobResultResponse;
import io.confluent.rest.InitiateTierRecoveryDataUploadRequest;
import io.confluent.rest.InitiateTierRecoveryDataUploadResponse;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RewindTierTopicConsumerRequest;
import io.confluent.rest.RewindTierTopicConsumerResponse;
import io.confluent.rest.TierMetadataRecoveryHandle;
import io.confluent.rest.TierMetadataRecoveryHandler;
import io.confluent.rest.TierRecoveryDataUploadResult;
import io.confluent.rest.TierTopicHeadDataLossDetectionRequest;
import io.confluent.rest.TierTopicHeadDataLossDetectionResponse;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TierMetadataRecoveryHandlerTest {
    private MockedStatic<Content.Source> mockedContentSource;
    private MockedStatic<Content.Sink> mockedContentSink;

    @BeforeEach
    public void setUp() {
        this.mockedContentSource = Mockito.mockStatic(Content.Source.class);
        this.mockedContentSink = Mockito.mockStatic(Content.Sink.class);
    }

    @AfterEach
    public void tearDown() {
        this.mockedContentSource.close();
        this.mockedContentSink.close();
    }

    @Test
    public void testRewindTierTopicConsumer() throws Exception {
        HashMap partitionToPositionMap = new HashMap();
        long offset = 12345L;
        int epoch = 5;
        for (int i = 0; i < 5; ++i) {
            Optional<Object> epochOpt = Optional.empty();
            if (i % 2 == 0) {
                epochOpt = Optional.of(epoch);
            }
            partitionToPositionMap.put(i, Collections.singletonMap(offset, epochOpt));
        }
        Map<String, Set<Integer>> skippedPartitions = Collections.singletonMap("logDir", Collections.singleton(5));
        TierMetadataRecoveryHandle handle = (TierMetadataRecoveryHandle)Mockito.mock(TierMetadataRecoveryHandle.class);
        Mockito.when((Object)handle.maybeRewindTierTopicConsumer((Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyByte())).thenReturn(skippedPartitions);
        TierMetadataRecoveryHandler tierMetadataRecoveryHandler = new TierMetadataRecoveryHandler(handle, 30000L);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/tiermetadata/tiertopicconsumer/rewind");
        RewindTierTopicConsumerRequest rewindTierTopicConsumerRequest = new RewindTierTopicConsumerRequest(partitionToPositionMap, false, 0);
        byte[] rewindTierTopicConsumerRequestBytes = TierMetadataRecoveryHandler.OBJECT_MAPPER.writeValueAsBytes((Object)rewindTierTopicConsumerRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(rewindTierTopicConsumerRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        tierMetadataRecoveryHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)TierMetadataRecoveryHandler.OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RewindTierTopicConsumerResponse>>(){});
        Assertions.assertEquals(skippedPartitions, (Object)((RewindTierTopicConsumerResponse)stateResponse.data.attributes).skippedPartitions());
    }

    @Test
    public void testRewindTierTopicConsumerToStart() throws Exception {
        Map<String, Set<Integer>> skippedPartitions = Collections.singletonMap("logDir", Collections.singleton(10));
        TierMetadataRecoveryHandle handle = (TierMetadataRecoveryHandle)Mockito.mock(TierMetadataRecoveryHandle.class);
        Mockito.when((Object)handle.maybeRewindTierTopicConsumer((Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyByte())).thenReturn(skippedPartitions);
        TierMetadataRecoveryHandler tierMetadataRecoveryHandler = new TierMetadataRecoveryHandler(handle, 30000L);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/tiermetadata/tiertopicconsumer/rewind");
        RewindTierTopicConsumerRequest rewindTierTopicConsumerRequest = new RewindTierTopicConsumerRequest(null, false, 0);
        byte[] rewindTierTopicConsumerRequestBytes = TierMetadataRecoveryHandler.OBJECT_MAPPER.writeValueAsBytes((Object)rewindTierTopicConsumerRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(rewindTierTopicConsumerRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        tierMetadataRecoveryHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)TierMetadataRecoveryHandler.OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RewindTierTopicConsumerResponse>>(){});
        Assertions.assertEquals(skippedPartitions, (Object)((RewindTierTopicConsumerResponse)stateResponse.data.attributes).skippedPartitions());
    }

    @Test
    public void testInitiateTierRecoveryDataUpload() throws Exception {
        HashSet<TopicIdPartition> topicIdPartitions = new HashSet<TopicIdPartition>();
        for (int i = 0; i < 5; ++i) {
            topicIdPartitions.add(new TopicIdPartition(Uuid.randomUuid(), i, "topic"));
        }
        String identifier = "rcca";
        int numThreads = 1;
        UUID jobId = UUID.randomUUID();
        TierMetadataRecoveryHandle handle = (TierMetadataRecoveryHandle)Mockito.mock(TierMetadataRecoveryHandle.class);
        Mockito.when((Object)handle.maybeInitiateTierRecoveryDataUpload(ArgumentMatchers.anySet(), ArgumentMatchers.anyString(), ArgumentMatchers.anyInt())).thenReturn((Object)jobId);
        TierMetadataRecoveryHandler tierMetadataRecoveryHandler = new TierMetadataRecoveryHandler(handle, 30000L);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/tiermetadata/upload/initiate");
        InitiateTierRecoveryDataUploadRequest initiateTierRecoveryDataUploadRequest = new InitiateTierRecoveryDataUploadRequest(topicIdPartitions, identifier, numThreads);
        byte[] initiateTierRecoveryDataUploadRequestBytes = TierMetadataRecoveryHandler.OBJECT_MAPPER.writeValueAsBytes((Object)initiateTierRecoveryDataUploadRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(initiateTierRecoveryDataUploadRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        tierMetadataRecoveryHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)TierMetadataRecoveryHandler.OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<InitiateTierRecoveryDataUploadResponse>>(){});
        Assertions.assertEquals((Object)jobId, (Object)((InitiateTierRecoveryDataUploadResponse)stateResponse.data.attributes).jobId());
    }

    @Test
    public void testGetTierRecoveryDataUploadJobResult() throws Exception {
        UUID jobId = UUID.randomUUID();
        Uuid topicId = Uuid.randomUuid();
        String identifier = "rcca-1234";
        TierRecoveryDataUploadResult.TierRecoveryDataUploadJobStatus status = TierRecoveryDataUploadResult.TierRecoveryDataUploadJobStatus.RUNNING;
        boolean metadataUploadCompleted = false;
        String metadataUploadFailedExceptionMessage = "metadata upload failed";
        boolean tierOffsetsUploadCompleted = true;
        HashMap<TopicIdPartition, String> failedTopicPartitions = new HashMap<TopicIdPartition, String>();
        for (int i = 0; i < 5; ++i) {
            if (i % 2 != 0) continue;
            failedTopicPartitions.put(new TopicIdPartition(topicId, i, "topic"), "some exception");
        }
        TierRecoveryDataUploadResult result = new TierRecoveryDataUploadResult(identifier, status, failedTopicPartitions, metadataUploadCompleted, metadataUploadFailedExceptionMessage, tierOffsetsUploadCompleted, null);
        TierMetadataRecoveryHandle handle = (TierMetadataRecoveryHandle)Mockito.mock(TierMetadataRecoveryHandle.class);
        Mockito.when((Object)handle.maybeGetTierRecoveryDataUploadJobResult((UUID)ArgumentMatchers.any(UUID.class))).thenReturn((Object)result);
        TierMetadataRecoveryHandler tierMetadataRecoveryHandler = new TierMetadataRecoveryHandler(handle, 30000L);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/tiermetadata/upload/result");
        GetTierRecoveryDataUploadJobResultRequest getTierRecoveryDataUploadJobResultRequest = new GetTierRecoveryDataUploadJobResultRequest(jobId);
        byte[] getTierRecoveryDataUploadJobResultRequestBytes = TierMetadataRecoveryHandler.OBJECT_MAPPER.writeValueAsBytes((Object)getTierRecoveryDataUploadJobResultRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(getTierRecoveryDataUploadJobResultRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        tierMetadataRecoveryHandler.handle(request, response, callback);
        ResponseContainer stateResponse = (ResponseContainer)TierMetadataRecoveryHandler.OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<GetTierRecoveryDataUploadJobResultResponse>>(){});
        Assertions.assertEquals((Object)result, (Object)((GetTierRecoveryDataUploadJobResultResponse)stateResponse.data.attributes).result());
    }

    @Test
    public void testDetectDataLossInTierTopicHead() throws Exception {
        TierMetadataRecoveryHandle handle = (TierMetadataRecoveryHandle)Mockito.mock(TierMetadataRecoveryHandle.class);
        TierTopicHeadDataLossDetectionResponse detectionResponse = new TierTopicHeadDataLossDetectionResponse("/path/to/report", TierTopicHeadDataLossDetectionResponse.CompletionStatus.FAILURE, Arrays.asList("error1"));
        Mockito.when((Object)handle.maybeDetectDataLossInTierTopicHead((TierTopicHeadDataLossDetectionRequest)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)detectionResponse);
        TierMetadataRecoveryHandler tierMetadataRecoveryHandler = new TierMetadataRecoveryHandler(handle, 30000L);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/tiermetadata/tiertopicdatalossvalidator/detectheaddataloss");
        TierTopicHeadDataLossDetectionRequest detectionRequest = new TierTopicHeadDataLossDetectionRequest("test-identifier", new HashSet());
        byte[] detectionRequestBytes = TierMetadataRecoveryHandler.OBJECT_MAPPER.writeValueAsBytes((Object)detectionRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(detectionRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        tierMetadataRecoveryHandler.handle(request, response, callback);
        ResponseContainer receivedDetectionResponse = (ResponseContainer)TierMetadataRecoveryHandler.OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<TierTopicHeadDataLossDetectionResponse>>(){});
        Assertions.assertEquals((Object)detectionResponse, (Object)receivedDetectionResponse.data.attributes);
    }
}

