/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.utils.Utils;

public class InternalRestServerConfig
extends AbstractConfig {
    public static final String CONFIG_PREFIX = "confluent.internal.rest.server.";
    public static final Boolean SSL_ENABLE_DYNAMIC_STORE_UPDATE_DEFAULT = false;

    private static ConfigDef DefaultConfigDef() {
        ConfigDef configDef = new ConfigDef();
        configDef.withClientSslSupport();
        configDef.define("confluent.internal.rest.server.bind.port", ConfigDef.Type.INT, (Object)ConfluentConfigs.INTERNAL_REST_SERVER_BIND_PORT_DEFAULT, ConfigDef.Importance.HIGH, "The port to bind the internal rest server to.").define("confluent.internal.rest.server.ssl.enable", ConfigDef.Type.BOOLEAN, (Object)ConfluentConfigs.INTERNAL_REST_SERVER_SSL_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether to enable SSL for internal broker rest server, defaults to false").define("security.providers", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "A list of configurable creator classes each returning a provider implementing security algorithms. These classes should implement the <code>org.apache.kafka.common.security.auth.SecurityProviderCreator</code> interface.").define("confluent.ssl.enable.dynamic.store.update", ConfigDef.Type.BOOLEAN, (Object)SSL_ENABLE_DYNAMIC_STORE_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, "A list of configurable creator classes each returning a provider implementing security algorithms. These classes should implement the <code>org.apache.kafka.common.security.auth.SecurityProviderCreator</code> interface.");
        return configDef;
    }

    public InternalRestServerConfig(Map<?, ?> props) {
        super(InternalRestServerConfig.DefaultConfigDef(), props, true);
    }

    public InternalRestServerConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props, true);
    }

    public String printSslConfigs() {
        Map sslConfigValues = this.valuesWithPrefixAllOrNothing(CONFIG_PREFIX);
        StringBuilder b = new StringBuilder();
        b.append("InternalRestServer SSL Config values: ");
        b.append(Utils.NL);
        for (Map.Entry entry : new TreeMap(sslConfigValues).entrySet()) {
            b.append('\t');
            b.append((String)entry.getKey());
            b.append(" = ");
            b.append(entry.getValue());
            b.append(Utils.NL);
        }
        return b.toString();
    }
}

