/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.MockUtil;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RollHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import scala.Tuple2;

public class RollHandlerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private MockedStatic<Content.Source> mockedContentSource;
    private MockedStatic<Content.Sink> mockedContentSink;

    @BeforeEach
    public void setUp() {
        this.mockedContentSource = Mockito.mockStatic(Content.Source.class);
        this.mockedContentSink = Mockito.mockStatic(Content.Sink.class);
    }

    @AfterEach
    public void tearDown() {
        this.mockedContentSource.close();
        this.mockedContentSink.close();
    }

    @Test
    public void testStatusReport() throws Exception {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/status");
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertEquals((long)handle.brokerId, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerId);
        Assertions.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assertions.assertEquals((long)handle.underReplicatedPartitions, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).underReplicatedPartitions);
        Assertions.assertEquals((Integer)handle.controllerId, (Integer)((RollHandler.StatusResponse)statusResponse.data.attributes).controllerId);
    }

    @Test
    public void testStatusReportNoController() throws Exception {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = null;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/status");
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertEquals((long)handle.brokerId, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerId);
        Assertions.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assertions.assertEquals((long)handle.underReplicatedPartitions, (long)((RollHandler.StatusResponse)statusResponse.data.attributes).underReplicatedPartitions);
        Assertions.assertEquals((Integer)handle.controllerId, (Integer)((RollHandler.StatusResponse)statusResponse.data.attributes).controllerId);
    }

    @Test
    public void testBeginShutdown() throws Exception {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/shutdown");
        RollHandler.ShutdownRequest shutdownRequest = new RollHandler.ShutdownRequest(handle.brokerId, handle.brokerEpoch);
        byte[] shutdownRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)shutdownRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(shutdownRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        Assertions.assertTrue((boolean)handle.shutdownTriggered);
    }

    @Test
    public void testBeginShutdownIncorrectEpoch() throws Exception {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/shutdown");
        RollHandler.ShutdownRequest shutdownRequest = new RollHandler.ShutdownRequest(handle.brokerId, handle.brokerEpoch - 1L);
        byte[] shutdownRequestBytes = OBJECT_MAPPER.writeValueAsBytes((Object)shutdownRequest);
        MockUtil.MockServletInputStream inputStream = new MockUtil.MockServletInputStream(new ByteArrayInputStream(shutdownRequestBytes));
        this.mockedContentSource.when(() -> Content.Source.asInputStream((Content.Source)((Content.Source)ArgumentMatchers.any()))).thenReturn((Object)inputStream);
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.StatusResponse>>(){});
        Assertions.assertNull((Object)statusResponse.data, (String)"expected no data in response");
        Assertions.assertEquals((int)statusResponse.errors.size(), (int)1, (String)"expected one error struct");
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).status, (int)500);
        Assertions.assertEquals((int)((ResponseContainer.ErrorResponse)statusResponse.errors.get((int)0)).id, (int)0);
    }

    @Test
    public void testRollStatusReport_Rollable() throws Exception {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.rollable = new Tuple2((Object)true, (Object)"");
        handle.underReplicatedPartitions = 0L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/rollStatus");
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.RollStatusResponse>>(){});
        Assertions.assertEquals((long)handle.brokerId, (long)((RollHandler.RollStatusResponse)statusResponse.data.attributes).brokerId);
        Assertions.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.RollStatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assertions.assertEquals((Integer)handle.controllerId, (Integer)((RollHandler.RollStatusResponse)statusResponse.data.attributes).controllerId);
        Assertions.assertEquals((Object)handle.rollable._1, (Object)((RollHandler.RollStatusResponse)statusResponse.data.attributes).rollable);
        Assertions.assertEquals((Object)handle.rollable._2, (Object)((RollHandler.RollStatusResponse)statusResponse.data.attributes).reason);
    }

    @Test
    public void testRollStatusReport_notRollable_hasURP() throws Exception {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.rollable = new Tuple2((Object)false, (Object)"Broker id=1 is not rollable because it has 1 Under Replicated Partitions.");
        handle.underReplicatedPartitions = 1L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/rollStatus");
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.RollStatusResponse>>(){});
        Assertions.assertEquals((long)handle.brokerId, (long)((RollHandler.RollStatusResponse)statusResponse.data.attributes).brokerId);
        Assertions.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.RollStatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assertions.assertEquals((Integer)handle.controllerId, (Integer)((RollHandler.RollStatusResponse)statusResponse.data.attributes).controllerId);
        Assertions.assertEquals((Object)handle.rollable._1, (Object)((RollHandler.RollStatusResponse)statusResponse.data.attributes).rollable);
        Assertions.assertEquals((Object)handle.rollable._2, (Object)((RollHandler.RollStatusResponse)statusResponse.data.attributes).reason);
    }

    @Test
    public void testRollStatusReport_notRollable_hasImbalancedPartitions() throws Exception {
        MockUtil.MockBrokerShutdownHandle handle = new MockUtil.MockBrokerShutdownHandle();
        handle.brokerId = 10L;
        handle.brokerEpoch = 42L;
        handle.rollable = new Tuple2((Object)false, (Object)"Broker id=1 is not rollable because it has not finished preferred leader election.");
        handle.underReplicatedPartitions = 0L;
        handle.controllerId = 2;
        RollHandler rollHandler = new RollHandler((BeginShutdownBrokerHandle)handle);
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        HttpFields.Mutable headers = (HttpFields.Mutable)Mockito.mock(HttpFields.Mutable.class);
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        HttpURI uri = (HttpURI)Mockito.mock(HttpURI.class);
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)uri);
        Mockito.when((Object)uri.getPath()).thenReturn((Object)"/v1/roll/rollStatus");
        MockUtil.MockServletOutputStream outputStream = new MockUtil.MockServletOutputStream();
        this.mockedContentSink.when(() -> Content.Sink.asOutputStream((Content.Sink)((Content.Sink)ArgumentMatchers.any()))).thenReturn((Object)outputStream);
        rollHandler.handle(request, response, callback);
        ResponseContainer statusResponse = (ResponseContainer)OBJECT_MAPPER.readValue(outputStream.baos.toByteArray(), (TypeReference)new TypeReference<ResponseContainer<RollHandler.RollStatusResponse>>(){});
        Assertions.assertEquals((long)handle.brokerId, (long)((RollHandler.RollStatusResponse)statusResponse.data.attributes).brokerId);
        Assertions.assertEquals((long)handle.brokerEpoch, (long)((RollHandler.RollStatusResponse)statusResponse.data.attributes).brokerEpoch);
        Assertions.assertEquals((Integer)handle.controllerId, (Integer)((RollHandler.RollStatusResponse)statusResponse.data.attributes).controllerId);
        Assertions.assertEquals((Object)handle.rollable._1, (Object)((RollHandler.RollStatusResponse)statusResponse.data.attributes).rollable);
        Assertions.assertEquals((Object)handle.rollable._2, (Object)((RollHandler.RollStatusResponse)statusResponse.data.attributes).reason);
    }
}

