/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.AuditJobHandle;
import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.BrokerStartupStatusHandle;
import io.confluent.rest.ForceRollSegmentsHandle;
import io.confluent.rest.InternalRestServer;
import io.confluent.rest.InternalRestServerConfig;
import io.confluent.rest.InternalRestServerSSL;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.TierMetadataRecoveryHandle;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SslConfigTest {
    private static final String TEST_SSL_PROTOCOL = "TLSv1.2";
    private static final String TEST_REST_SERVER_BIND_PORT = "9080";
    private static final String TEST_SSL_KEYSTORE_TYPE = "PKCS12";
    private static final String TEST_SSL_KEYSTORE_LOCATION;
    private static final String TEST_SSL_KEY_PASSWORD = "key_password";
    private static final String TEST_SSL_KEYSTORE_PASSWORD = "keystore_password";
    private static final String FILE_PREFIX = "file://";
    private BeginShutdownBrokerHandle beginShutdownBrokerHandle = (BeginShutdownBrokerHandle)Mockito.mock(BeginShutdownBrokerHandle.class);
    private KafkaRestorePartitionHandle kafkaRestorePartitionHandle = (KafkaRestorePartitionHandle)Mockito.mock(KafkaRestorePartitionHandle.class);
    private AuditJobHandle auditJobHandle = (AuditJobHandle)Mockito.mock(AuditJobHandle.class);
    private TierMetadataRecoveryHandle tierMetadataRecoveryHandle = (TierMetadataRecoveryHandle)Mockito.mock(TierMetadataRecoveryHandle.class);
    private ForceRollSegmentsHandle forceRollSegmentsHandle = (ForceRollSegmentsHandle)Mockito.mock(ForceRollSegmentsHandle.class);
    private BrokerStartupStatusHandle brokerStartupStatusHandle = (BrokerStartupStatusHandle)Mockito.mock(BrokerStartupStatusHandle.class);

    @Test
    public void testCreateSslContextFactoryCustom() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ssl.protocol", "Null");
        props.put("ssl.keystore.type", "Null");
        props.put("ssl.keystore.location", "Null");
        props.put("ssl.key.password", "Null");
        props.put("ssl.keystore.password", "Null");
        props.put("ssl.provider", null);
        props.put("confluent.internal.rest.server.ssl.protocol", TEST_SSL_PROTOCOL);
        props.put("confluent.internal.rest.server.bind.port", TEST_REST_SERVER_BIND_PORT);
        props.put("Whether to enable SSL for internal broker rest server, defaults to false", "true");
        props.put("confluent.internal.rest.server.ssl.keystore.type", TEST_SSL_KEYSTORE_TYPE);
        props.put("confluent.internal.rest.server.ssl.keystore.location", TEST_SSL_KEYSTORE_LOCATION);
        props.put("confluent.internal.rest.server.ssl.key.password", TEST_SSL_KEY_PASSWORD);
        props.put("confluent.internal.rest.server.ssl.keystore.password", TEST_SSL_KEYSTORE_PASSWORD);
        props.put("confluent.internal.rest.server.ssl.provider", null);
        props.put("security.providers", null);
        InternalRestServerConfig config = new InternalRestServerConfig(props);
        SslContextFactory.Server ssl = InternalRestServerSSL.createServerSideSslContextFactory((AbstractConfig)config, (String)"confluent.internal.rest.server.");
        Assertions.assertEquals((Object)ssl.getKeyStorePath(), (Object)(FILE_PREFIX + TEST_SSL_KEYSTORE_LOCATION));
        Assertions.assertNull((Object)ssl.getKeyStoreProvider());
        Assertions.assertNull((Object)ssl.getProvider());
    }

    @Test
    public void testServerSslConfigs() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("confluent.internal.rest.server.ssl.protocol", TEST_SSL_PROTOCOL);
        props.put("confluent.internal.rest.server.bind.port", TEST_REST_SERVER_BIND_PORT);
        props.put("Whether to enable SSL for internal broker rest server, defaults to false", "true");
        props.put("confluent.internal.rest.server.ssl.keystore.type", TEST_SSL_KEYSTORE_TYPE);
        props.put("confluent.internal.rest.server.ssl.keystore.location", TEST_SSL_KEYSTORE_LOCATION);
        props.put("confluent.internal.rest.server.ssl.key.password", TEST_SSL_KEY_PASSWORD);
        props.put("confluent.internal.rest.server.ssl.keystore.password", TEST_SSL_KEYSTORE_PASSWORD);
        props.put("confluent.internal.rest.server.ssl.provider", null);
        props.put("security.providers", null);
        InternalRestServer server = new InternalRestServer(props, this.beginShutdownBrokerHandle, this.kafkaRestorePartitionHandle, this.auditJobHandle, this.tierMetadataRecoveryHandle, this.forceRollSegmentsHandle, this.brokerStartupStatusHandle);
        InternalRestServerConfig config = server.getConfigs();
        Map sslConfigs = config.valuesWithPrefixAllOrNothing("confluent.internal.rest.server.");
        Assertions.assertEquals(sslConfigs.get("ssl.keystore.location"), (Object)TEST_SSL_KEYSTORE_LOCATION);
        Assertions.assertEquals((Integer)config.getInt("confluent.internal.rest.server.bind.port"), (int)Integer.parseInt(TEST_REST_SERVER_BIND_PORT));
        Assertions.assertEquals((int)server.getPort(), (int)Integer.parseInt(TEST_REST_SERVER_BIND_PORT));
        Assertions.assertFalse((boolean)config.getBoolean("confluent.ssl.enable.dynamic.store.update"));
    }

    static {
        try {
            TEST_SSL_KEYSTORE_LOCATION = File.createTempFile("serverKS", ".jks").getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

