/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.ColumnMapping;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public final class SchemaMapping {
    private final Schema schema;
    private final List<FieldSetter> fieldSetters;

    public static SchemaMapping create(String schemaName, ResultSetMetaData metadata, DatabaseDialect dialect) throws SQLException {
        Map<ColumnId, ColumnDefinition> colDefns = dialect.describeColumns(metadata);
        LinkedHashMap<String, DatabaseDialect.ColumnConverter> colConvertersByFieldName = new LinkedHashMap<String, DatabaseDialect.ColumnConverter>();
        SchemaBuilder builder = SchemaBuilder.struct().name(schemaName);
        int columnNumber = 0;
        for (ColumnDefinition colDefn : colDefns.values()) {
            ++columnNumber;
            String fieldName = dialect.addFieldToSchema(colDefn, builder);
            if (fieldName == null) continue;
            Field field = builder.field(fieldName);
            ColumnMapping mapping = new ColumnMapping(colDefn, columnNumber, field);
            DatabaseDialect.ColumnConverter converter = dialect.createColumnConverter(mapping);
            colConvertersByFieldName.put(fieldName, converter);
        }
        Schema schema = builder.build();
        return new SchemaMapping(schema, colConvertersByFieldName);
    }

    private SchemaMapping(Schema schema, Map<String, DatabaseDialect.ColumnConverter> convertersByFieldName) {
        assert (schema != null);
        assert (convertersByFieldName != null);
        assert (!convertersByFieldName.isEmpty());
        this.schema = schema;
        ArrayList<FieldSetter> fieldSetters = new ArrayList<FieldSetter>(convertersByFieldName.size());
        for (Map.Entry<String, DatabaseDialect.ColumnConverter> entry : convertersByFieldName.entrySet()) {
            DatabaseDialect.ColumnConverter converter = entry.getValue();
            Field field = schema.field(entry.getKey());
            assert (field != null);
            fieldSetters.add(new FieldSetter(converter, field));
        }
        this.fieldSetters = Collections.unmodifiableList(fieldSetters);
    }

    public Schema schema() {
        return this.schema;
    }

    List<FieldSetter> fieldSetters() {
        return this.fieldSetters;
    }

    public String toString() {
        return "Mapping for " + this.schema.name();
    }

    public static final class FieldSetter {
        private final DatabaseDialect.ColumnConverter converter;
        private final Field field;

        private FieldSetter(DatabaseDialect.ColumnConverter converter, Field field) {
            this.converter = converter;
            this.field = field;
        }

        public Field field() {
            return this.field;
        }

        void setField(Struct struct, ResultSet resultSet) throws SQLException, IOException {
            Object value = this.converter.convert(resultSet);
            if (resultSet.wasNull()) {
                struct.put(this.field, null);
            } else {
                struct.put(this.field, value);
            }
        }

        public String toString() {
            return this.field.name();
        }
    }
}

