/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.QuoteMethod;
import java.util.Objects;

public class TableId
implements Comparable<TableId>,
ExpressionBuilder.Expressable {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final int hash;

    public TableId(String catalogName, String schemaName, String tableName) {
        this.catalogName = catalogName == null || catalogName.isEmpty() ? null : catalogName;
        this.schemaName = schemaName == null || schemaName.isEmpty() ? null : schemaName;
        this.tableName = tableName;
        this.hash = Objects.hash(catalogName, schemaName, tableName);
    }

    public String catalogName() {
        return this.catalogName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tableName;
    }

    @Override
    public void appendTo(ExpressionBuilder builder, boolean useQuotes) {
        this.appendTo(builder, useQuotes ? QuoteMethod.ALWAYS : QuoteMethod.NEVER);
    }

    @Override
    public void appendTo(ExpressionBuilder builder, QuoteMethod useQuotes) {
        if (this.catalogName != null) {
            builder.appendIdentifier(this.catalogName, useQuotes);
            builder.appendIdentifierDelimiter();
        }
        if (this.schemaName != null) {
            builder.appendIdentifier(this.schemaName, useQuotes);
            builder.appendIdentifierDelimiter();
        }
        builder.appendTableName(this.tableName, useQuotes);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TableId) {
            TableId that = (TableId)obj;
            return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName);
        }
        return false;
    }

    @Override
    public int compareTo(TableId that) {
        if (that == this) {
            return 0;
        }
        int diff = this.tableName.compareTo(that.tableName);
        if (diff != 0) {
            return diff;
        }
        if (this.schemaName == null) {
            if (that.schemaName != null) {
                return -1;
            }
        } else {
            if (that.schemaName == null) {
                return 1;
            }
            diff = this.schemaName.compareTo(that.schemaName);
            if (diff != 0) {
                return diff;
            }
        }
        if (this.catalogName == null) {
            if (that.catalogName != null) {
                return -1;
            }
        } else {
            if (that.catalogName == null) {
                return 1;
            }
            diff = this.catalogName.compareTo(that.catalogName);
            if (diff != 0) {
                return diff;
            }
        }
        return 0;
    }

    public String toString() {
        return ExpressionBuilder.create().append(this).toString();
    }
}

