/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Objects;
import java.util.OptionalInt;

public class LeaderAndEpoch {
    private final OptionalInt leaderId;
    private final int epoch;

    public LeaderAndEpoch(OptionalInt leaderId, int epoch) {
        this.leaderId = Objects.requireNonNull(leaderId);
        this.epoch = epoch;
    }

    public OptionalInt leaderId() {
        return this.leaderId;
    }

    public int epoch() {
        return this.epoch;
    }

    public boolean isLeader(int nodeId) {
        return this.leaderId.isPresent() && this.leaderId.getAsInt() == nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderAndEpoch that = (LeaderAndEpoch)o;
        return this.epoch == that.epoch && this.leaderId.equals(that.leaderId);
    }

    public int hashCode() {
        return Objects.hash(this.leaderId, this.epoch);
    }

    public String toString() {
        return "LeaderAndEpoch(leaderId=" + this.leaderId + ", epoch=" + this.epoch + ')';
    }
}

