/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.config.SchemaRegistryConfig;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;

public class DefaultKafkaRestContext
implements KafkaRestContext {
    private final KafkaRestConfig config;
    private KafkaConsumerManager kafkaConsumerManager;
    private Admin adminClient;
    private Producer<byte[], byte[]> producer;
    private SchemaRegistryClient schemaRegistryClient;

    @Deprecated
    public DefaultKafkaRestContext(KafkaRestConfig config, ProducerPool producerPool, KafkaConsumerManager kafkaConsumerManager) {
        this(config);
    }

    public DefaultKafkaRestContext(KafkaRestConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public KafkaRestConfig getConfig() {
        return this.config;
    }

    @Override
    public ProducerPool getProducerPool() {
        return new ProducerPool(this.getProducer());
    }

    @Override
    public synchronized KafkaConsumerManager getKafkaConsumerManager() {
        if (this.kafkaConsumerManager == null) {
            this.kafkaConsumerManager = new KafkaConsumerManager(this.config);
        }
        return this.kafkaConsumerManager;
    }

    @Override
    public synchronized Admin getAdmin() {
        if (this.adminClient == null) {
            this.adminClient = AdminClient.create((Properties)this.config.getAdminProperties());
        }
        return this.adminClient;
    }

    @Override
    public synchronized Producer<byte[], byte[]> getProducer() {
        if (this.producer == null) {
            this.producer = new KafkaProducer(this.config.getProducerConfigs(), (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        }
        return this.producer;
    }

    @Override
    public SchemaRegistryClient getSchemaRegistryClient() {
        if (this.schemaRegistryClient == null) {
            SchemaRegistryConfig schemaRegistryConfig = new SchemaRegistryConfig(this.config.getSchemaRegistryConfigs());
            List schemaRegistryUrls = schemaRegistryConfig.getSchemaRegistryUrls().stream().map(URI::create).map(Object::toString).collect(Collectors.toList());
            this.schemaRegistryClient = new CachedSchemaRegistryClient(schemaRegistryUrls, schemaRegistryConfig.getMaxSchemasPerSubject(), SchemaRegistryConfig.SCHEMA_PROVIDERS, this.config.getSchemaRegistryConfigs(), schemaRegistryConfig.requestHeaders());
        }
        return this.schemaRegistryClient;
    }

    @Override
    public void shutdown() {
        if (this.kafkaConsumerManager != null) {
            this.kafkaConsumerManager.shutdown();
        }
        if (this.adminClient != null) {
            this.adminClient.close();
        }
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

