/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Message;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;

public abstract class AbstractKafkaProtobufSerializer<T extends Message>
extends AbstractKafkaSchemaSerDe {
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected boolean onlyLookupReferencesBySchema;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean useLatestVersion;
    protected boolean latestCompatStrict;
    protected boolean skipKnownTypes;
    protected ReferenceSubjectNameStrategy referenceSubjectNameStrategy;

    protected void configure(KafkaProtobufSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new ProtobufSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.onlyLookupReferencesBySchema = config.onlyLookupReferencesBySchema();
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.useLatestVersion = config.useLatestVersion();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        this.skipKnownTypes = config.skipKnownTypes();
        this.referenceSubjectNameStrategy = config.referenceSubjectNameStrategyInstance();
    }

    protected KafkaProtobufSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaProtobufSerializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected byte[] serializeImpl(String subject, String topic, boolean isKey, T object, ProtobufSchema schema) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the serializer or use serializer constructor with SchemaRegistryClient.");
        }
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            boolean autoRegisterForDeps = this.autoRegisterSchema && !this.onlyLookupReferencesBySchema;
            boolean useLatestForDeps = this.useLatestVersion && !this.onlyLookupReferencesBySchema;
            schema = AbstractKafkaProtobufSerializer.resolveDependencies(this.schemaRegistry, this.normalizeSchema, autoRegisterForDeps, useLatestForDeps, this.latestCompatStrict, this.latestVersions, this.skipKnownTypes, this.referenceSubjectNameStrategy, topic, isKey, schema);
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering Protobuf schema: ";
                id = this.schemaRegistry.register(subject, (ParsedSchema)schema, this.normalizeSchema);
            } else if (this.useSchemaId >= 0) {
                restClientErrorMsg = "Error retrieving schema ID";
                schema = (ProtobufSchema)this.lookupSchemaBySubjectAndId(subject, this.useSchemaId, (ParsedSchema)schema, this.idCompatStrict);
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema);
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version: ";
                schema = (ProtobufSchema)this.lookupLatestVersion(subject, (ParsedSchema)schema, this.latestCompatStrict);
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema);
            } else {
                restClientErrorMsg = "Error retrieving Protobuf schema: ";
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema, this.normalizeSchema);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            MessageIndexes indexes = schema.toMessageIndexes(object.getDescriptorForType().getFullName(), this.normalizeSchema);
            out.write(indexes.toByteArray());
            object.writeTo((OutputStream)out);
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (InterruptedIOException e) {
            throw new TimeoutException("Error serializing Protobuf message", (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Protobuf message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaProtobufSerializer.toKafkaException((RestClientException)e, (String)(restClientErrorMsg + schema));
        }
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, true, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, false, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        if (schema.dependencies().isEmpty() || !schema.references().isEmpty()) {
            return schema;
        }
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>(schema.dependencies());
        Schema s = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, null, schema.rawSchema(), dependencies);
        return schema.copy(s.getReferences(), dependencies);
    }

    private static Schema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, String name, ProtoFileElement protoFileElement, Map<String, ProtoFileElement> dependencies) throws IOException, RestClientException {
        String subject;
        Schema subschema;
        ArrayList<SchemaReference> references = new ArrayList<SchemaReference>();
        for (String dep : protoFileElement.getImports()) {
            if (skipKnownTypes && ProtobufSchema.knownTypes().contains(dep)) {
                dependencies.remove(dep);
                continue;
            }
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        for (String dep : protoFileElement.getPublicImports()) {
            if (skipKnownTypes && ProtobufSchema.knownTypes().contains(dep)) {
                dependencies.remove(dep);
                continue;
            }
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        ProtobufSchema schema = new ProtobufSchema(protoFileElement, references, dependencies);
        Integer id = null;
        Integer version = null;
        String string = subject = name != null ? strategy.subjectName(name, topic, isKey, (ParsedSchema)schema) : null;
        if (subject != null) {
            if (autoRegisterSchema) {
                id = schemaRegistry.register(subject, (ParsedSchema)schema, normalizeSchema);
                version = schemaRegistry.getVersion(subject, (ParsedSchema)schema, normalizeSchema);
            } else if (useLatestVersion) {
                schema = (ProtobufSchema)AbstractKafkaProtobufSerializer.lookupLatestVersion((SchemaRegistryClient)schemaRegistry, (String)subject, (ParsedSchema)schema, latestVersions, (boolean)latestCompatStrict);
                id = schemaRegistry.getId(subject, (ParsedSchema)schema);
                version = schemaRegistry.getVersion(subject, (ParsedSchema)schema);
            } else {
                id = schemaRegistry.getId(subject, (ParsedSchema)schema, normalizeSchema);
                version = schemaRegistry.getVersion(subject, (ParsedSchema)schema, normalizeSchema);
            }
        }
        return new Schema(subject, version, id, schema.schemaType(), schema.references(), schema.canonicalString());
    }
}

