/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_8_IV1$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.controller.UpdateMetadataResponseReceived;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEa!B\u000e\u001d\u0003\u0003\t\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019I\u0005\u0001)A\u0005\r\"9!\n\u0001b\u0001\n\u0003Y\u0005B\u0002<\u0001A\u0003%A\nC\u0004x\u0001\t\u0007I\u0011\u0001=\t\u000f\u0005\u0015\u0001\u0001)A\u0005s\"I\u0011q\u0001\u0001C\u0002\u0013\u0005\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0018!9\u0011\u0011\u0006\u0001\u0007\u0002\u0005-\u0002bBA\u001f\u0001\u0019\u0005\u0011q\b\u0005\n\u0003\u000b\u0003\u0011\u0013!C\u0001\u0003\u000fCq!!(\u0001\t\u0003\ty\nC\u0004\u0002\"\u0002!\t!a(\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003_\u0004A\u0011BAy\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0004\u0003\f\u0001!\tA!\u0004\u0003I\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"T!!\b\u0010\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0006L\u0007\u0002U)\u00111FH\u0001\u0006kRLGn]\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003aMj\u0011!\r\u0006\u0003ey\taa]3sm\u0016\u0014\u0018B\u0001\u001b2\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u00028q5\tA$\u0003\u0002:9\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\u0005\u00028y%\u0011Q\b\b\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003A\u0003\n\u001b\u0005CA\u001c\u0001\u0011\u0015qC\u00011\u00010\u0011\u0015)D\u00011\u00017\u0011\u0015QD\u00011\u0001<\u00031\u0019wN\u001c;s_2dWM]%e+\u00051\u0005CA\u0012H\u0013\tAEEA\u0002J]R\fQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0013A\u00067fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$X*\u00199\u0016\u00031\u0003B!\u0014*G)6\taJ\u0003\u0002P!\u00069Q.\u001e;bE2,'BA)%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003':\u00131!T1q!\u0011i%+\u00161\u0011\u0005YsV\"A,\u000b\u0005aK\u0016AB2p[6|gN\u0003\u0002 5*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\tyvK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005\u0005\u001chB\u00012q\u001d\t\u0019gN\u0004\u0002e[:\u0011Q\r\u001c\b\u0003M.t!a\u001a6\u000e\u0003!T!!\u001b\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0016BA.]\u0013\ty\",\u0003\u0002Y3&\u0011qnV\u0001\b[\u0016\u001c8/Y4f\u0013\t\t(/A\fMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000fR1uC*\u0011qnV\u0005\u0003iV\u0014!\u0004T3bI\u0016\u0014\u0018I\u001c3JgJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016T!!\u001d:\u0002/1,\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;NCB\u0004\u0013!F:u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgRl\u0015\r]\u000b\u0002sB!QJ\u0015${!\u0011i%+V>\u0011\u0005q|hB\u00012~\u0013\tq(/\u0001\fTi>\u0004(+\u001a9mS\u000e\f'+Z9vKN$H)\u0019;b\u0013\u0011\t\t!a\u0001\u00033M#x\u000e\u001d*fa2L7-\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0003}J\fac\u001d;paJ+\u0007\u000f\\5dCJ+\u0017/^3ti6\u000b\u0007\u000fI\u0001\u001fkB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0005J|7.\u001a:TKR,\"!a\u0003\u0011\t5\u000biAR\u0005\u0004\u0003\u001fq%aA*fi\u0006yR\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$(I]8lKJ\u001cV\r\u001e\u0011\u0002KU\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiB\u000b'\u000f^5uS>t\u0017J\u001c4p\u001b\u0006\u0004XCAA\f!\u0015i%+VA\r!\u0011\tY\"!\t\u000f\u0007\t\fi\"C\u0002\u0002 I\f\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC&!\u00111EA\u0013\u0005q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016T1!a\bs\u0003\u0019*\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004\u0016M\u001d;ji&|g.\u00138g_6\u000b\u0007\u000fI\u0001\ng\u0016tG-\u0012<f]R$B!!\f\u00024A\u00191%a\f\n\u0007\u0005EBE\u0001\u0003V]&$\bbBA\u001b\u001f\u0001\u0007\u0011qG\u0001\u0006KZ,g\u000e\u001e\t\u0004o\u0005e\u0012bAA\u001e9\ty1i\u001c8ue>dG.\u001a:Fm\u0016tG/A\u0006tK:$'+Z9vKN$H\u0003CA\u0017\u0003\u0003\n)%!\u001e\t\r\u0005\r\u0003\u00031\u0001G\u0003!\u0011'o\\6fe&#\u0007bBA$!\u0001\u0007\u0011\u0011J\u0001\be\u0016\fX/Z:ua\u0011\tY%a\u0019\u0011\r\u00055\u0013\u0011LA0\u001d\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*/\u0006A!/Z9vKN$8/\u0003\u0003\u0002X\u0005E\u0013AF!cgR\u0014\u0018m\u0019;D_:$(o\u001c7SKF,Xm\u001d;\n\t\u0005m\u0013Q\f\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\t9&!\u0015\u0011\t\u0005\u0005\u00141\r\u0007\u0001\t1\t)'!\u0012\u0002\u0002\u0003\u0005)\u0011AA4\u0005\ryF\u0005N\t\u0005\u0003S\ny\u0007E\u0002$\u0003WJ1!!\u001c%\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0014\u0002r%!\u00111OA)\u0005Y\t%m\u001d;sC\u000e$8i\u001c8ue>d'+Z9vKN$\b\"CA<!A\u0005\t\u0019AA=\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007cB\u0012\u0002|\u0005}\u0014QF\u0005\u0004\u0003{\"#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\ty%!!\n\t\u0005\r\u0015\u0011\u000b\u0002\u0011\u0003\n\u001cHO]1diJ+7\u000f]8og\u0016\fQc]3oIJ+\u0017/^3ti\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\n*\"\u0011\u0011PAFW\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\u0013Ut7\r[3dW\u0016$'bAALI\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00038fo\n\u000bGo\u00195\u0015\u0005\u00055\u0012!B2mK\u0006\u0014\u0018\u0001I1eI2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;G_J\u0014%o\\6feN$B\"!\f\u0002(\u0006M\u0016qWAa\u0003\u0017Dq!!+\u0015\u0001\u0004\tY+A\u0005ce>\\WM]%egB)\u0011QVAX\r6\t\u0001+C\u0002\u00022B\u00131aU3r\u0011\u0019\t)\f\u0006a\u0001+\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA])\u0001\u0007\u00111X\u0001\u001cY\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007]\ni,C\u0002\u0002@r\u00111\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007bBAb)\u0001\u0007\u0011QY\u0001\u0012e\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bcA\u001c\u0002H&\u0019\u0011\u0011\u001a\u000f\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fC\u0004\u0002NR\u0001\r!a4\u0002\u000b%\u001ch*Z<\u0011\u0007\r\n\t.C\u0002\u0002T\u0012\u0012qAQ8pY\u0016\fg.A\u0010bI\u0012\u001cFo\u001c9SKBd\u0017nY1SKF,Xm\u001d;G_J\u0014%o\\6feN$\u0002\"!\f\u0002Z\u0006m\u0017Q\u001c\u0005\b\u0003S+\u0002\u0019AAV\u0011\u0019\t),\u0006a\u0001+\"9\u0011q\\\u000bA\u0002\u0005=\u0017a\u00043fY\u0016$X\rU1si&$\u0018n\u001c8\u0002E\u0005$G-\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHOR8s\u0005J|7.\u001a:t)\u0019\ti#!:\u0002h\"9\u0011\u0011\u0016\fA\u0002\u0005-\u0006bBAu-\u0001\u0007\u00111^\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BAW\u0003[,\u0016bAA\b!\u000692/\u001a8e\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e\u000b\u0007\u0003[\t\u00190a>\t\r\u0005Ux\u00031\u0001G\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007BBA}/\u0001\u00071(\u0001\bti\u0006$Xm\u00115b]\u001e,Gj\\4\u00025M,g\u000eZ+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f^:\u0015\r\u00055\u0012q B\u0001\u0011\u0019\t)\u0010\u0007a\u0001\r\"1\u0011\u0011 \rA\u0002m\nqc]3oIN#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^:\u0015\r\u00055\"q\u0001B\u0005\u0011\u0019\t)0\u0007a\u0001\r\"1\u0011\u0011`\rA\u0002m\nQc]3oIJ+\u0017/^3tiN$vN\u0011:pW\u0016\u00148\u000f\u0006\u0003\u0002.\t=\u0001BBA{5\u0001\u0007a\t")
public abstract class AbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final StateChangeLogger stateChangeLogger;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    public abstract void sendEvent(ControllerEvent var1);

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(135).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(134).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(169).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString());
        }
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        ((IterableOnceOps)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 >= 0)).foreach((Function1 & Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicaAssignment, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        int leaderEpoch = this.controllerContext.isTopicQueuedUpForDeletion(topicPartition.topic()) ? LeaderAndIsr$.MODULE$.EpochDuringDelete() : BoxesRunTime.unboxToInt((Object)this.controllerContext.partitionLeadershipInfo(topicPartition).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)AbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$1(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> LeaderAndIsr$.MODULE$.NoEpoch()));
        ((IterableOnceOps)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 >= 0)).foreach((Function1 & Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$4(this, topicPartition, leaderEpoch, deletePartition, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((IterableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$10 -> x$10 >= 0));
        partitions.foreach((Function1 & Serializable)partition -> {
            this.updateMetadataRequestPartitionInfo$1(partition, this.controllerContext.topicsToBeDeleted().contains((Object)partition.topic()));
            return BoxedUnit.UNIT;
        });
    }

    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        int leaderAndIsrRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_8_IV1$.MODULE$) ? 5 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? 4 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV0$.MODULE$) ? 3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? 2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? 1 : 0))));
        this.leaderAndIsrRequestMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1$adapted(this, stateChangeLog, (short)leaderAndIsrRequestVersion, controllerEpoch, arg_0, arg_1), arg_0, arg_1));
        this.leaderAndIsrRequestMap().clear();
    }

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        stateChangeLog.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Sending UpdateMetadata request to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" ").append("for ").append(this.updateMetadataRequestPartitionInfoMap().size()).append(" partitions").toString());
        Buffer partitionStates = this.updateMetadataRequestPartitionInfoMap().values().toBuffer();
        int updateMetadataRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_8_IV1$.MODULE$) ? 7 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? 6 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? 5 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? 4 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_2_IV0$.MODULE$) ? 3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV1$.MODULE$) ? 2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0))))));
        Buffer liveBrokers = this.controllerContext.liveOrShuttingDownBrokers().iterator().map(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$2((short)updateMetadataRequestVersion, arg_0)).toBuffer();
        this.updateMetadataRequestBrokerSet().intersect(this.controllerContext.liveOrShuttingDownBrokerIds()).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$4(this, partitionStates, (short)updateMetadataRequestVersion, controllerEpoch, liveBrokers, arg_0)));
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    private void sendStopReplicaRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        boolean traceEnabled = stateChangeLog.isTraceEnabled();
        short stopReplicaRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_6_IV0$.MODULE$) ? (short)3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? (short)2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)1 : 0));
        this.stopReplicaRequestMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(brokerId, partitionStates) -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$2(this, traceEnabled, stateChangeLog, stopReplicaRequestVersion, controllerEpoch, BoxesRunTime.unboxToInt((Object)brokerId), partitionStates);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.stopReplicaRequestMap().clear();
    }

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch, stateChangeLog);
            return;
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(124).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNew()));
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        return result.put((Object)topicPartition$1, (Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderAndIsr.isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(leaderAndIsr.zkVersion()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setIsNew(isNew$1 || alreadyNew));
    }

    public static final /* synthetic */ int $anonfun$addStopReplicaRequestForBrokers$1(LeaderIsrAndControllerEpoch x$6) {
        return x$6.leaderAndIsr().leaderEpoch();
    }

    public static final /* synthetic */ Option $anonfun$addStopReplicaRequestForBrokers$4(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$2, int leaderEpoch$1, boolean deletePartition$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
        boolean alreadyDelete = result.get((Object)topicPartition$2).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.deletePartition()));
        return result.put((Object)topicPartition$2, (Object)new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(topicPartition$2.partition()).setLeaderEpoch(leaderEpoch$1).setDeletePartition(alreadyDelete || deletePartition$1));
    }

    private final void updateMetadataRequestPartitionInfo$1(TopicPartition partition, boolean beingDeleted) {
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
        Option<LeaderIsrAndControllerEpoch> option = this.controllerContext.partitionLeadershipInfo(partition);
        if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value()) != null) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
            Seq<Object> replicas = this.controllerContext.partitionReplicaAssignment(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> !$this.controllerContext.isReplicaOnline(x$9, partition, $this.controllerContext.isReplicaOnline$default$3()));
            LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(updatedLeaderAndIsr.leader()).setLeaderEpoch(updatedLeaderAndIsr.leaderEpoch()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)updatedLeaderAndIsr.isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(updatedLeaderAndIsr.zkVersion()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setOfflineReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)offlineReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
            this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(scala.collection.mutable.Set leaderIds$1, int broker$2, IntRef numBecomeLeaders$1, StateChangeLogger stateChangeLog$1, TopicPartition topicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState state) {
        String typeOfRequest;
        String string;
        leaderIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)state.leader()));
        if (broker$2 == state.leader()) {
            ++numBecomeLeaders$1.elem;
            string = "become-leader";
        } else {
            string = typeOfRequest = "become-follower";
        }
        if (stateChangeLog$1.isTraceEnabled()) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$10(AbstractControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)r;
        $this.sendEvent(new LeaderAndIsrResponseReceived(leaderAndIsrResponse, broker$2));
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$1(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, int broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        if ($this.controllerContext.liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)broker))) {
            scala.collection.mutable.Set leaderIds = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            IntRef numBecomeLeaders = IntRef.create((int)0);
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, state) -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(leaderIds, broker, numBecomeLeaders, stateChangeLog$1, topicPartition, state);
                return BoxedUnit.UNIT;
            };
            leaderAndIsrPartitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var13_8 = null;
            stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Sending LeaderAndIsr request to broker ").append(broker).append(" with ").append(numBecomeLeaders$1.elem).append(" become-leader ").append("and ").append(leaderAndIsrPartitionStates.size() - numBecomeLeaders$1.elem).append(" become-follower partitions").toString());
            Set leaders = (Set)((IterableOps)$this.controllerContext.liveOrShuttingDownBrokers().filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable)x$11 -> x$11.node($this.config.interBrokerListenerName()));
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            scala.collection.immutable.Map topicIds = ((IterableOnceOps)((IterableOnceOps)leaderAndIsrPartitionStates.keys().map((Function1 & Serializable)x$12 -> x$12.topic())).toSet().map((Function1 & Serializable)topic -> new Tuple2(topic, $this.controllerContext.topicIds().getOrElse(topic, (Function0 & Serializable)() -> Uuid.ZERO_UUID)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, CollectionConverters$.MODULE$.BufferHasAsJava(leaderAndIsrPartitionStates.values().toBuffer()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicIds).asJava(), (Collection)CollectionConverters$.MODULE$.SetHasAsJava(leaders).asJava());
            $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)r -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$10($this, broker, r);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$sendUpdateMetadataRequests$2(short updateMetadataRequestVersion$1, Broker broker) {
        Seq seq;
        if (updateMetadataRequestVersion$1 == 0) {
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
            Node node = broker.node(listenerName);
            seq = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$);
        } else {
            seq = (Seq)broker.endPoints().map((Function1 & Serializable)endpoint -> new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id).setListener(endpoint.listenerName().value()));
        }
        Seq endpoints = seq;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(endpoints).asJava()).setRack((String)broker.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$8(AbstractControllerBrokerRequestBatch $this, int broker$3, AbstractResponse r) {
        UpdateMetadataResponse updateMetadataResponse = (UpdateMetadataResponse)r;
        $this.sendEvent(new UpdateMetadataResponseReceived(updateMetadataResponse, broker$3));
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$4(AbstractControllerBrokerRequestBatch $this, Buffer partitionStates$1, short updateMetadataRequestVersion$1, int controllerEpoch$2, Buffer liveBrokers$1, int broker) {
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        scala.collection.immutable.Map topicIds = ((IterableOnceOps)((IterableOps)((IterableOps)((SeqOps)partitionStates$1.map((Function1 & Serializable)x$13 -> x$13.topicName())).distinct()).filter(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$6$adapted($this.controllerContext.topicIds(), arg_0))).map((Function1 & Serializable)topic -> new Tuple2(topic, $this.controllerContext.topicIds().apply(topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        UpdateMetadataRequest.Builder updateMetadataRequestBuilder = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion$1, $this.controllerId(), controllerEpoch$2, brokerEpoch, CollectionConverters$.MODULE$.BufferHasAsJava(partitionStates$1).asJava(), CollectionConverters$.MODULE$.BufferHasAsJava(liveBrokers$1).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicIds).asJava());
        $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)r -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$8($this, broker, r);
            return BoxedUnit.UNIT;
        });
    }

    private final void responseCallback$1(int brokerId, Function1 isPartitionDeleted, AbstractResponse response) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map partitionErrorsForDeletingTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        stopReplicaResponse.partitionErrors().forEach(pe -> {
            TopicPartition tp = new TopicPartition(pe.topicName(), pe.partitionIndex());
            if ($this.controllerContext.isTopicDeletionInProgress(pe.topicName()) && BoxesRunTime.unboxToBoolean((Object)isPartitionDeleted.apply((Object)tp))) {
                partitionErrorsForDeletingTopics.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.forCode((short)pe.errorCode())));
                return;
            }
        });
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.sendEvent(new TopicDeletionStopReplicaResponseReceived(brokerId, stopReplicaResponse.error(), (Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$5(scala.collection.mutable.Map stopReplicaTopicState$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        return ((StopReplicaRequestData.StopReplicaTopicState)stopReplicaTopicState$1.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$8(scala.collection.mutable.Map partitionStates$2, TopicPartition tp) {
        return partitionStates$2.get((Object)tp).exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.deletePartition()));
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$11(IntRef numPartitionStateWithDelete$1, scala.collection.mutable.Map topicStatesWithDelete$1, IntRef numPartitionStateWithoutDelete$1, scala.collection.mutable.Map topicStatesWithoutDelete$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        scala.collection.mutable.Map map;
        if (partitionState.deletePartition()) {
            ++numPartitionStateWithDelete$1.elem;
            map = topicStatesWithDelete$1;
        } else {
            ++numPartitionStateWithoutDelete$1.elem;
            map = topicStatesWithoutDelete$1;
        }
        return ((StopReplicaRequestData.StopReplicaTopicState)map.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$14(TopicPartition x$15) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$2(AbstractControllerBrokerRequestBatch $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$2, short stopReplicaRequestVersion$1, int controllerEpoch$3, int brokerId, scala.collection.mutable.Map partitionStates) {
        if ($this.controllerContext.liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            if (traceEnabled$1) {
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, partitionState) -> {
                    stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Sending StopReplica request ").append(partitionState).append(" to ").append("broker ").append(brokerId$2).append(" for partition ").append(topicPartition).toString());
                    return BoxedUnit.UNIT;
                };
                partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var19_7 = null;
            }
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaRequestVersion$1 >= 3) {
                scala.collection.mutable.Map stopReplicaTopicState = (scala.collection.mutable.Map)Map$.MODULE$.empty();
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$5(stopReplicaTopicState, topicPartition, partitionState));
                partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var20_10 = null;
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Sending StopReplica request for ").append(partitionStates.size()).append(" ").append("replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, CollectionConverters$.MODULE$.BufferHasAsJava(stopReplicaTopicState.values().toBuffer()).asJava());
                Function1 & Serializable intersect = (Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$8(partitionStates, tp));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)response -> {
                    $this.responseCallback$1(brokerId, intersect, response);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            IntRef numPartitionStateWithDelete = IntRef.create((int)0);
            IntRef numPartitionStateWithoutDelete = IntRef.create((int)0);
            scala.collection.mutable.Map topicStatesWithDelete = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            scala.collection.mutable.Map topicStatesWithoutDelete = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$11(numPartitionStateWithDelete, topicStatesWithDelete, numPartitionStateWithoutDelete, topicStatesWithoutDelete, topicPartition, partitionState));
            partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var21_17 = null;
            if (topicStatesWithDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Sending StopReplica request (delete = true) for ").append(numPartitionStateWithDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, true, CollectionConverters$.MODULE$.BufferHasAsJava(topicStatesWithDelete.values().toBuffer()).asJava());
                Function1 & Serializable intersect = (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$14(x$15));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)response -> {
                    $this.responseCallback$1(brokerId, intersect, response);
                    return BoxedUnit.UNIT;
                });
            }
            if (topicStatesWithoutDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Sending StopReplica request (delete = false) for ").append(numPartitionStateWithoutDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, CollectionConverters$.MODULE$.BufferHasAsJava(topicStatesWithoutDelete.values().toBuffer()).asJava());
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, $this.sendRequest$default$3());
                return;
            }
            return;
        }
    }

    public AbstractControllerBrokerRequestBatch(KafkaConfig config, ControllerContext controllerContext, StateChangeLogger stateChangeLogger) {
        this.config = config;
        this.controllerContext = controllerContext;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.stopReplicaRequestMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$sendLeaderAndIsrRequest$1$adapted(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Object broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1($this, stateChangeLog$1, leaderAndIsrRequestVersion$1, controllerEpoch$1, BoxesRunTime.unboxToInt((Object)broker), leaderAndIsrPartitionStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$sendUpdateMetadataRequests$6$adapted(scala.collection.mutable.Map eta$0$1$1, String key) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains((Object)key));
    }
}

