/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.LogDirFailureChannel;
import kafka.server.PartitionMetadata;
import kafka.server.PartitionMetadataFile$;
import kafka.server.PartitionMetadataFile$PartitionMetadataFileFormatter$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%w!\u0002\u0016,\u0011\u0003\u0001d!\u0002\u001a,\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002\u001f\u0002\u0005\u0004%I!\u0010\u0005\u0007\r\u0006\u0001\u000b\u0011\u0002 \t\u000f\u001d\u000b!\u0019!C\u0005\u0011\"1\u0011+\u0001Q\u0001\n%CqAU\u0001C\u0002\u0013%1\u000b\u0003\u0004X\u0003\u0001\u0006I\u0001\u0016\u0005\u00061\u0006!\t!W\u0004\u0006E\u0006A\ta\u0019\u0004\u0006K\u0006A\tA\u001a\u0005\u0006u-!\ta\u001a\u0005\u0006Q.!\t!\u001b\u0004\u0005s\u0006\u0001!\u0010C\u0005\u0002\u00069\u0011\t\u0011)A\u0005U\"Q\u0011q\u0001\b\u0003\u0002\u0003\u0006I!!\u0003\t\u0013\u0005=aB!A!\u0002\u0013!\u0006B\u0002\u001e\u000f\t\u0003\t\t\u0002C\u0004\u000229!\t!a\r\u0007\u000bIZ\u0003!!\u000e\t\u0015\u0005]BC!b\u0001\n\u0003\tI\u0004C\u0005\u0002<Q\u0011\t\u0011)A\u00055\"Q\u0011Q\b\u000b\u0003\u0002\u0003\u0006I!a\u0010\t\ri\"B\u0011AA#\u0011%\ti\u0005\u0006b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002`Q\u0001\u000b\u0011BA)\u0011%\t\t\u0007\u0006b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002dQ\u0001\u000b\u0011BA)\u0011%\t)\u0007\u0006b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002pQ\u0001\u000b\u0011BA5\u0011!\t\t\b\u0006b\u0001\n\u0013i\u0004bBA:)\u0001\u0006IA\u0010\u0005\n\u0003k\"\u0002\u0019!C\u0005\u0003oB\u0011\"!&\u0015\u0001\u0004%I!a&\t\u0011\u0005\rF\u0003)Q\u0005\u0003sBq!!,\u0015\t\u0003\ty\u000bC\u0004\u00026R!\t!a.\t\u000f\u0005EB\u0003\"\u0001\u00024!9\u0011\u0011\u0018\u000b\u0005\u0002\u0005m\u0006bBAb)\u0011\u0005\u0011q\u0017\u0005\b\u0003\u000b$B\u0011IAd\u0003U\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$jY\u0016T!\u0001L\u0017\u0002\rM,'O^3s\u0015\u0005q\u0013!B6bM.\f7\u0001\u0001\t\u0003c\u0005i\u0011a\u000b\u0002\u0016!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f'\t\tA\u0007\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\n\u0011\u0004U1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWM\\1nKV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!A.\u00198h\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\rM#(/\u001b8h\u0003i\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$jY\u0016t\u0017-\\3!\u0003I9\u0006.\u001b;f'B\f7-Z:QCR$XM\u001d8\u0016\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\u000bI,w-\u001a=\u000b\u00059\u0013\u0015\u0001B;uS2L!\u0001U&\u0003\u000fA\u000bG\u000f^3s]\u0006\u0019r\u000b[5uKN\u0003\u0018mY3t!\u0006$H/\u001a:oA\u0005q1)\u001e:sK:$h+\u001a:tS>tW#\u0001+\u0011\u0005U*\u0016B\u0001,7\u0005\rIe\u000e^\u0001\u0010\u0007V\u0014(/\u001a8u-\u0016\u00148/[8oA\u00059a.Z<GS2,GC\u0001.a!\tYf,D\u0001]\u0015\ti&)\u0001\u0002j_&\u0011q\f\u0018\u0002\u0005\r&dW\rC\u0003b\u0013\u0001\u0007!,A\u0002eSJ\fa\u0004U1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWMR8s[\u0006$H/\u001a:\u0011\u0005\u0011\\Q\"A\u0001\u0003=A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018MR5mK\u001a{'/\\1ui\u0016\u00148CA\u00065)\u0005\u0019\u0017A\u0002;p\r&dW\r\u0006\u0002kiB\u00111N\u001d\b\u0003YB\u0004\"!\u001c\u001c\u000e\u00039T!a\\\u0018\u0002\rq\u0012xn\u001c;?\u0013\t\th'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000bNT!!\u001d\u001c\t\u000bUl\u0001\u0019\u0001<\u0002\t\u0011\fG/\u0019\t\u0003c]L!\u0001_\u0016\u0003#A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018MA\u000eQCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006\u0014V-\u00193Ck\u001a4WM]\u000b\u0004w\u0006e1c\u0001\b5yB\u0019Q0!\u0001\u000e\u0003yT!a`\u0017\u0002\u000bU$\u0018\u000e\\:\n\u0007\u0005\raPA\u0004M_\u001e<\u0017N\\4\u0002\u00111|7-\u0019;j_:\faA]3bI\u0016\u0014\bcA.\u0002\f%\u0019\u0011Q\u0002/\u0003\u001d\t+hMZ3sK\u0012\u0014V-\u00193fe\u00069a/\u001a:tS>tG\u0003CA\n\u0003W\ti#a\f\u0011\t\u0011t\u0011Q\u0003\t\u0005\u0003/\tI\u0002\u0004\u0001\u0005\u000f\u0005maB1\u0001\u0002\u001e\t\tA+\u0005\u0003\u0002 \u0005\u0015\u0002cA\u001b\u0002\"%\u0019\u00111\u0005\u001c\u0003\u000f9{G\u000f[5oOB\u0019Q'a\n\n\u0007\u0005%bGA\u0002B]fDa!!\u0002\u0013\u0001\u0004Q\u0007bBA\u0004%\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0003\u001f\u0011\u0002\u0019\u0001+\u0002\tI,\u0017\r\u001a\u000b\u0002mN\u0019A\u0003\u000e?\u0002\t\u0019LG.Z\u000b\u00025\u0006)a-\u001b7fA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u00042!MA!\u0013\r\t\u0019e\u000b\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0015\r\u0005\u001d\u0013\u0011JA&!\t\tD\u0003\u0003\u0004\u00028a\u0001\rA\u0017\u0005\b\u0003{A\u0002\u0019AA \u0003\u0011\u0001\u0018\r\u001e5\u0016\u0005\u0005E\u0003\u0003BA*\u00037j!!!\u0016\u000b\t\u0005]\u0012q\u000b\u0006\u0004\u00033\u0012\u0015a\u00018j_&!\u0011QLA+\u0005\u0011\u0001\u0016\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u0011Q,W\u000e\u001d)bi\"\f\u0011\u0002^3naB\u000bG\u000f\u001b\u0011\u0002\t1|7m[\u000b\u0003\u0003S\u00022aPA6\u0013\r\ti\u0007\u0011\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b1|7m\u001b\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\u0002Z5sif$v\u000e]5d\u0013\u0012|\u0005\u000f^\u000b\u0003\u0003s\u0002R!NA>\u0003\u007fJ1!! 7\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011QAI\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015AB2p[6|gNC\u0002/\u0003\u0013SA!a#\u0002\u000e\u00061\u0011\r]1dQ\u0016T!!a$\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0014\u0006\r%\u0001B+vS\u0012\f1\u0003Z5sif$v\u000e]5d\u0013\u0012|\u0005\u000f^0%KF$B!!'\u0002 B\u0019Q'a'\n\u0007\u0005ueG\u0001\u0003V]&$\b\"CAQE\u0005\u0005\t\u0019AA=\u0003\rAH%M\u0001\u0011I&\u0014H/\u001f+pa&\u001c\u0017\nZ(qi\u0002B3aIAT!\r)\u0014\u0011V\u0005\u0004\u0003W3$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\rI,7m\u001c:e)\u0011\tI*!-\t\u000f\u0005MF\u00051\u0001\u0002\u0000\u00059Ao\u001c9jG&#\u0017AC7bs\n,g\t\\;tQR\u0011\u0011\u0011T\u0001\u0007KbL7\u000f^:\u0015\u0005\u0005u\u0006cA\u001b\u0002@&\u0019\u0011\u0011\u0019\u001c\u0003\u000f\t{w\u000e\\3b]\u00061A-\u001a7fi\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002U\u0002")
public class PartitionMetadataFile
implements Logging {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String logDir;
    private volatile Option<Uuid> dirtyTopicIdOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static File newFile(File dir) {
        return PartitionMetadataFile$.MODULE$.newFile(dir);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    private String logDir() {
        return this.logDir;
    }

    private Option<Uuid> dirtyTopicIdOpt() {
        return this.dirtyTopicIdOpt;
    }

    private void dirtyTopicIdOpt_$eq(Option<Uuid> x$1) {
        this.dirtyTopicIdOpt = x$1;
    }

    public void record(Uuid topicId) {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable)dirtyTopicId -> {
            PartitionMetadataFile.$anonfun$record$1(topicId, dirtyTopicId);
            return BoxedUnit.UNIT;
        });
        this.dirtyTopicIdOpt_$eq((Option<Uuid>)new Some((Object)topicId));
    }

    public void maybeFlush() {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable)x$1 -> {
            PartitionMetadataFile.$anonfun$maybeFlush$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public PartitionMetadata read() {
        Object object = this.lock();
        synchronized (object) {
            PartitionMetadata partitionMetadata = this.liftedTree1$1();
            return partitionMetadata;
        }
    }

    public boolean exists() {
        return this.file().exists();
    }

    public void delete() {
        Files.delete(this.file().toPath());
    }

    public String toString() {
        return new StringBuilder(28).append("PartitionMetadataFile(path=").append(this.path()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$record$1(Uuid topicId$1, Uuid dirtyTopicId) {
        Uuid uuid = dirtyTopicId;
        if (uuid == null ? topicId$1 != null : !uuid.equals(topicId$1)) {
            throw new InconsistentTopicIdException(new StringBuilder(59).append("Tried to record topic ID ").append(topicId$1).append(" to file ").append("but had already recorded ").append(dirtyTopicId).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$2(PartitionMetadataFile $this, Uuid topicId) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream($this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(PartitionMetadataFile$PartitionMetadataFileFormatter$.MODULE$.toFile(new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), topicId)));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)$this.tempPath(), (Path)$this.path(), (boolean)true);
        }
        catch (IOException e) {
            String msg = new StringBuilder(47).append("Error while writing to partition metadata file ").append($this.file().getAbsolutePath()).toString();
            $this.logDirFailureChannel.maybeAddOfflineLogDir($this.logDir(), (Function0<String>)(Function0 & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
        $this.dirtyTopicIdOpt_$eq((Option<Uuid>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$1(PartitionMetadataFile $this, Uuid x$1) {
        Object object = $this.lock();
        synchronized (object) {
            $this.dirtyTopicIdOpt().foreach((Function1 & Serializable)topicId -> {
                PartitionMetadataFile.$anonfun$maybeFlush$2($this, topicId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final /* synthetic */ PartitionMetadata liftedTree1$1() {
        try {
            PartitionMetadata partitionMetadata;
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                partitionMetadata = new PartitionMetadataReadBuffer(this.file().getAbsolutePath(), reader, PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()).read();
            }
            return partitionMetadata;
        }
        catch (IOException e) {
            String msg = new StringBuilder(44).append("Error while reading partition metadata file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), (Function0<String>)(Function0 & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public PartitionMetadataFile(File file, LogDirFailureChannel logDirFailureChannel) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        this.logDir = file.getParentFile().getParent();
        this.dirtyTopicIdOpt = None$.MODULE$;
    }

    public static class PartitionMetadataReadBuffer<T>
    implements Logging {
        private final String location;
        private final BufferedReader reader;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public PartitionMetadata read() {
            PartitionMetadata partitionMetadata;
            String line = null;
            try {
                Uuid metadataTopicId;
                block11: {
                    block7: {
                        String version;
                        block8: {
                            Object object;
                            block10: {
                                block9: {
                                    Object object2;
                                    line = this.reader.readLine();
                                    String[] stringArray = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray))) break block7;
                                    new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2));
                                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) != 0) break block7;
                                    version = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                                    if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(version)) != PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()) break block8;
                                    line = this.reader.readLine();
                                    String[] stringArray2 = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                                    if (stringArray2 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray2))) break block9;
                                    new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object));
                                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) break block10;
                                }
                                throw this.malformedLineException$1(line);
                            }
                            metadataTopicId = Uuid.fromString((String)((String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1)));
                            if (metadataTopicId.equals((Object)Uuid.ZERO_UUID)) {
                                throw new IOException(new StringBuilder(46).append("Invalid topic ID in partition metadata file (").append(this.location).append(")").toString());
                            }
                            break block11;
                        }
                        throw new IOException(new StringBuilder(52).append("Unrecognized version of partition metadata file (").append(this.location).append("): ").append(version).toString());
                    }
                    throw this.malformedLineException$1(line);
                }
                partitionMetadata = new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), metadataTopicId);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.malformedLineException$1(line);
            }
            return partitionMetadata;
        }

        private final IOException malformedLineException$1(String line) {
            return new IOException(new StringBuilder(40).append("Malformed line in checkpoint file (").append(this.location).append("): '").append(line).append("'").toString());
        }

        public PartitionMetadataReadBuffer(String location, BufferedReader reader, int version) {
            this.location = location;
            this.reader = reader;
        }
    }
}

