/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Map;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_8_0$;
import kafka.api.KAFKA_0_8_1$;
import kafka.api.KAFKA_0_8_2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.KAFKA_2_5_IV0$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.api.KAFKA_2_7_IV2$;
import kafka.api.KAFKA_2_8_IV0$;
import kafka.api.KAFKA_2_8_IV1$;
import kafka.api.KAFKA_3_0_IV0$;
import kafka.api.KAFKA_3_0_IV1$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ApiVersion$ {
    public static final ApiVersion$ MODULE$ = new ApiVersion$();
    private static final Seq<ApiVersion> allVersions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiVersion[]{KAFKA_0_8_0$.MODULE$, KAFKA_0_8_1$.MODULE$, KAFKA_0_8_2$.MODULE$, KAFKA_0_9_0$.MODULE$, KAFKA_0_10_0_IV0$.MODULE$, KAFKA_0_10_0_IV1$.MODULE$, KAFKA_0_10_1_IV0$.MODULE$, KAFKA_0_10_1_IV1$.MODULE$, KAFKA_0_10_1_IV2$.MODULE$, KAFKA_0_10_2_IV0$.MODULE$, KAFKA_0_11_0_IV0$.MODULE$, KAFKA_0_11_0_IV1$.MODULE$, KAFKA_0_11_0_IV2$.MODULE$, KAFKA_1_0_IV0$.MODULE$, KAFKA_1_1_IV0$.MODULE$, KAFKA_2_0_IV0$.MODULE$, KAFKA_2_0_IV1$.MODULE$, KAFKA_2_1_IV0$.MODULE$, KAFKA_2_1_IV1$.MODULE$, KAFKA_2_1_IV2$.MODULE$, KAFKA_2_2_IV0$.MODULE$, KAFKA_2_2_IV1$.MODULE$, KAFKA_2_3_IV0$.MODULE$, KAFKA_2_3_IV1$.MODULE$, KAFKA_2_4_IV0$.MODULE$, KAFKA_2_4_IV1$.MODULE$, KAFKA_2_5_IV0$.MODULE$, KAFKA_2_6_IV0$.MODULE$, KAFKA_2_7_IV0$.MODULE$, KAFKA_2_7_IV1$.MODULE$, KAFKA_2_7_IV2$.MODULE$, KAFKA_2_8_IV0$.MODULE$, KAFKA_2_8_IV1$.MODULE$, KAFKA_3_0_IV0$.MODULE$, KAFKA_3_0_IV1$.MODULE$}));
    private static final scala.collection.immutable.Map<String, ApiVersion> versionMap = (scala.collection.immutable.Map)((IterableOnceOps)MODULE$.allVersions().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.version()), v))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)MODULE$.allVersions().groupBy((Function1 & Serializable)x$2 -> x$2.shortVersion()).map((Function1 & Serializable)x0$1 -> {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            Seq v = (Seq)x0$1._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.last());
        }
        throw new MatchError(null);
    }));
    private static final ApiVersion latestVersion = (ApiVersion)MODULE$.allVersions().last();

    public <A extends ApiVersion> Ordering<A> orderingByVersion() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<ApiVersion> allVersions() {
        return allVersions;
    }

    private scala.collection.immutable.Map<String, ApiVersion> versionMap() {
        return versionMap;
    }

    public ApiVersion apply(String versionString) {
        Seq versionSegments = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(versionString), '.')));
        int numSegments = versionString.startsWith("0.") ? 3 : 2;
        String key = ((IterableOnceOps)versionSegments.take(numSegments)).mkString(".");
        return (ApiVersion)this.versionMap().getOrElse((Object)key, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(33).append("Version `").append(versionString).append("` is not a valid version").toString());
        });
    }

    public ApiVersion latestVersion() {
        return latestVersion;
    }

    public boolean isTruncationOnFetchSupported(ApiVersion version) {
        return version.$greater$eq(KAFKA_2_7_IV1$.MODULE$);
    }

    public ApiVersion minSupportedFor(RecordVersion recordVersion) {
        if (RecordVersion.V0.equals(recordVersion)) {
            return KAFKA_0_8_0$.MODULE$;
        }
        if (RecordVersion.V1.equals(recordVersion)) {
            return KAFKA_0_10_0_IV0$.MODULE$;
        }
        if (RecordVersion.V2.equals(recordVersion)) {
            return KAFKA_0_11_0_IV0$.MODULE$;
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Invalid message format version ").append(recordVersion).toString());
    }

    public ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, RecordVersion minRecordVersion, Features<SupportedVersionRange> latestSupportedFeatures, Option<NodeApiVersions> controllerApiVersions, ApiMessageType.ListenerType listenerType) {
        return this.apiVersionsResponse(throttleTimeMs, minRecordVersion, latestSupportedFeatures, (Features<FinalizedVersionRange>)Features.emptyFinalizedFeatures(), -1L, controllerApiVersions, listenerType);
    }

    public ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, RecordVersion minRecordVersion, Features<SupportedVersionRange> latestSupportedFeatures, Features<FinalizedVersionRange> finalizedFeatures, long finalizedFeaturesEpoch, Option<NodeApiVersions> controllerApiVersions, ApiMessageType.ListenerType listenerType) {
        ApiVersionsResponseData.ApiVersionCollection apiVersionCollection;
        if (None$.MODULE$.equals(controllerApiVersions)) {
            apiVersionCollection = ApiVersionsResponse.filterApis((RecordVersion)minRecordVersion, (ApiMessageType.ListenerType)listenerType);
        } else if (controllerApiVersions instanceof Some) {
            NodeApiVersions controllerApiVersion = (NodeApiVersions)((Some)controllerApiVersions).value();
            apiVersionCollection = ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)listenerType, (RecordVersion)minRecordVersion, (Map)controllerApiVersion.allSupportedApiVersions());
        } else {
            throw new MatchError(controllerApiVersions);
        }
        ApiVersionsResponseData.ApiVersionCollection apiKeys = apiVersionCollection;
        return ApiVersionsResponse.createApiVersionsResponse((int)throttleTimeMs, (ApiVersionsResponseData.ApiVersionCollection)apiKeys, latestSupportedFeatures, finalizedFeatures, (long)finalizedFeaturesEpoch);
    }

    private ApiVersion$() {
    }
}

