/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.LastRecord;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t}d!\u0002\u0012$\u0001\r:\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011i\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{!A!\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00038\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006_\u0002!\t\u0006\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015B>\t\u0011\u00055\u0001\u00011A\u0005\niD\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u000f\u0005U\u0001\u0001)Q\u0005w\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!A\u00111\u0005\u0001\u0005\u0002\r\n)\u0003\u0003\u0005\u0002D\u0001!\taIA#\u0011!\ti\u0005\u0001C\u0001G\u0005=\u0003\u0002CAB\u0001\u0011\u00051%!\"\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057A\u0001B!\b\u0001\t\u0003\u0019#q\u0004\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011!\u0011\u0019\u0006\u0001C\u0001G\tU\u0003b\u0002B3\u0001\u0011%!q\r\u0002\b\u00072,\u0017M\\3s\u0015\t!S%A\u0002m_\u001eT\u0011AJ\u0001\u0006W\u000647.Y\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022K\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\tIGm\u0001\u0001\u0016\u0003]\u0002\"!\u000b\u001d\n\u0005eR#aA%oi\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u001f\u0011\u0005yzT\"A\u0012\n\u0005\u0001\u001b#!C(gMN,G/T1q\u0003)ygMZ:fi6\u000b\u0007\u000fI\u0001\rS>\u0014UO\u001a4feNK'0Z\u0001\u0010[\u0006D\u0018j\u001c\"vM\u001a,'oU5{K\u0006\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011\u0011FR\u0005\u0003\u000f*\u0012a\u0001R8vE2,\u0017!\u0003;ie>$H\u000f\\3s!\ty#*\u0003\u0002La\tIA\u000b\u001b:piRdWM]\u0001\u0005i&lW\r\u0005\u0002O/6\tqJ\u0003\u00022!*\u0011\u0011KU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019\u001a&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001W(\u0003\tQKW.Z\u0001\nG\",7m\u001b#p]\u0016\u0004B!K.^C&\u0011AL\u000b\u0002\n\rVt7\r^5p]F\u0002\"AX0\u000e\u0003AK!\u0001\u0019)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0011FY\u0005\u0003G*\u0012A!\u00168ji\u00061A(\u001b8jiz\"\u0012BZ4iS*\\G.\u001c8\u0011\u0005y\u0002\u0001\"\u0002\u001b\f\u0001\u00049\u0004\"B\u001e\f\u0001\u0004i\u0004\"\u0002\"\f\u0001\u00049\u0004\"B\"\f\u0001\u00049\u0004\"\u0002#\f\u0001\u0004)\u0005\"\u0002%\f\u0001\u0004I\u0005\"\u0002'\f\u0001\u0004i\u0005\"B-\f\u0001\u0004Q\u0016A\u00037pO\u001e,'OT1nKV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\rM#(/\u001b8h\u0003)\u0011X-\u00193Ck\u001a4WM]\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011a0^\u0001\u0004]&|\u0017bAA\u0001{\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001dI,\u0017\r\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0002\t\u0011\u0005%a\"!AA\u0002m\f1\u0001\u001f\u00132\u0003-\u0011X-\u00193Ck\u001a4WM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u0001\u0010oJLG/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0005\t\u0011\u0005%\u0011#!AA\u0002m\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002\n1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u000e!\rq\u0015QD\u0005\u0004\u0003?y%A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\u001dI\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Ck\u001a4WM]*vaBd\u0017.\u001a:!\u0003\u0015\u0019G.Z1o)\u0011\t9#!\u000f\u0011\u000f%\nI#!\f\u00024%\u0019\u00111\u0006\u0016\u0003\rQ+\b\u000f\\33!\rI\u0013qF\u0005\u0004\u0003cQ#\u0001\u0002'p]\u001e\u00042APA\u001b\u0013\r\t9d\t\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\b\u0003w)\u0002\u0019AA\u001f\u0003%\u0019G.Z1oC\ndW\rE\u0002?\u0003\u007fI1!!\u0011$\u0005)aun\u001a+p\u00072,\u0017M\\\u0001\bI>\u001cE.Z1o)\u0019\t9#a\u0012\u0002J!9\u00111\b\fA\u0002\u0005u\u0002bBA&-\u0001\u0007\u0011QF\u0001\u0010I\u0016dW\r^3I_JL'p\u001c8Ng\u0006i1\r\\3b]N+w-\\3oiN$R\"YA)\u00033\ny'a\u001d\u0002v\u0005e\u0004B\u0002\u0013\u0018\u0001\u0004\t\u0019\u0006E\u0002?\u0003+J1!a\u0016$\u0005\raun\u001a\u0005\b\u00037:\u0002\u0019AA/\u0003!\u0019XmZ7f]R\u001c\bCBA0\u0003K\nI'\u0004\u0002\u0002b)\u0019\u00111\r\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0005\u0005$aA*fcB\u0019a(a\u001b\n\u0007\u000554E\u0001\u0006M_\u001e\u001cVmZ7f]RDa!!\u001d\u0018\u0001\u0004i\u0014aA7ba\"9\u00111J\fA\u0002\u00055\u0002bBA</\u0001\u0007\u00111G\u0001\u0006gR\fGo\u001d\u0005\b\u0003w:\u0002\u0019AA?\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\rq\u0014qP\u0005\u0004\u0003\u0003\u001b#AG\"mK\u0006tW\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0017!C2mK\u0006t\u0017J\u001c;p)M\t\u0017qQAF\u00037\u000by*!)\u0002,\u0006=\u0016\u0011WAi\u0011\u0019\tI\t\u0007a\u0001;\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAG1\u0001\u0007\u0011qR\u0001\u000eg>,(oY3SK\u000e|'\u000fZ:\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&Q\u0003\u0019\u0011XmY8sI&!\u0011\u0011TAJ\u0005-1\u0015\u000e\\3SK\u000e|'\u000fZ:\t\u000f\u0005u\u0005\u00041\u0001\u0002j\u0005!A-Z:u\u0011\u0019\t\t\b\u0007a\u0001{!9\u00111\u0015\rA\u0002\u0005\u0015\u0016A\u0007:fi\u0006Lg\u000eR3mKR,7/\u00118e)btW*\u0019:lKJ\u001c\bcA\u0015\u0002(&\u0019\u0011\u0011\u0016\u0016\u0003\u000f\t{w\u000e\\3b]\"1\u0011Q\u0016\rA\u0002]\n\u0011#\\1y\u0019><W*Z:tC\u001e,7+\u001b>f\u0011\u001d\tY\b\u0007a\u0001\u0003{Bq!a-\u0019\u0001\u0004\t),\u0001\u000fmCN$(+Z2pe\u0012\u001cxJZ!di&4X\r\u0015:pIV\u001cWM]:\u0011\u0011\u0005]\u0016QYA\u0017\u0003\u0017tA!!/\u0002BB\u0019\u00111\u0018\u0016\u000e\u0005\u0005u&bAA`k\u00051AH]8pizJ1!a1+\u0003\u0019\u0001&/\u001a3fM&!\u0011qYAe\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u0007T\u0003c\u0001 \u0002N&\u0019\u0011qZ\u0012\u0003\u00151\u000b7\u000f\u001e*fG>\u0014H\rC\u0004\u0002xa\u0001\r!a\r\u0002#\u001d\u0014xn\u001e\"vM\u001a,'o](s\r\u0006LG\u000eF\u0005b\u0003/\fI.!8\u0002`\"9\u0011QR\rA\u0002\u0005=\u0005BBAn3\u0001\u0007q'\u0001\u0005q_NLG/[8o\u0011\u0019\ti+\u0007a\u0001o!9\u0011\u0011]\rA\u0002\u0005\r\u0018!D7f[>\u0014\u0018PU3d_J$7\u000f\u0005\u0003\u0002\u0012\u0006\u0015\u0018\u0002BAt\u0003'\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\u0018AE:i_VdG\rR5tG\u0006\u0014HMQ1uG\"$\u0002\"!*\u0002n\u0006]\u0018\u0011 \u0005\b\u0003_T\u0002\u0019AAy\u0003\u0015\u0011\u0017\r^2i!\u0011\t\t*a=\n\t\u0005U\u00181\u0013\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eC\u0004\u0002|i\u0001\r!! \t\u000f\u0005m(\u00041\u0001\u0002&\u0006\u0001\"/\u001a;bS:$\u0006P\\'be.,'o]\u0001\u0013g\"|W\u000f\u001c3SKR\f\u0017N\u001c*fG>\u0014H\r\u0006\u0007\u0002&\n\u0005!1\u0001B\u0004\u0005\u0013\u0011\t\u0002\u0003\u0004\u0002rm\u0001\r!\u0010\u0005\b\u0005\u000bY\u0002\u0019AAS\u00035\u0011X\r^1j]\u0012+G.\u001a;fg\"9\u0011q^\u000eA\u0002\u0005E\bbBAK7\u0001\u0007!1\u0002\t\u0005\u0003#\u0013i!\u0003\u0003\u0003\u0010\u0005M%A\u0002*fG>\u0014H\rC\u0004\u0002xm\u0001\r!a\r\u0002\u0017\u001d\u0014xn\u001e\"vM\u001a,'o\u001d\u000b\u0004C\n]\u0001BBAW9\u0001\u0007q'\u0001\bsKN$xN]3Ck\u001a4WM]:\u0015\u0003\u0005\f1c\u001a:pkB\u001cVmZ7f]R\u001c()_*ju\u0016$\"B!\t\u00034\tm\"q\bB\"!\u0019\u0011\u0019C!\f\u0002^9!!Q\u0005B\u0015\u001d\u0011\tYLa\n\n\u0003-J1Aa\u000b+\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\f\u00032\t!A*[:u\u0015\r\u0011YC\u000b\u0005\b\u00037r\u0002\u0019\u0001B\u001b!\u0019\tyFa\u000e\u0002j%!!\u0011HA1\u0005!IE/\u001a:bE2,\u0007B\u0002B\u001f=\u0001\u0007q'A\u0004nCb\u001c\u0016N_3\t\r\t\u0005c\u00041\u00018\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0011\u001d\u0011)E\ba\u0001\u0003[\taCZ5sgR,fn\u00197fC:\f'\r\\3PM\u001a\u001cX\r^\u0001\u001aY\u0006\u001cHo\u00144gg\u0016$hi\u001c:GSJ\u001cHoU3h[\u0016tG\u000f\u0006\u0004\u0002.\t-#\u0011\u000b\u0005\b\u0005\u001bz\u0002\u0019\u0001B(\u0003\u0011\u0019XmZ:\u0011\r\t\r\"QFA5\u0011\u001d\u0011)e\ba\u0001\u0003[\taBY;jY\u0012|eMZ:fi6\u000b\u0007\u000fF\u0006b\u0005/\u0012IF!\u0018\u0003b\t\r\u0004B\u0002\u0013!\u0001\u0004\t\u0019\u0006C\u0004\u0003\\\u0001\u0002\r!!\f\u0002\u000bM$\u0018M\u001d;\t\u000f\t}\u0003\u00051\u0001\u0002.\u0005\u0019QM\u001c3\t\r\u0005E\u0004\u00051\u0001>\u0011\u001d\t9\b\ta\u0001\u0003g\t\u0001DY;jY\u0012|eMZ:fi6\u000b\u0007OR8s'\u0016<W.\u001a8u)I\t)K!\u001b\u0003l\t=$\u0011\u000fB;\u0005s\u0012YH! \t\r\u0005%\u0015\u00051\u0001^\u0011\u001d\u0011i'\ta\u0001\u0003S\nqa]3h[\u0016tG\u000f\u0003\u0004\u0002r\u0005\u0002\r!\u0010\u0005\b\u0005g\n\u0003\u0019AA\u0017\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\t]\u0014\u00051\u0001\u0002.\u00051b.\u001a=u'\u0016<W.\u001a8u'R\f'\u000f^(gMN,G\u000f\u0003\u0004\u0002.\u0006\u0002\ra\u000e\u0005\b\u0003w\n\u0003\u0019AA?\u0011\u001d\t9(\ta\u0001\u0003g\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        long l;
        Option option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        long deleteHorizonMs = l;
        return this.doClean(cleanable, deleteHorizonMs);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Beginning cleaning of log %s."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for %s..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(deleteHorizonMs)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), deleteHorizonMs, stats, transactionMetadata);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats, CleanedTransactionMetadata transactionMetadata) {
        LogSegment cleaned = LogCleaner$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> currentSegment.readNextOffset()));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainDeletesAndTxnMarkers = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with deletion horizon ").append(deleteHorizonMs).append(", ").append((Object)(retainDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletesAndTxnMarkers, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, lastOffsetOfActiveProducers, stats);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments, log.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletesAndTxnMarkers, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, transactionMetadata, retainDeletesAndTxnMarkers, lastRecordsOfActiveProducers, map, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final boolean retainDeletesAndTxnMarkers$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$1;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2, this.retainDeletesAndTxnMarkers$2));
                if (batch.hasProducerId() && this.isBatchLastRecordOfProducer$1(batch)) {
                    return MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY;
                }
                if (this.discardBatchRecords()) {
                    return MemoryRecords.RecordFilter.BatchRetention.DELETE;
                }
                return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                if (batch.isControlBatch()) {
                    return true;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$1, this.retainDeletesAndTxnMarkers$2, batch, record, this.stats$3);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                Option<Object> option = lastRecord.lastDataOffset();
                if (option instanceof Some) {
                    long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    return batch$1.lastOffset() == offset;
                }
                if (None$.MODULE$.equals(option)) {
                    return batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch();
                }
                throw new MatchError(option);
            }

            private final boolean isBatchLastRecordOfProducer$1(RecordBatch batch$1) {
                return this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch$1.producerId())).exists((Function1 & Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch$1, lastRecord)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.retainDeletesAndTxnMarkers$2 = retainDeletesAndTxnMarkers$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$1 = map$1;
                this.stats$3 = stats$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch kafka.log.LastRecord )}, serializedLambda);
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch) && !retainTxnMarkers;
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record, CleanerStats stats) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean bl = isRetainedValue = record.hasValue() || retainDeletes;
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            return;
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableOnceOps)dirty.tail()).foreach((Function1 & Serializable)nextSegment -> (ListBuffer)nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)nextSegment.baseOffset())));
            nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)end));
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d)."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        ((IterableOps)dirty.zip((IterableOnce)nextSegmentStartOffsets)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$3(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$15))).foreach((Function1 & Serializable)x$16 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, full, map, start, transactionMetadata, stats, dirty, x$16);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map for log %s complete."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, long nextSegmentStartOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(67).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(this, transactionMetadata, stats, startOffset, map, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(nextSegmentStartOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$15) {
        if (x$15 != null) {
            return !full$1.elem;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, Log log$3, BooleanRef full$1, OffsetMap map$2, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Buffer dirty$1, Tuple2 x$16) {
        if (x$16 != null) {
            LogSegment segment = (LogSegment)x$16._1();
            long nextSegmentStartOffset = x$16._2$mcJ$sp();
            $this.checkDone.apply((Object)log$3.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$3.topicPartition(), segment, map$2, start$1, nextSegmentStartOffset, Predef$.MODULE$.Integer2int(log$3.config().maxMessageSize()), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$3.size() < maxDesiredMapSize$1) {
                map$3.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$5, long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$4.onControlBatchRead((RecordBatch)batch);
            stats$5.indexMessagesRead(1);
        } else if (transactionMetadata$4.onBatchRead((RecordBatch)batch)) {
            stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
        } else {
            try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
                CollectionConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)recordsIterator).asScala().foreach((Function1 & Serializable)record -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$2(startOffset$1, map$3, maxDesiredMapSize$1, nonLocalReturnKey1$1, stats$5, record);
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (batch.lastOffset() >= startOffset$1) {
            map$3.updateLatestOffset(batch.lastOffset());
            return;
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.checkDone = checkDone;
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

