/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.base.Preconditions;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.SchemaManager;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.RegisteredSchema;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.kafka.common.errors.SerializationException;

final class SchemaManagerImpl
implements SchemaManager {
    private final SchemaRegistryClient schemaRegistryClient;
    private final SubjectNameStrategy defaultSubjectNameStrategy;

    @Inject
    SchemaManagerImpl(SchemaRegistryClient schemaRegistryClient, SubjectNameStrategy defaultSubjectNameStrategy) {
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient);
        this.defaultSubjectNameStrategy = Objects.requireNonNull(defaultSubjectNameStrategy);
    }

    @Override
    public RegisteredSchema getSchema(String topicName, Optional<EmbeddedFormat> format, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, Optional<Integer> schemaId, Optional<Integer> schemaVersion, Optional<String> rawSchema, boolean isKey) {
        if (schemaId.isPresent()) {
            Preconditions.checkArgument((!format.isPresent() ? 1 : 0) != 0);
            Preconditions.checkArgument((!schemaVersion.isPresent() ? 1 : 0) != 0);
            Preconditions.checkArgument((!rawSchema.isPresent() ? 1 : 0) != 0);
            return this.getSchemaFromSchemaId(topicName, subject, subjectNameStrategy, schemaId.get(), isKey);
        }
        if (schemaVersion.isPresent()) {
            Preconditions.checkArgument((!format.isPresent() ? 1 : 0) != 0);
            Preconditions.checkArgument((!rawSchema.isPresent() ? 1 : 0) != 0);
            return this.getSchemaFromSchemaVersion(topicName, subject, subjectNameStrategy, schemaVersion.get(), isKey);
        }
        if (rawSchema.isPresent()) {
            Preconditions.checkArgument((boolean)format.isPresent());
            return this.getSchemaFromRawSchema(topicName, format.get(), subject, subjectNameStrategy, rawSchema.get(), isKey);
        }
        Preconditions.checkArgument((!format.isPresent() ? 1 : 0) != 0);
        return this.findLatestSchema(topicName, subject, subjectNameStrategy, isKey);
    }

    private RegisteredSchema getSchemaFromSchemaId(String topicName, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, int schemaId, boolean isKey) {
        ParsedSchema schema;
        try {
            schema = this.schemaRegistryClient.getSchemaById(schemaId);
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException(String.format("Error when fetching schema by id. schemaId = %d", schemaId), e);
        }
        String actualSubject = subject.orElse(subjectNameStrategy.orElse(this.defaultSubjectNameStrategy).subjectName(topicName, isKey, schema));
        int schemaVersion = this.getSchemaVersion(actualSubject, schema);
        return RegisteredSchema.create(actualSubject, schemaId, schemaVersion, schema);
    }

    private int getSchemaVersion(String subject, ParsedSchema schema) {
        try {
            return this.schemaRegistryClient.getVersion(subject, schema);
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException(String.format("Error when fetching schema version. subject = %s, schema = %s", subject, schema.canonicalString()), e);
        }
    }

    private RegisteredSchema getSchemaFromSchemaVersion(String topicName, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, int schemaVersion, boolean isKey) {
        String actualSubject = subject.orElse(this.getSchemaSubjectUnsafe(topicName, isKey, subjectNameStrategy));
        Schema schema = this.schemaRegistryClient.getByVersion(actualSubject, schemaVersion, false);
        ParsedSchema parsedSchema = (ParsedSchema)EmbeddedFormat.forSchemaType(schema.getSchemaType()).getSchemaProvider().parseSchema(schema.getSchema(), schema.getReferences(), false).orElseThrow(() -> Errors.invalidSchemaException(String.format("Error when fetching schema by version. subject = %s, version = %d", actualSubject, schemaVersion)));
        return RegisteredSchema.create(schema.getSubject(), schema.getId(), schemaVersion, parsedSchema);
    }

    private RegisteredSchema getSchemaFromRawSchema(String topicName, EmbeddedFormat format, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, String rawSchema, boolean isKey) {
        int schemaId;
        Preconditions.checkArgument((boolean)format.requiresSchema(), (String)"%s does not support schemas.", (Object)((Object)format));
        ParsedSchema schema = (ParsedSchema)format.getSchemaProvider().parseSchema(rawSchema, Collections.emptyList(), true).orElseThrow(() -> Errors.invalidSchemaException(String.format("Error when parsing raw schema. format = %s, schema = %s", new Object[]{format, rawSchema})));
        String actualSubject = subject.orElse(subjectNameStrategy.orElse(this.defaultSubjectNameStrategy).subjectName(topicName, isKey, schema));
        try {
            try {
                schemaId = this.schemaRegistryClient.getId(actualSubject, schema);
            }
            catch (RestClientException | IOException e) {
                schemaId = this.schemaRegistryClient.register(actualSubject, schema);
            }
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException(String.format("Error when registering schema. format = %s, subject = %s, schema = %s", new Object[]{format, actualSubject, schema.canonicalString()}), e);
        }
        int schemaVersion = this.getSchemaVersion(actualSubject, schema);
        return RegisteredSchema.create(actualSubject, schemaId, schemaVersion, schema);
    }

    private RegisteredSchema findLatestSchema(String topicName, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, boolean isKey) {
        SchemaMetadata metadata;
        String actualSubject = subject.orElse(this.getSchemaSubjectUnsafe(topicName, isKey, subjectNameStrategy));
        try {
            metadata = this.schemaRegistryClient.getLatestSchemaMetadata(actualSubject);
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException(String.format("Error when fetching latest schema version. subject = %s", actualSubject), e);
        }
        ParsedSchema schema = (ParsedSchema)EmbeddedFormat.forSchemaType(metadata.getSchemaType()).getSchemaProvider().parseSchema(metadata.getSchema(), metadata.getReferences(), false).orElseThrow(() -> Errors.invalidSchemaException(String.format("Error when fetching latest schema version. subject = %s", actualSubject)));
        return RegisteredSchema.create(actualSubject, metadata.getId(), metadata.getVersion(), schema);
    }

    private String getSchemaSubjectUnsafe(String topicName, boolean isKey, Optional<SubjectNameStrategy> subjectNameStrategy) {
        SubjectNameStrategy strategy = subjectNameStrategy.orElse(this.defaultSubjectNameStrategy);
        String subject = null;
        Exception cause = null;
        try {
            subject = strategy.subjectName(topicName, isKey, null);
        }
        catch (Exception e) {
            cause = e;
        }
        if (subject == null) {
            IllegalArgumentException error = new IllegalArgumentException(String.format("Cannot use%s schema_subject_strategy%s without schema_id or schema.", subjectNameStrategy.map(requestStrategy -> "").orElse(" default"), subjectNameStrategy.map(requestStrategy -> "=" + strategy).orElse("")));
            if (cause != null) {
                error.initCause(cause);
            }
            throw error;
        }
        return subject;
    }
}

