/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.regex.Pattern;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogConfig;
import kafka.log.LogLoader$;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Log$
implements Logging {
    public static final Log$ MODULE$ = new Log$();
    private static final String LogFileSuffix = ".log";
    private static final String IndexFileSuffix = ".index";
    private static final String TimeIndexFileSuffix = ".timeindex";
    private static final String ProducerSnapshotFileSuffix = ".snapshot";
    private static final String TxnIndexFileSuffix = ".txnindex";
    private static final String DeletedFileSuffix = ".deleted";
    private static final String CleanedFileSuffix = ".cleaned";
    private static final String SwapFileSuffix = ".swap";
    private static final String CleanShutdownFile = ".kafka_cleanshutdown";
    private static final String DeleteDirSuffix = "-delete";
    private static final String FutureDirSuffix = "-future";
    private static final Pattern DeleteDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(MODULE$.DeleteDirSuffix()).toString());
    private static final Pattern FutureDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(MODULE$.FutureDirSuffix()).toString());
    private static final long UnknownOffset = -1L;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String LogFileSuffix() {
        return LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return TimeIndexFileSuffix;
    }

    public String ProducerSnapshotFileSuffix() {
        return ProducerSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return FutureDirSuffix;
    }

    public Pattern DeleteDirPattern() {
        return DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return FutureDirPattern;
    }

    public long UnknownOffset() {
        return UnknownOffset;
    }

    public Log apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile) {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        Option<LeaderEpochFileCache> leaderEpochCache = this.maybeCreateLeaderEpochCache(dir, topicPartition, logDirFailureChannel, config.recordVersion(), new StringBuilder(23).append("[Log partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxProducerIdExpirationMs, time);
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(dir, topicPartition, config, scheduler, time, logDirFailureChannel, lastShutdownClean, segments, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        return new Log(dir, config, segments, offsets.logStartOffset(), offsets.recoveryPoint(), offsets.nextOffsetMetadata(), scheduler, brokerTopicStats, time, producerIdExpirationCheckIntervalMs, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, topicId, keepPartitionMetadataFile);
    }

    public Time apply$default$7() {
        return Time.SYSTEM;
    }

    public boolean apply$default$11() {
        return true;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.LogFileSuffix()).append(suffix).toString());
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        String suffix = new StringBuilder(2).append("-").append(topicPartition.partition()).append(".").append(uniqueId).append(this.DeleteDirSuffix()).toString();
        int prefixLength = Math.min(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(topicPartition.topic())), 255 - StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(suffix)));
        return new StringBuilder(0).append(topicPartition.topic().substring(0, prefixLength)).append(suffix).toString();
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    private String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringBuilder(1).append(this.logDirName(topicPartition)).append(".").append(uniqueId).append(suffix).toString();
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringBuilder(1).append(topicPartition.topic()).append("-").append(topicPartition.partition()).toString();
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.IndexFileSuffix()).append(suffix).toString());
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TimeIndexFileSuffix()).append(suffix).toString());
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        Files.deleteIfExists(new File(new StringBuilder(0).append(file.getPath()).append(suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File producerSnapshotFile(File dir, long offset) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.ProducerSnapshotFileSuffix()).toString());
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TxnIndexFileSuffix()).append(suffix).toString());
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFileName(String filename) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(0, filename.indexOf(46))));
    }

    public long offsetFromFile(File file) {
        return this.offsetFromFileName(file.getName());
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)segments.map((Function1 & Serializable)x$34 -> BoxesRunTime.boxToLong((long)x$34.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        int n;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(dirName), '-')) {
            throw Log$.exception$1(dir);
        }
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches()) {
            throw Log$.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw Log$.exception$1(dir);
        }
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partitionString));
        }
        catch (NumberFormatException numberFormatException) {
            throw Log$.exception$1(dir);
        }
        int partition = n;
        return new TopicPartition(topic, partition);
    }

    public boolean isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    private void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records) {
        Map loadedProducers = (Map)Map$.MODULE$.empty();
        ListBuffer completedTxns = ListBuffer$.MODULE$.empty();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                MODULE$.kafka$log$Log$$updateProducers(producerStateManager, (RecordBatch)batch, (Map<Object, ProducerAppendInfo>)loadedProducers, (Option<LogOffsetMetadata>)None$.MODULE$, AppendOrigin$Replication$.MODULE$).foreach((Function1 & Serializable)x$35 -> (ListBuffer)completedTxns.$plus$eq(x$35));
                return;
            }
        });
        loadedProducers.values().foreach((Function1 & Serializable)appendInfo -> {
            producerStateManager.update(appendInfo);
            return BoxedUnit.UNIT;
        });
        completedTxns.foreach((Function1 & Serializable)completedTxn -> {
            producerStateManager.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CompletedTxn> kafka$log$Log$$updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Object, ProducerAppendInfo> producers, Option<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin) {
        long producerId = batch.producerId();
        return ((ProducerAppendInfo)producers.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable)() -> producerStateManager.prepareUpdate(producerId, origin))).append(batch, firstOffsetMetadata);
    }

    public Option<LeaderEpochFileCache> maybeCreateLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, RecordVersion recordVersion, String logPrefix) {
        File leaderEpochFile = LeaderEpochCheckpointFile$.MODULE$.newFile(dir);
        if (recordVersion.precedes(RecordVersion.V2)) {
            if ((leaderEpochFile.exists() ? new Some((Object)Log$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition)) : None$.MODULE$).exists((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)x$36.nonEmpty())) && this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = Log$.$anonfun$maybeCreateLeaderEpochCache$2(logPrefix, recordVersion);
                Object var7_7 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            Files.deleteIfExists(leaderEpochFile.toPath());
            return None$.MODULE$;
        }
        return new Some((Object)Log$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition));
    }

    public void replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, ProducerStateManager producerStateManager, String logPrefix) {
        Seq sortedNewSegments = (Seq)newSegments.sortBy((Function1 & Serializable)x$37 -> BoxesRunTime.boxToLong((long)x$37.baseOffset()), (Ordering)Ordering.Long$.MODULE$);
        Seq sortedOldSegments = (Seq)((SeqOps)oldSegments.filter((Function1 & Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)existingSegments.contains(seg.baseOffset())))).sortBy((Function1 & Serializable)x$38 -> BoxesRunTime.boxToLong((long)x$38.baseOffset()), (Ordering)Ordering.Long$.MODULE$);
        if (!isRecoveredSwapFile) {
            ((IterableOnceOps)sortedNewSegments.reverse()).foreach((Function1 & Serializable)x$39 -> {
                x$39.changeFileSuffixes(Log$.MODULE$.CleanedFileSuffix(), Log$.MODULE$.SwapFileSuffix());
                return BoxedUnit.UNIT;
            });
        }
        ((IterableOnceOps)sortedNewSegments.reverse()).foreach((Function1 & Serializable)x$40 -> existingSegments.add((LogSegment)x$40));
        Set newSegmentBaseOffsets = ((IterableOnceOps)sortedNewSegments.map((Function1 & Serializable)x$41 -> BoxesRunTime.boxToLong((long)x$41.baseOffset()))).toSet();
        sortedOldSegments.foreach((Function1 & Serializable)seg -> {
            Log$.$anonfun$replaceSegments$7(sortedNewSegments, existingSegments, newSegmentBaseOffsets, dir, topicPartition, config, scheduler, logDirFailureChannel, producerStateManager, logPrefix, seg);
            return BoxedUnit.UNIT;
        });
        sortedNewSegments.foreach((Function1 & Serializable)x$42 -> {
            x$42.changeFileSuffixes(Log$.MODULE$.SwapFileSuffix(), "");
            return BoxedUnit.UNIT;
        });
        Utils.flushDir((Path)dir.toPath());
    }

    public boolean replaceSegments$default$4() {
        return false;
    }

    public void deleteSegmentFiles(scala.collection.immutable.Iterable<LogSegment> segmentsToDelete, boolean asyncDelete, boolean deleteProducerStateSnapshots, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, ProducerStateManager producerStateManager, String logPrefix) {
        Nil$ snapshotsToDelete;
        segmentsToDelete.foreach((Function1 & Serializable)x$43 -> {
            x$43.changeFileSuffixes("", Log$.MODULE$.DeletedFileSuffix());
            return BoxedUnit.UNIT;
        });
        Object object = snapshotsToDelete = deleteProducerStateSnapshots ? (Iterable)segmentsToDelete.flatMap((Function1 & Serializable)segment -> producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset())) : Nil$.MODULE$;
        if (asyncDelete) {
            scheduler.schedule("delete-file", (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> Log$.$anonfun$deleteSegmentFiles$8(this, logPrefix, segmentsToDelete, dir, logDirFailureChannel, topicPartition, (Iterable)snapshotsToDelete)), Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()), scheduler.schedule$default$4(), scheduler.schedule$default$5());
            return;
        }
        this.deleteSegments$1(logPrefix, segmentsToDelete, dir, logDirFailureChannel, topicPartition, (Iterable)snapshotsToDelete);
    }

    public boolean deleteSegmentFiles$default$3() {
        return true;
    }

    public <T> T kafka$log$Log$$maybeHandleIOException(LogDirFailureChannel logDirFailureChannel, String logDir, Function0<String> errorMsg, Function0<T> fun) {
        if (logDirFailureChannel.hasOfflineLogDir(logDir)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(logDir).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            return (T)fun.apply();
        }
        catch (IOException e) {
            logDirFailureChannel.maybeAddOfflineLogDir(logDir, errorMsg, e);
            throw new KafkaStorageException((String)errorMsg.apply(), (Throwable)e);
        }
    }

    public void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, RecordVersion recordVersion, Time time, boolean reloadFromCleanShutdown, String logPrefix) {
        .colon.colon offsetsToSnapshot;
        .colon.colon colon2;
        if (segments.nonEmpty()) {
            long lastSegmentBaseOffset = ((LogSegment)segments.lastSegment().get()).baseOffset();
            Option nextLatestSegmentBaseOffset = segments.lowerSegment(lastSegmentBaseOffset).map((Function1 & Serializable)x$44 -> BoxesRunTime.boxToLong((long)x$44.baseOffset()));
            colon2 = new .colon.colon((Object)nextLatestSegmentBaseOffset, (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastSegmentBaseOffset)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$)));
        } else {
            colon2 = offsetsToSnapshot = new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = Log$.$anonfun$rebuildProducerState$2(logPrefix, lastOffset, recordVersion);
            Object var21_12 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        if (recordVersion.value < 2 || producerStateManager.latestSnapshotOffset().isEmpty() && reloadFromCleanShutdown) {
            ((IterableOnceOps)offsetsToSnapshot.flatten(Predef$.MODULE$.$conforms())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)offset -> {
                producerStateManager.updateMapEndOffset(offset);
                producerStateManager.takeSnapshot();
            });
            return;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = Log$.$anonfun$rebuildProducerState$4(logPrefix, lastOffset);
            Object var22_13 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
        long producerStateLoadStart = time.milliseconds();
        producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
        long segmentRecoveryStart = time.milliseconds();
        if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
            Option<LogSegment> segmentOfLastOffset = segments.floorSegment(lastOffset);
            segments.values(producerStateManager.mapEndOffset(), lastOffset).foreach(arg_0 -> Log$.$anonfun$rebuildProducerState$5$adapted(producerStateManager, logStartOffset, (Seq)offsetsToSnapshot, segmentOfLastOffset, lastOffset, arg_0));
        }
        producerStateManager.updateMapEndOffset(lastOffset);
        producerStateManager.takeSnapshot();
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = Log$.$anonfun$rebuildProducerState$8(logPrefix, segmentRecoveryStart, producerStateLoadStart, time, lastOffset);
            Object var23_18 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            return;
        }
    }

    public List<LogSegment> splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, ProducerStateManager producerStateManager, String logPrefix) {
        Predef$.MODULE$.require(this.isLogFile(segment.log().file()), (Function0 & Serializable)() -> new StringBuilder(18).append("Cannot split file ").append(segment.log().file().getAbsoluteFile()).toString());
        Predef$.MODULE$.require(segment.hasOverflow(), (Function0 & Serializable)() -> new StringBuilder(86).append("Split operation is only permitted for segments with overflow, and the problem path is ").append(segment.log().file().getAbsoluteFile()).toString());
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = Log$.$anonfun$splitOverflowedSegment$3(logPrefix, segment);
            Object var18_10 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        ListBuffer newSegments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            int bytesAppended;
            FileRecords sourceRecords = segment.log();
            for (int position = 0; position < sourceRecords.sizeInBytes(); position += bytesAppended) {
                FileLogInputStream.FileChannelRecordBatch firstBatch = (FileLogInputStream.FileChannelRecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(sourceRecords.batchesFrom(position)).asScala().head();
                LogSegment newSegment = LogCleaner$.MODULE$.createNewCleanedSegment(dir, config, firstBatch.baseOffset());
                newSegments.$plus$eq((Object)newSegment);
                bytesAppended = newSegment.appendFromFile(sourceRecords, position);
                if (bytesAppended != 0) continue;
                throw new IllegalStateException(new StringBuilder(43).append("Failed to append records from position ").append(position).append(" in ").append(segment).toString());
            }
            IntRef totalSizeOfNewSegments = IntRef.create((int)0);
            newSegments.foreach((Function1 & Serializable)splitSegment -> {
                Log$.$anonfun$splitOverflowedSegment$4(segment, totalSizeOfNewSegments, splitSegment);
                return BoxedUnit.UNIT;
            });
            if (totalSizeOfNewSegments.elem != segment.log().sizeInBytes()) {
                throw new IllegalStateException(new StringBuilder(55).append("Inconsistent segment sizes after split").append(" before: ").append(segment.log().sizeInBytes()).append(" after: ").append(totalSizeOfNewSegments.elem).toString());
            }
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = Log$.$anonfun$splitOverflowedSegment$5(logPrefix, segment, newSegments);
                Object var19_18 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.replaceSegments(existingSegments, (Seq<LogSegment>)newSegments.toList(), (Seq<LogSegment>)new .colon.colon((Object)segment, (List)Nil$.MODULE$), false, dir, topicPartition, config, scheduler, logDirFailureChannel, producerStateManager, logPrefix);
            return newSegments.toList();
        }
        catch (Exception e) {
            newSegments.foreach((Function1 & Serializable)splitSegment -> {
                Log$.$anonfun$splitOverflowedSegment$6(splitSegment);
                return BoxedUnit.UNIT;
            });
            throw e;
        }
    }

    public <T> Option<T> kafka$log$Log$$nextOption(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return new Some(iterator.next());
        }
        return None$.MODULE$;
    }

    private static final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder(196).append("Found directory ").append(dir.getCanonicalPath()).append(", '").append(dir.getName()).append("' is not in the form of ").append("topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append("Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    private static final LeaderEpochFileCache newLeaderEpochFileCache$1(File leaderEpochFile$1, LogDirFailureChannel logDirFailureChannel$1, TopicPartition topicPartition$1) {
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile$1, logDirFailureChannel$1);
        return new LeaderEpochFileCache(topicPartition$1, checkpointFile);
    }

    public static final /* synthetic */ String $anonfun$maybeCreateLeaderEpochCache$2(String logPrefix$1, RecordVersion recordVersion$1) {
        return new StringBuilder(73).append(logPrefix$1).append("Deleting non-empty leader epoch cache due to incompatible message format ").append(recordVersion$1).toString();
    }

    public static final /* synthetic */ void $anonfun$replaceSegments$7(Seq sortedNewSegments$1, LogSegments existingSegments$1, Set newSegmentBaseOffsets$1, File dir$1, TopicPartition topicPartition$2, LogConfig config$1, Scheduler scheduler$1, LogDirFailureChannel logDirFailureChannel$2, ProducerStateManager producerStateManager$3, String logPrefix$2, LogSegment seg) {
        if (seg.baseOffset() != ((LogSegment)sortedNewSegments$1.head()).baseOffset()) {
            existingSegments$1.remove(seg.baseOffset());
        }
        MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)new .colon.colon((Object)seg, (List)Nil$.MODULE$), true, !newSegmentBaseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)seg.baseOffset())), dir$1, topicPartition$2, config$1, scheduler$1, logDirFailureChannel$2, producerStateManager$3, logPrefix$2);
    }

    public static final /* synthetic */ String $anonfun$deleteSegmentFiles$3(String logPrefix$3, scala.collection.immutable.Iterable segmentsToDelete$1) {
        return new StringBuilder(23).append(logPrefix$3).append("Deleting segment files ").append(segmentsToDelete$1.mkString(",")).toString();
    }

    public static final /* synthetic */ void $anonfun$deleteSegmentFiles$5(scala.collection.immutable.Iterable segmentsToDelete$1, Iterable snapshotsToDelete$1) {
        segmentsToDelete$1.foreach((Function1 & Serializable)segment -> {
            segment.deleteIfExists();
            return BoxedUnit.UNIT;
        });
        snapshotsToDelete$1.foreach((Function1 & Serializable)snapshot -> BoxesRunTime.boxToBoolean((boolean)snapshot.deleteIfExists()));
    }

    private final void deleteSegments$1(String logPrefix$3, scala.collection.immutable.Iterable segmentsToDelete$1, File dir$2, LogDirFailureChannel logDirFailureChannel$3, TopicPartition topicPartition$3, Iterable snapshotsToDelete$1) {
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = Log$.$anonfun$deleteSegmentFiles$3(logPrefix$3, segmentsToDelete$1);
            Object var10_7 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        String parentDir = dir$2.getParent();
        Function0 & Serializable kafka$log$Log$$maybeHandleIOException_errorMsg = (Function0 & Serializable)() -> new StringBuilder(42).append("Error while deleting segments for ").append(topicPartition$3).append(" in dir ").append(parentDir).toString();
        if (logDirFailureChannel$3.hasOfflineLogDir(parentDir)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(parentDir).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            Log$.$anonfun$deleteSegmentFiles$5(segmentsToDelete$1, snapshotsToDelete$1);
            return;
        }
        catch (IOException kafka$log$Log$$maybeHandleIOException_e) {
            logDirFailureChannel$3.maybeAddOfflineLogDir(parentDir, (Function0<String>)kafka$log$Log$$maybeHandleIOException_errorMsg, kafka$log$Log$$maybeHandleIOException_e);
            throw new KafkaStorageException(Log$.$anonfun$deleteSegmentFiles$4(topicPartition$3, parentDir), (Throwable)kafka$log$Log$$maybeHandleIOException_e);
        }
    }

    public static final /* synthetic */ void $anonfun$deleteSegmentFiles$8(Log$ $this, String logPrefix$3, scala.collection.immutable.Iterable segmentsToDelete$1, File dir$2, LogDirFailureChannel logDirFailureChannel$3, TopicPartition topicPartition$3, Iterable snapshotsToDelete$1) {
        $this.deleteSegments$1(logPrefix$3, segmentsToDelete$1, dir$2, logDirFailureChannel$3, topicPartition$3, snapshotsToDelete$1);
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$2(String logPrefix$4, long lastOffset$2, RecordVersion recordVersion$2) {
        return new StringBuilder(64).append(logPrefix$4).append("Loading producer state till offset ").append(lastOffset$2).append(" with message format version ").append(recordVersion$2.value).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$4(String logPrefix$4, long lastOffset$2) {
        return new StringBuilder(75).append(logPrefix$4).append("Reloading from producer snapshot and rebuilding producer state from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ void $anonfun$rebuildProducerState$5(ProducerStateManager producerStateManager$5, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, LogSegment segment) {
        int maxPosition;
        FetchDataInfo fetchDataInfo;
        long startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager$5.mapEndOffset(), logStartOffset$1});
        producerStateManager$5.updateMapEndOffset(startOffset);
        if (offsetsToSnapshot$1.contains((Object)new Some((Object)BoxesRunTime.boxToLong((long)segment.baseOffset())))) {
            producerStateManager$5.takeSnapshot();
        }
        if ((fetchDataInfo = segment.read(startOffset, Integer.MAX_VALUE, maxPosition = segmentOfLastOffset$1.contains((Object)segment) ? BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)segment.translateOffset(lastOffset$2, segment.translateOffset$default$2())).map((Function1 & Serializable)x$45 -> BoxesRunTime.boxToInteger((int)x$45.position)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> segment.size())) : segment.size(), segment.read$default$4())) != null) {
            MODULE$.loadProducersFromRecords(producerStateManager$5, fetchDataInfo.records());
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$8(String logPrefix$4, long segmentRecoveryStart$1, long producerStateLoadStart$1, Time time$1, long lastOffset$2) {
        return new StringBuilder(90).append(logPrefix$4).append("Producer state recovery took ").append(segmentRecoveryStart$1 - producerStateLoadStart$1).append("ms for snapshot load ").append("and ").append(time$1.milliseconds() - segmentRecoveryStart$1).append("ms for segment recovery from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ String $anonfun$splitOverflowedSegment$3(String logPrefix$5, LogSegment segment$6) {
        return new StringBuilder(29).append(logPrefix$5).append("Splitting overflowed segment ").append(segment$6).toString();
    }

    public static final /* synthetic */ void $anonfun$splitOverflowedSegment$4(LogSegment segment$6, IntRef totalSizeOfNewSegments$1, LogSegment splitSegment) {
        splitSegment.onBecomeInactiveSegment();
        splitSegment.flush();
        splitSegment.lastModified_$eq(segment$6.lastModified());
        totalSizeOfNewSegments$1.elem += splitSegment.log().sizeInBytes();
    }

    public static final /* synthetic */ String $anonfun$splitOverflowedSegment$5(String logPrefix$5, LogSegment segment$6, ListBuffer newSegments$1) {
        return new StringBuilder(50).append(logPrefix$5).append("Replacing overflowed segment ").append(segment$6).append(" with split segments ").append(newSegments$1).toString();
    }

    public static final /* synthetic */ void $anonfun$splitOverflowedSegment$6(LogSegment splitSegment) {
        splitSegment.close();
        splitSegment.deleteIfExists();
    }

    private Log$() {
    }

    public static final /* synthetic */ Object $anonfun$rebuildProducerState$5$adapted(ProducerStateManager producerStateManager$5, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, LogSegment segment) {
        Log$.$anonfun$rebuildProducerState$5(producerStateManager$5, logStartOffset$1, offsetsToSnapshot$1, segmentOfLastOffset$1, lastOffset$2, segment);
        return BoxedUnit.UNIT;
    }
}

