/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaProtobufSerializer<T extends Message>
extends AbstractKafkaProtobufSerializer<T>
implements Serializer<T> {
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    private boolean isKey;
    private Map<Descriptors.Descriptor, ProtobufSchema> schemaCache;

    public KafkaProtobufSerializer() {
        this.schemaCache = new BoundedConcurrentHashMap(DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.schemaCache = new BoundedConcurrentHashMap(DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props, int cacheCapacity) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
        this.schemaCache = new BoundedConcurrentHashMap(cacheCapacity);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaProtobufSerializerConfig(configs));
    }

    public byte[] serialize(String topic, T record) {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the serializer or use serializer constructor with SchemaRegistryClient.");
        }
        if (record == null) {
            return null;
        }
        ProtobufSchema schema = this.schemaCache.get(record.getDescriptorForType());
        if (schema == null) {
            schema = ProtobufSchemaUtils.getSchema(record);
            try {
                boolean autoRegisterForDeps = this.autoRegisterSchema && !this.onlyLookupReferencesBySchema;
                boolean useLatestForDeps = this.useLatestVersion && !this.onlyLookupReferencesBySchema;
                schema = KafkaProtobufSerializer.resolveDependencies(this.schemaRegistry, this.normalizeSchema, autoRegisterForDeps, useLatestForDeps, this.latestCompatStrict, this.latestVersions, this.skipKnownTypes, this.referenceSubjectNameStrategy, topic, this.isKey, schema);
            }
            catch (InterruptedIOException e) {
                throw new TimeoutException("Error serializing Protobuf message", (Throwable)e);
            }
            catch (RestClientException | IOException e) {
                throw new SerializationException("Error serializing Protobuf message", e);
            }
            this.schemaCache.put(record.getDescriptorForType(), schema);
        }
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, (ParsedSchema)schema), topic, this.isKey, record, schema);
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing serializer", e);
        }
    }
}

