/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class RegisterBrokerRecord
implements ApiMessage {
    int brokerId;
    Uuid incarnationId;
    long brokerEpoch;
    BrokerEndpointCollection endPoints;
    BrokerFeatureCollection features;
    String rack;
    boolean fenced;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("incarnation_id", (Type)Type.UUID, "The incarnation ID of the broker process"), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), new Field("end_points", (Type)new CompactArrayOf((Type)BrokerEndpoint.SCHEMA_0), "The endpoints that can be used to communicate with this broker."), new Field("features", (Type)new CompactArrayOf((Type)BrokerFeature.SCHEMA_0), "The features on this broker"), new Field("rack", (Type)Type.COMPACT_NULLABLE_STRING, "The broker rack."), new Field("fenced", (Type)Type.BOOLEAN, "True if the broker is fenced."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RegisterBrokerRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RegisterBrokerRecord() {
        this.brokerId = 0;
        this.incarnationId = Uuid.ZERO_UUID;
        this.brokerEpoch = 0L;
        this.endPoints = new BrokerEndpointCollection(0);
        this.features = new BrokerFeatureCollection(0);
        this.rack = "";
        this.fenced = true;
    }

    public short apiKey() {
        return 0;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        int i;
        this.brokerId = _readable.readInt();
        this.incarnationId = _readable.readUuid();
        this.brokerEpoch = _readable.readLong();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field endPoints was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ImplicitLinkedHashMultiCollection newCollection = new BrokerEndpointCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((ImplicitLinkedHashCollection.Element)new BrokerEndpoint(_readable, _version));
        }
        this.endPoints = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field features was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new BrokerFeatureCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((ImplicitLinkedHashCollection.Element)new BrokerFeature(_readable, _version));
        }
        this.features = newCollection;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rack = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rack had invalid length " + length);
            }
            this.rack = _readable.readString(length);
        }
        this.fenced = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeUuid(this.incarnationId);
        _writable.writeLong(this.brokerEpoch);
        _writable.writeUnsignedVarint(this.endPoints.size() + 1);
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            BrokerEndpoint endPointsElement = (BrokerEndpoint)iterator.next();
            endPointsElement.write(_writable, _cache, _version);
        }
        _writable.writeUnsignedVarint(this.features.size() + 1);
        iterator = this.features.iterator();
        while (iterator.hasNext()) {
            BrokerFeature featuresElement = (BrokerFeature)iterator.next();
            featuresElement.write(_writable, _cache, _version);
        }
        if (this.rack == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.rack);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.fenced ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.endPoints.size() + 1)));
        Iterator<RawTaggedField> iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            BrokerEndpoint endPointsElement = (BrokerEndpoint)iterator.next();
            endPointsElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.features.size() + 1)));
        iterator = this.features.iterator();
        while (iterator.hasNext()) {
            BrokerFeature featuresElement = (BrokerFeature)iterator.next();
            featuresElement.addSize(_size, _cache, _version);
        }
        if (this.rack == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'rack' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.rack, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterBrokerRecord)) {
            return false;
        }
        RegisterBrokerRecord other = (RegisterBrokerRecord)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (!this.incarnationId.equals((Object)other.incarnationId)) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.endPoints == null ? other.endPoints != null : !this.endPoints.equals((Object)other.endPoints)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals((Object)other.features)) {
            return false;
        }
        if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
            return false;
        }
        if (this.fenced != other.fenced) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + this.incarnationId.hashCode();
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.endPoints == null ? 0 : this.endPoints.hashCode());
        hashCode = 31 * hashCode + (this.features == null ? 0 : this.features.hashCode());
        hashCode = 31 * hashCode + (this.rack == null ? 0 : this.rack.hashCode());
        hashCode = 31 * hashCode + (this.fenced ? 1231 : 1237);
        return hashCode;
    }

    public RegisterBrokerRecord duplicate() {
        RegisterBrokerRecord _duplicate = new RegisterBrokerRecord();
        _duplicate.brokerId = this.brokerId;
        _duplicate.incarnationId = this.incarnationId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        BrokerEndpointCollection newEndPoints = new BrokerEndpointCollection(this.endPoints.size());
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            BrokerEndpoint _element = (BrokerEndpoint)iterator.next();
            newEndPoints.add(_element.duplicate());
        }
        _duplicate.endPoints = newEndPoints;
        BrokerFeatureCollection newFeatures = new BrokerFeatureCollection(this.features.size());
        Iterator iterator2 = this.features.iterator();
        while (iterator2.hasNext()) {
            BrokerFeature _element = (BrokerFeature)iterator2.next();
            newFeatures.add(_element.duplicate());
        }
        _duplicate.features = newFeatures;
        _duplicate.rack = this.rack == null ? null : this.rack;
        _duplicate.fenced = this.fenced;
        return _duplicate;
    }

    public String toString() {
        return "RegisterBrokerRecord(brokerId=" + this.brokerId + ", incarnationId=" + this.incarnationId.toString() + ", brokerEpoch=" + this.brokerEpoch + ", endPoints=" + MessageUtil.deepToString((Iterator)this.endPoints.iterator()) + ", features=" + MessageUtil.deepToString((Iterator)this.features.iterator()) + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ", fenced=" + (this.fenced ? "true" : "false") + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public BrokerEndpointCollection endPoints() {
        return this.endPoints;
    }

    public BrokerFeatureCollection features() {
        return this.features;
    }

    public String rack() {
        return this.rack;
    }

    public boolean fenced() {
        return this.fenced;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RegisterBrokerRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public RegisterBrokerRecord setIncarnationId(Uuid v) {
        this.incarnationId = v;
        return this;
    }

    public RegisterBrokerRecord setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public RegisterBrokerRecord setEndPoints(BrokerEndpointCollection v) {
        this.endPoints = v;
        return this;
    }

    public RegisterBrokerRecord setFeatures(BrokerFeatureCollection v) {
        this.features = v;
        return this;
    }

    public RegisterBrokerRecord setRack(String v) {
        this.rack = v;
        return this;
    }

    public RegisterBrokerRecord setFenced(boolean v) {
        this.fenced = v;
        return this;
    }

    public static class BrokerFeatureCollection
    extends ImplicitLinkedHashMultiCollection<BrokerFeature> {
        public BrokerFeatureCollection() {
        }

        public BrokerFeatureCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public BrokerFeatureCollection(Iterator<BrokerFeature> iterator) {
            super(iterator);
        }

        public BrokerFeature find(String name) {
            BrokerFeature _key = new BrokerFeature();
            _key.setName(name);
            return (BrokerFeature)this.find(_key);
        }

        public List<BrokerFeature> findAll(String name) {
            BrokerFeature _key = new BrokerFeature();
            _key.setName(name);
            return this.findAll(_key);
        }

        public BrokerFeatureCollection duplicate() {
            BrokerFeatureCollection _duplicate = new BrokerFeatureCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BrokerFeature _element = (BrokerFeature)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class BrokerFeature
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short minSupportedVersion;
        short maxSupportedVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The feature name."), new Field("min_supported_version", (Type)Type.INT16, "The minimum supported feature level."), new Field("max_supported_version", (Type)Type.INT16, "The maximum supported feature level."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerFeature(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public BrokerFeature() {
            this.name = "";
            this.minSupportedVersion = 0;
            this.maxSupportedVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerFeature");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minSupportedVersion = _readable.readShort();
            this.maxSupportedVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minSupportedVersion);
            _writable.writeShort(this.maxSupportedVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerFeature");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof BrokerFeature)) {
                return false;
            }
            BrokerFeature other = (BrokerFeature)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerFeature)) {
                return false;
            }
            BrokerFeature other = (BrokerFeature)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minSupportedVersion != other.minSupportedVersion) {
                return false;
            }
            if (this.maxSupportedVersion != other.maxSupportedVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public BrokerFeature duplicate() {
            BrokerFeature _duplicate = new BrokerFeature();
            _duplicate.name = this.name;
            _duplicate.minSupportedVersion = this.minSupportedVersion;
            _duplicate.maxSupportedVersion = this.maxSupportedVersion;
            return _duplicate;
        }

        public String toString() {
            return "BrokerFeature(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minSupportedVersion=" + this.minSupportedVersion + ", maxSupportedVersion=" + this.maxSupportedVersion + ")";
        }

        public String name() {
            return this.name;
        }

        public short minSupportedVersion() {
            return this.minSupportedVersion;
        }

        public short maxSupportedVersion() {
            return this.maxSupportedVersion;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerFeature setName(String v) {
            this.name = v;
            return this;
        }

        public BrokerFeature setMinSupportedVersion(short v) {
            this.minSupportedVersion = v;
            return this;
        }

        public BrokerFeature setMaxSupportedVersion(short v) {
            this.maxSupportedVersion = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class BrokerEndpointCollection
    extends ImplicitLinkedHashMultiCollection<BrokerEndpoint> {
        public BrokerEndpointCollection() {
        }

        public BrokerEndpointCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public BrokerEndpointCollection(Iterator<BrokerEndpoint> iterator) {
            super(iterator);
        }

        public BrokerEndpoint find(String name) {
            BrokerEndpoint _key = new BrokerEndpoint();
            _key.setName(name);
            return (BrokerEndpoint)this.find(_key);
        }

        public List<BrokerEndpoint> findAll(String name) {
            BrokerEndpoint _key = new BrokerEndpoint();
            _key.setName(name);
            return this.findAll(_key);
        }

        public BrokerEndpointCollection duplicate() {
            BrokerEndpointCollection _duplicate = new BrokerEndpointCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BrokerEndpoint _element = (BrokerEndpoint)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class BrokerEndpoint
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        short securityProtocol;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the endpoint."), new Field("host", (Type)Type.COMPACT_STRING, "The hostname."), new Field("port", (Type)Type.UINT16, "The port."), new Field("security_protocol", (Type)Type.INT16, "The security protocol."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerEndpoint(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public BrokerEndpoint() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.securityProtocol = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerEndpoint");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this.securityProtocol = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            _writable.writeShort(this.securityProtocol);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerEndpoint");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof BrokerEndpoint)) {
                return false;
            }
            BrokerEndpoint other = (BrokerEndpoint)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerEndpoint)) {
                return false;
            }
            BrokerEndpoint other = (BrokerEndpoint)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.securityProtocol != other.securityProtocol) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public BrokerEndpoint duplicate() {
            BrokerEndpoint _duplicate = new BrokerEndpoint();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.securityProtocol = this.securityProtocol;
            return _duplicate;
        }

        public String toString() {
            return "BrokerEndpoint(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", securityProtocol=" + this.securityProtocol + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerEndpoint setName(String v) {
            this.name = v;
            return this;
        }

        public BrokerEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public BrokerEndpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        public BrokerEndpoint setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

