/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class MetadataImage {
    public static final MetadataImage EMPTY = new MetadataImage(FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY);
    private final FeaturesImage features;
    private final ClusterImage cluster;
    private final TopicsImage topics;
    private final ConfigurationsImage configs;
    private final ClientQuotasImage clientQuotas;

    public MetadataImage(FeaturesImage features, ClusterImage cluster, TopicsImage topics, ConfigurationsImage configs, ClientQuotasImage clientQuotas) {
        this.features = features;
        this.cluster = cluster;
        this.topics = topics;
        this.configs = configs;
        this.clientQuotas = clientQuotas;
    }

    public boolean isEmpty() {
        return this.features.isEmpty() && this.cluster.isEmpty() && this.topics.isEmpty() && this.configs.isEmpty() && this.clientQuotas.isEmpty();
    }

    public FeaturesImage features() {
        return this.features;
    }

    public ClusterImage cluster() {
        return this.cluster;
    }

    public TopicsImage topics() {
        return this.topics;
    }

    public ConfigurationsImage configs() {
        return this.configs;
    }

    public ClientQuotasImage clientQuotas() {
        return this.clientQuotas;
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        this.features.write(out);
        this.cluster.write(out);
        this.topics.write(out);
        this.configs.write(out);
        this.clientQuotas.write(out);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetadataImage)) {
            return false;
        }
        MetadataImage other = (MetadataImage)o;
        return this.features.equals(other.features) && this.cluster.equals(other.cluster) && this.topics.equals(other.topics) && this.configs.equals(other.configs) && this.clientQuotas.equals(other.clientQuotas);
    }

    public int hashCode() {
        return Objects.hash(this.features, this.cluster, this.topics, this.configs, this.clientQuotas);
    }

    public String toString() {
        return "MetadataImage(features=" + this.features + ", cluster=" + this.cluster + ", topics=" + this.topics + ", configs=" + this.configs + ", clientQuotas=" + this.clientQuotas + ")";
    }
}

