/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.backends.kafka;

import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.extension.KafkaRestContextProvider;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.Producer;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;

public final class KafkaModule
extends AbstractBinder {
    protected void configure() {
        this.bindFactory(KafkaRestContextFactory.class).to(KafkaRestContext.class).in(RequestScoped.class);
        this.bindFactory(AdminFactory.class).to(Admin.class).in(RequestScoped.class);
        this.bindFactory(ProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(RequestScoped.class);
    }

    private static final class ProducerFactory
    implements Factory<Producer<?, ?>> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private ProducerFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Producer<byte[], byte[]> provide() {
            return ((KafkaRestContext)this.context.get()).getProducer();
        }

        public void dispose(Producer<?, ?> producer) {
        }
    }

    private static final class AdminFactory
    implements Factory<Admin> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private AdminFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Admin provide() {
            return ((KafkaRestContext)this.context.get()).getAdmin();
        }

        public void dispose(Admin instance) {
        }
    }

    private static final class KafkaRestContextFactory
    implements Factory<KafkaRestContext> {
        private KafkaRestContextFactory() {
        }

        public KafkaRestContext provide() {
            return KafkaRestContextProvider.getCurrentContext();
        }

        public void dispose(KafkaRestContext instance) {
        }
    }
}

