/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.ConsumerAssignmentManager;
import io.confluent.kafkarest.controllers.ConsumerManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.ConsumerAssignment;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;

final class ConsumerAssignmentManagerImpl
implements ConsumerAssignmentManager {
    private final ConsumerManager consumerManager;

    @Inject
    ConsumerAssignmentManagerImpl(ConsumerManager consumerManager) {
        this.consumerManager = Objects.requireNonNull(consumerManager);
    }

    @Override
    public CompletableFuture<List<ConsumerAssignment>> listConsumerAssignments(String clusterId, String consumerGroupId, String consumerId) {
        return ((CompletableFuture)this.consumerManager.getConsumer(clusterId, consumerGroupId, consumerId).thenApply(consumer -> (Consumer)Entities.checkEntityExists(consumer, "Consumer %s does not exist.", consumerId))).thenApply(consumer -> consumer.getAssignedPartitions().stream().map(partition -> ConsumerAssignment.builder().setClusterId(clusterId).setConsumerGroupId(consumerGroupId).setConsumerId(consumerId).setTopicName(partition.getTopicName()).setPartitionId(partition.getPartitionId()).build()).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Optional<ConsumerAssignment>> getConsumerAssignment(String clusterId, String consumerGroupId, String consumerId, String topicName, int partitionId) {
        return this.listConsumerAssignments(clusterId, consumerGroupId, consumerId).thenApply(assignments -> assignments.stream().filter(assignment -> assignment.getTopicName().equals(topicName)).filter(assignment -> assignment.getPartitionId() == partitionId).findAny());
    }
}

