/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.TopicConfigManager;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.TopicConfig;
import io.confluent.kafkarest.entities.v3.GetTopicConfigResponse;
import io.confluent.kafkarest.entities.v3.ListTopicConfigsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.TopicConfigData;
import io.confluent.kafkarest.entities.v3.TopicConfigDataList;
import io.confluent.kafkarest.entities.v3.UpdateTopicConfigRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/configs")
@ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.*")
public final class TopicConfigsResource {
    private final Provider<TopicConfigManager> topicConfigManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public TopicConfigsResource(Provider<TopicConfigManager> topicConfigManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.topicConfigManager = Objects.requireNonNull(topicConfigManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.configs.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.list")
    public void listTopicConfigs(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletionStage response = ((TopicConfigManager)this.topicConfigManager.get()).listTopicConfigs(clusterId, topicName).thenApply(configs -> ListTopicConfigsResponse.create((TopicConfigDataList)((TopicConfigDataList.Builder)((TopicConfigDataList.Builder)TopicConfigDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "topics", topicName, "configs")).build())).setData(configs.stream().sorted(Comparator.comparing(AbstractConfig::getName)).map(topicConfig -> TopicConfigsResource.toTopicConfigData(topicConfig, this.crnFactory, this.urlFactory)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.configs.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.get")
    public void getTopicConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="name") String name) {
        CompletionStage response = ((CompletableFuture)((TopicConfigManager)this.topicConfigManager.get()).getTopicConfig(clusterId, topicName, name).thenApply(topic -> (TopicConfig)topic.orElseThrow(NotFoundException::new))).thenApply(topic -> GetTopicConfigResponse.create(TopicConfigsResource.toTopicConfigData(topic, this.crnFactory, this.urlFactory)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @PUT
    @Path(value="/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.configs.update")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.update")
    public void updateTopicConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="name") String name, @Valid UpdateTopicConfigRequest request) {
        String newValue = request.getValue().orElse(null);
        CompletableFuture<Void> response = ((TopicConfigManager)this.topicConfigManager.get()).updateTopicConfig(clusterId, topicName, name, newValue);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    @DELETE
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.configs.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.delete")
    public void resetTopicConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="name") String name) {
        CompletableFuture<Void> response = ((TopicConfigManager)this.topicConfigManager.get()).resetTopicConfig(clusterId, topicName, name);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    public static TopicConfigData toTopicConfigData(TopicConfig topicConfig, CrnFactory crnFactory, UrlFactory urlFactory) {
        return ((TopicConfigData.Builder)TopicConfigData.fromTopicConfig(topicConfig).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create("v3", "clusters", topicConfig.getClusterId(), "topics", topicConfig.getTopicName(), "configs", topicConfig.getName())).setResourceName(crnFactory.create("kafka", topicConfig.getClusterId(), "topic", topicConfig.getTopicName(), "config", topicConfig.getName())).build())).build();
    }
}

