/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.Log$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.utils.KafkaScheduler;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.timer.SystemTimer;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\tEw!B\u001a5\u0011\u0003Id!B\u001e5\u0011\u0003a\u0004\"B\"\u0002\t\u0003!e\u0001B#\u0002\u0001\u0019C\u0001\"T\u0002\u0003\u0002\u0003\u0006IA\u0014\u0005\tI\u000e\u0011\t\u0011)A\u0005K\")1i\u0001C\u0001a\")\u0011p\u0001C!u\")ap\u0001C!\u007f\"9\u0011qA\u0002\u0005B\u0005%\u0001bBA\u0006\u0003\u0011%\u0011Q\u0002\u0004\u0006wQ\u0002\u0011q\u0005\u0005\u000b\u0003{Y!\u0011!Q\u0001\n\u0005}\u0002BCA&\u0017\t\u0005\t\u0015!\u0003\u0002N!Q\u00111K\u0006\u0003\u0002\u0003\u0006I!!\u0016\t\u0015\u0005\u001d4B!A!\u0002\u0013\tI\u0007\u0003\u0006\u0002t-\u0011\t\u0011)A\u0005\u0003kB!\"a\u001f\f\u0005\u0003\u0005\u000b\u0011BA?\u0011)\t9i\u0003B\u0001B\u0003%\u0011\u0011\u0012\u0005\u000b\u0003'[!\u0011!Q\u0001\n\u0005U\u0005BCAN\u0017\t\u0015\r\u0011\"\u0001\u0002\u001e\"Q\u0011\u0011]\u0006\u0003\u0002\u0003\u0006I!a(\t\r\r[A\u0011AAr\u0011%\tIp\u0003b\u0001\n\u0013\tY\u0010\u0003\u0005\u0003\u0004-\u0001\u000b\u0011BA\u007f\u0011!!7B1A\u0005\n\t\u0015\u0001b\u0002B\u0004\u0017\u0001\u0006I!\u001a\u0005\n\u0005\u0013Y!\u0019!C\u0005\u0005\u0017A\u0001Ba\u0005\fA\u0003%!Q\u0002\u0005\n\u0005+Y!\u0019!C\u0005\u0005/A\u0001Ba\b\fA\u0003%!\u0011\u0004\u0005\n\u0005CY!\u0019!C\u0005\u0005GA\u0001B!\n\fA\u0003%\u0011q\u0002\u0005\n\u0005OY!\u0019!C!\u0005SA\u0001B!\r\fA\u0003%!1\u0006\u0005\n\u0005gY!\u0019!C\u0005\u0005kA\u0001B!\u0010\fA\u0003%!q\u0007\u0005\t\u001b.\u0011\r\u0011\"\u0011\u0003@!A!1I\u0006!\u0002\u0013\u0011\t\u0005C\u0005\u0003F-\u0011\r\u0011\"\u0003\u0003H!A!QK\u0006!\u0002\u0013\u0011I\u0005\u0003\u0004\u0003X-!\tA\u001f\u0005\u0007\u00053ZA\u0011\u0001>\t\u000f\tm3\u0002\"\u0011\u0003^!9!\u0011O\u0006\u0005B\tM\u0004b\u0002BQ\u0017\u0011%!1\u0015\u0005\b\u0005K[A\u0011\u0002BT\u0011\u001d\u0011Ik\u0003C\u0005\u0005WCqA!,\f\t\u0013\u0011y\u000bC\u0004\u00038.!IA!/\t\u000f\t\u001d7\u0002\"\u0011\u0003J\u0006\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\u0006\u0003kY\nAA]1gi*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005i\nQ\"\u0001\u001b\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u00148CA\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000f\u0002\r%\u00064G/S8UQJ,\u0017\rZ\n\u0003\u0007\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u001c\u0002\u000bU$\u0018\u000e\\:\n\u00051K%AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\faa\u00197jK:$\bGA(\\!\r\u0001v+W\u0007\u0002#*\u0011QG\u0015\u0006\u0003oMS!\u0001V+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0016aA8sO&\u0011\u0001,\u0015\u0002\u0010\u0017\u000647.\u0019*bMR\u001cE.[3oiB\u0011!l\u0017\u0007\u0001\t%aF!!A\u0001\u0002\u000b\u0005QLA\u0002`IE\n\"AX1\u0011\u0005yz\u0016B\u00011@\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u00102\n\u0005\r|$aA!os\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0003M6t!aZ6\u0011\u0005!|T\"A5\u000b\u0005)D\u0014A\u0002\u001fs_>$h(\u0003\u0002m\u007f\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\taw\bF\u0002rgb\u0004\"A]\u0002\u000e\u0003\u0005AQ!\u0014\u0004A\u0002Q\u0004$!^<\u0011\u0007A;f\u000f\u0005\u0002[o\u0012IAl]A\u0001\u0002\u0003\u0015\t!\u0018\u0005\u0006I\u001a\u0001\r!Z\u0001\u0007I><vN]6\u0015\u0003m\u0004\"A\u0010?\n\u0005u|$\u0001B+oSR\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005\u0005\u0001c\u0001 \u0002\u0004%\u0019\u0011QA \u0003\u000f\t{w\u000e\\3b]\u0006I\u0011n\u001d*v]:LgnZ\u000b\u0003\u0003\u0003\t!c\u0019:fCR,Gj\\4ESJ,7\r^8ssR1\u0011qBA\u0010\u0003G\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0002j_*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!\u0001\u0002$jY\u0016Dq!!\t\u000b\u0001\u0004\ty!\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u0007\u0003KQ\u0001\u0019A3\u0002\u00151|w\rR5s\u001d\u0006lW-\u0006\u0003\u0002*\u0005M2CB\u0006>\u0003W\t9\u0004E\u0003;\u0003[\t\t$C\u0002\u00020Q\u00121BU1gi6\u000bg.Y4feB\u0019!,a\r\u0005\r\u0005U2B1\u0001^\u0005\u0005!\u0006c\u0001%\u0002:%\u0019\u00111H%\u0003\u000f1{wmZ5oO\u0006qQ.\u001a;b!J|\u0007/\u001a:uS\u0016\u001c\b\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015c'\u0001\u0004tKJ4XM]\u0005\u0005\u0003\u0013\n\u0019E\u0001\bNKR\f\u0007K]8qKJ$\u0018.Z:\u0002\r\r|gNZ5h!\u0011\t\t%a\u0014\n\t\u0005E\u00131\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|'\u000fZ*fe\u0012,\u0007CBA,\u0003G\n\t$\u0004\u0002\u0002Z)!\u00111LA/\u00035\u0019XM]5bY&T\u0018\r^5p]*!\u0011qLA1\u0003\u0019\u0019w.\\7p]*\u0019\u0011Q\t*\n\t\u0005\u0015\u0014\u0011\f\u0002\f%\u0016\u001cwN\u001d3TKJ$W-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005-\u0014qN\u0007\u0003\u0003[R1!a\u0018S\u0013\u0011\t\t(!\u001c\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069Ao\u001c9jG&#\u0007\u0003BA6\u0003oJA!!\u001f\u0002n\t!Q+^5e\u0003\u0011!\u0018.\\3\u0011\t\u0005}\u00141Q\u0007\u0003\u0003\u0003S1ASA7\u0013\u0011\t))!!\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\tY)a$\u000e\u0005\u00055%\u0002BAD\u0003[JA!!%\u0002\u000e\n9Q*\u001a;sS\u000e\u001c\u0018a\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y\u001fB$\b\u0003\u0002 \u0002\u0018\u0016L1!!'@\u0005\u0019y\u0005\u000f^5p]\u0006a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAAP!\u0019\t\t+a+\u000206\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0006d_:\u001cWO\u001d:f]RTA!!+\u0002\u0018\u0005!Q\u000f^5m\u0013\u0011\ti+a)\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u00022\u0006M\u0016qWAb\u001b\t\t9+\u0003\u0003\u00026\u0006\u001d&aA'baB!\u0011\u0011XA`\u001b\t\tYL\u0003\u0003\u0002>\u0006]\u0011\u0001\u00027b]\u001eLA!!1\u0002<\n9\u0011J\u001c;fO\u0016\u0014\b\u0003BAc\u00037tA!a2\u0002X:!\u0011\u0011ZAk\u001d\u0011\tY-a5\u000f\t\u00055\u0017\u0011\u001b\b\u0004Q\u0006=\u0017\"\u0001,\n\u0005Q+\u0016BA\u001cT\u0013\t)$+C\u0002\u0002ZF\u000b!BU1gi\u000e{gNZ5h\u0013\u0011\ti.a8\u0003\u0017\u0005#GM]3tgN\u0003Xm\u0019\u0006\u0004\u00033\f\u0016!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0015)\u0005\u0015\u0018q]Au\u0003W\fi/a<\u0002r\u0006M\u0018Q_A|!\u0011Q4\"!\r\t\u000f\u0005ub\u00031\u0001\u0002@!9\u00111\n\fA\u0002\u00055\u0003bBA*-\u0001\u0007\u0011Q\u000b\u0005\b\u0003O2\u0002\u0019AA5\u0011\u001d\t\u0019H\u0006a\u0001\u0003kBq!a\u001f\u0017\u0001\u0004\ti\bC\u0004\u0002\bZ\u0001\r!!#\t\u000f\u0005Me\u00031\u0001\u0002\u0016\"9\u00111\u0014\fA\u0002\u0005}\u0015A\u0003:bMR\u001cuN\u001c4jOV\u0011\u0011Q \t\u0004!\u0006}\u0018b\u0001B\u0001#\nQ!+\u00194u\u0007>tg-[4\u0002\u0017I\fg\r^\"p]\u001aLw\rI\u000b\u0002K\u0006\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0003\u000eA!\u0011q\u0010B\b\u0013\u0011\u0011\t\"!!\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\u0011I\u0002E\u0002I\u00057I1A!\bJ\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u001d!\u0017\r^1ESJ,\"!a\u0004\u0002\u0011\u0011\fG/\u0019#je\u0002\nQB]3qY&\u001c\u0017\r^3e\u0019><WC\u0001B\u0016!\r\u0001&QF\u0005\u0004\u0005_\t&!\u0004*fa2L7-\u0019;fI2{w-\u0001\bsKBd\u0017nY1uK\u0012dun\u001a\u0011\u0002\u00159,Go\u00115b]:,G.\u0006\u0002\u00038A\u0019!H!\u000f\n\u0007\tmBGA\nLC\u001a\\\u0017MT3uo>\u00148n\u00115b]:,G.A\u0006oKR\u001c\u0005.\u00198oK2\u0004SC\u0001B!!\u0011\u0001v+!\r\u0002\u000f\rd\u0017.\u001a8uA\u0005a!/\u00194u\u0013>$\u0006N]3bIV\u0011!\u0011\n\t\u0004\u0005\u0017\u001aab\u0001B'\u00019!!q\nB*\u001d\rA'\u0011K\u0005\u0002o%\u0011QGN\u0001\u000ee\u00064G/S8UQJ,\u0017\r\u001a\u0011\u0002\u000fM$\u0018M\u001d;va\u0006A1\u000f[;uI><h.\u0001\u0005sK\u001eL7\u000f^3s)\rY(q\f\u0005\b\u0005CZ\u0003\u0019\u0001B2\u0003!a\u0017n\u001d;f]\u0016\u0014\bC\u0002B3\u0005W\n\tDD\u0002Q\u0005OJ1A!\u001bR\u0003)\u0011\u0016M\u001a;DY&,g\u000e^\u0005\u0005\u0005[\u0012yG\u0001\u0005MSN$XM\\3s\u0015\r\u0011I'U\u0001\u000eQ\u0006tG\r\\3SKF,Xm\u001d;\u0015\u0011\tU$1\u0011BJ\u0005/\u0003b!!)\u0002,\n]\u0004\u0003\u0002B=\u0005\u007fj!Aa\u001f\u000b\t\tu\u0014QN\u0001\taJ|Go\\2pY&!!\u0011\u0011B>\u0005)\t\u0005/['fgN\fw-\u001a\u0005\b\u0005\u000bc\u0003\u0019\u0001BD\u0003\u0019AW-\u00193feB!!\u0011\u0012BH\u001b\t\u0011YI\u0003\u0003\u0003\u000e\u00065\u0014\u0001\u0003:fcV,7\u000f^:\n\t\tE%1\u0012\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\tUE\u00061\u0001\u0003x\u00059!/Z9vKN$\bb\u0002BMY\u0001\u0007!1T\u0001\u000eGJ,\u0017\r^3e)&lW-T:\u0011\u0007y\u0012i*C\u0002\u0003 ~\u0012A\u0001T8oO\u0006y!-^5mIJ\u000bg\r^\"mS\u0016tG\u000f\u0006\u0002\u0003B\u0005\u0019\"-^5mI:+Go^8sW\u000eC\u0017M\u001c8fYR\u0011!qG\u0001\u000eGJ,\u0017\r^3ECR\fG)\u001b:\u0015\u0005\u0005=\u0011\u0001\u00052vS2$W*\u001a;bI\u0006$\u0018\rT8h)\t\u0011\t\fE\u0002;\u0005gK1A!.5\u0005AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w-\u0001\nck&dGMT3uo>\u00148n\u00117jK:$HC\u0001B^!\u0011\u0011iLa1\u000e\u0005\t}&b\u0001Ba%\u000691\r\\5f]R\u001c\u0018\u0002\u0002Bc\u0005\u007f\u0013QBT3uo>\u00148n\u00117jK:$\u0018A\u00047fC\u0012,'/\u00118e\u000bB|7\r[\u000b\u0003\u0005\u0017\u00042\u0001\u0015Bg\u0013\r\u0011y-\u0015\u0002\u000f\u0019\u0016\fG-\u001a:B]\u0012,\u0005o\\2i\u0001")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        CollectionConverters$.MODULE$.SetHasAsScala(voterAddresses.entrySet()).asScala().foreach((Function1 & Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        this.raftIoThread().shutdown();
        this.client().close();
        this.scheduler().shutdown();
        this.netChannel().close();
        this.replicatedLog().close();
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private KafkaRaftClient<T> buildRaftClient() {
        SystemTimer expirationTimer = new SystemTimer("raft-expiration-executor", 1L, 20, Time.SYSTEM.hiResClockMs());
        TimingWheelExpirationService expirationService = new TimingWheelExpirationService(expirationTimer);
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = this.config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? OptionalInt.of(this.config.nodeId()) : OptionalInt.empty();
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)expirationService, this.logContext(), this.metaProperties.clusterId(), nodeId, this.raftConfig());
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = Log$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.listenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, new ApiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
                return;
            }
            return;
        }
        if (addressSpec != null) {
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn(new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(22).append("[RaftManager nodeId=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), true);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix());
    }

    public static class RaftIoThread
    extends ShutdownableThread {
        private final KafkaRaftClient<?> client;

        @Override
        public void doWork() {
            this.client.poll();
        }

        @Override
        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix) {
            this.client = client;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
        }
    }
}

