/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.AclApis;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.AuthHelper;
import kafka.server.EnvelopeUtils$;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.server.RequestLocal;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\u0015f\u0001B\u001f?\u0001\rC\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005-\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003`\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0013}\u0004!Q1A\u0005\u0002\u0005\u0005\u0001BCA\t\u0001\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u00111\u0003\u0001\u0003\u0006\u0004%\t!!\u0006\t\u0015\u0005e\u0002A!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002<\u0001\u0011)\u0019!C\u0001\u0003{A!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA \u0011)\tY\u0005\u0001BC\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003K\u0002!\u0011!Q\u0001\n\u0005=\u0003BCA4\u0001\t\u0015\r\u0011\"\u0001\u0002j!Q\u0011\u0011\u000f\u0001\u0003\u0002\u0003\u0006I!a\u001b\t\u0015\u0005M\u0004A!b\u0001\n\u0003\t)\b\u0003\u0006\u0002~\u0001\u0011\t\u0011)A\u0005\u0003oB!\"a \u0001\u0005\u000b\u0007I\u0011AAA\u0011)\ti\n\u0001B\u0001B\u0003%\u00111\u0011\u0005\u000b\u0003?\u0003!Q1A\u0005\u0002\u0005\u0005\u0006BCAU\u0001\t\u0005\t\u0015!\u0003\u0002$\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006\"CAd\u0001\t\u0007I\u0011AAe\u0011!\t\t\u000e\u0001Q\u0001\n\u0005-\u0007\"CAj\u0001\t\u0007I\u0011AAk\u0011!\ti\u000e\u0001Q\u0001\n\u0005]\u0007\"CAp\u0001\t\u0007I\u0011BAq\u0011!\tI\u000f\u0001Q\u0001\n\u0005\r\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0003k\u0004A\u0011AA|\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqAa\b\u0001\t\u0003\u0011\t\u0003C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\t5\u0002\u0001\"\u0001\u00030!9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B\u001d\u0001\u0011\u0005!1\b\u0005\b\u0005\u007f\u0001A\u0011\u0001B!\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqA!0\u0001\t\u0003\u0011y\fC\u0004\u0003D\u0002!\tA!2\t\u000f\tu\u0007\u0001\"\u0001\u0003`\"9!1\u001d\u0001\u0005\u0002\t\u0015\bbBB\u0006\u0001\u0011\u00051Q\u0002\u0005\b\u0007#\u0001A\u0011AB\n\u0011\u001d\u00199\u0002\u0001C\u0001\u00073Aqa!\b\u0001\t\u0003\u0019y\u0002C\u0004\u0004$\u0001!\ta!\n\t\u000f\r%\u0002\u0001\"\u0001\u0004,!91q\u0006\u0001\u0005\u0002\rE\u0002bBB\u001b\u0001\u0011\u00051q\u0007\u0005\b\u0007w\u0001A\u0011AB\u001f\u0011\u001d\u0019\t\u0005\u0001C\u0005\u0007\u0007Bqaa\u0018\u0001\t\u0003\u0019\t\u0007C\u0004\u0004f\u0001!\taa\u001a\t\u000f\r-\u0004\u0001\"\u0001\u0004n!91\u0011\u000f\u0001\u0005\u0002\rM\u0004bBBJ\u0001\u0011\u00051Q\u0013\u0005\b\u00073\u0003A\u0011ABN\u0011\u001d\u0019y\n\u0001C\u0001\u0007C\u0013abQ8oiJ|G\u000e\\3s\u0003BL7O\u0003\u0002@\u0001\u000611/\u001a:wKJT\u0011!Q\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001AI\u0013(\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r\u0005s\u0017PU3g!\tYE*D\u0001?\u0013\tieHA\tBa&\u0014V-];fgRD\u0015M\u001c3mKJ\u0004\"a\u0014*\u000e\u0003AS!!\u0015!\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0003&a\u0002'pO\u001eLgnZ\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\u00051\u0006CA,[\u001b\u0005A&BA-A\u0003\u001dqW\r^<pe.L!a\u0017-\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0006bkRDwN]5{KJ,\u0012a\u0018\t\u0004\u000b\u0002\u0014\u0017BA1G\u0005\u0019y\u0005\u000f^5p]B\u00111m[\u0007\u0002I*\u0011Q,\u001a\u0006\u0003\u007f\u0019T!!Q4\u000b\u0005!L\u0017AB1qC\u000eDWMC\u0001k\u0003\ry'oZ\u0005\u0003Y\u0012\u0014!\"Q;uQ>\u0014\u0018N_3s\u0003-\tW\u000f\u001e5pe&TXM\u001d\u0011\u0002\rE,x\u000e^1t+\u0005\u0001\bCA9|\u001d\t\u0011\u0018P\u0004\u0002tq:\u0011Ao^\u0007\u0002k*\u0011aOQ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005K!a\u0010!\n\u0005it\u0014\u0001D)v_R\fg)Y2u_JL\u0018B\u0001?~\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011!PP\u0001\bcV|G/Y:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001bi!!a\u0002\u000b\u0007E\u000bIAC\u0002\u0002\f\u0019\faaY8n[>t\u0017\u0002BA\b\u0003\u000f\u0011A\u0001V5nK\u0006)A/[7fA\u0005\t2/\u001e9q_J$X\r\u001a$fCR,(/Z:\u0016\u0005\u0005]\u0001\u0003CA\r\u0003C\t9#!\f\u000f\t\u0005m\u0011Q\u0004\t\u0003i\u001aK1!a\bG\u0003\u0019\u0001&/\u001a3fM&!\u00111EA\u0013\u0005\ri\u0015\r\u001d\u0006\u0004\u0003?1\u0005\u0003BA\r\u0003SIA!a\u000b\u0002&\t11\u000b\u001e:j]\u001e\u0004B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g1\u0017\u0001C7fi\u0006$\u0017\r^1\n\t\u0005]\u0012\u0011\u0007\u0002\r-\u0016\u00148/[8o%\u0006tw-Z\u0001\u0013gV\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001c\b%\u0001\u0006d_:$(o\u001c7mKJ,\"!a\u0010\u0011\t\u0005\u0005\u0013QI\u0007\u0003\u0003\u0007R1!a\u000fg\u0013\u0011\t9%a\u0011\u0003\u0015\r{g\u000e\u001e:pY2,'/A\u0006d_:$(o\u001c7mKJ\u0004\u0013a\u0003:bMRl\u0015M\\1hKJ,\"!a\u0014\u0011\r\u0005E\u0013qKA.\u001b\t\t\u0019FC\u0002\u0002V\u0001\u000bAA]1gi&!\u0011\u0011LA*\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\t\u0005u\u0013\u0011M\u0007\u0003\u0003?R1!a\u0003f\u0013\u0011\t\u0019'a\u0018\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u00031\u0011\u0018M\u001a;NC:\fw-\u001a:!\u0003\u0019\u0019wN\u001c4jOV\u0011\u00111\u000e\t\u0004\u0017\u00065\u0014bAA8}\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\na\"\\3uCB\u0013x\u000e]3si&,7/\u0006\u0002\u0002xA\u00191*!\u001f\n\u0007\u0005mdH\u0001\bNKR\f\u0007K]8qKJ$\u0018.Z:\u0002\u001f5,G/\u0019)s_B,'\u000f^5fg\u0002\nqbY8oiJ|G\u000e\\3s\u001d>$Wm]\u000b\u0003\u0003\u0007\u0003b!!\"\u0002\u0010\u0006Ue\u0002BAD\u0003\u0017s1\u0001^AE\u0013\u00059\u0015bAAG\r\u00069\u0001/Y2lC\u001e,\u0017\u0002BAI\u0003'\u00131aU3r\u0015\r\tiI\u0012\t\u0005\u0003/\u000bI*\u0004\u0002\u0002\n%!\u00111TA\u0005\u0005\u0011qu\u000eZ3\u0002!\r|g\u000e\u001e:pY2,'OT8eKN\u0004\u0013!E1qSZ+'o]5p]6\u000bg.Y4feV\u0011\u00111\u0015\t\u0004\u0017\u0006\u0015\u0016bAAT}\t\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002%\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005=\u0016\u0011WAZ\u0003k\u000b9,!/\u0002<\u0006u\u0016qXAa\u0003\u0007\f)\r\u0005\u0002L\u0001!)Ak\u0006a\u0001-\")Ql\u0006a\u0001?\")an\u0006a\u0001a\"1qp\u0006a\u0001\u0003\u0007Aq!a\u0005\u0018\u0001\u0004\t9\u0002C\u0004\u0002<]\u0001\r!a\u0010\t\u000f\u0005-s\u00031\u0001\u0002P!9\u0011qM\fA\u0002\u0005-\u0004bBA:/\u0001\u0007\u0011q\u000f\u0005\b\u0003\u007f:\u0002\u0019AAB\u0011\u001d\tyj\u0006a\u0001\u0003G\u000b!\"Y;uQ\"+G\u000e]3s+\t\tY\rE\u0002L\u0003\u001bL1!a4?\u0005)\tU\u000f\u001e5IK2\u0004XM]\u0001\fCV$\b\u000eS3ma\u0016\u0014\b%A\u0007sKF,Xm\u001d;IK2\u0004XM]\u000b\u0003\u0003/\u00042aSAm\u0013\r\tYN\u0010\u0002\u0015%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0011\u0016d\u0007/\u001a:\u0002\u001dI,\u0017/^3ti\"+G\u000e]3sA\u00059\u0011m\u00197Ba&\u001cXCAAr!\rY\u0015Q]\u0005\u0004\u0003Ot$aB!dY\u0006\u0003\u0018n]\u0001\tC\u000ed\u0017\t]5tA\u0005A\u0011n]\"m_N,G-\u0006\u0002\u0002pB\u0019Q)!=\n\u0007\u0005MhIA\u0004C_>dW-\u00198\u0002\u000b\rdwn]3\u0015\u0005\u0005e\bcA#\u0002|&\u0019\u0011Q $\u0003\tUs\u0017\u000e^\u0001\u0007Q\u0006tG\r\\3\u0015\r\u0005e(1\u0001B\u000b\u0011\u001d\u0011)\u0001\ta\u0001\u0005\u000f\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003\n\t=abA,\u0003\f%\u0019!Q\u0002-\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!!\u0011\u0003B\n\u0005\u001d\u0011V-];fgRT1A!\u0004Y\u0011\u001d\u00119\u0002\ta\u0001\u00053\tAB]3rk\u0016\u001cH\u000fT8dC2\u00042a\u0013B\u000e\u0013\r\u0011iB\u0010\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u0016Q\u0006tG\r\\3F]Z,Gn\u001c9f%\u0016\fX/Z:u)\u0019\tIPa\t\u0003&!9!QA\u0011A\u0002\t\u001d\u0001b\u0002B\fC\u0001\u0007!\u0011D\u0001\u001bQ\u0006tG\r\\3TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003s\u0014Y\u0003C\u0004\u0003\u0006\t\u0002\rAa\u0002\u0002;!\fg\u000e\u001a7f'\u0006\u001cH.Q;uQ\u0016tG/[2bi\u0016\u0014V-];fgR$B!!?\u00032!9!QA\u0012A\u0002\t\u001d\u0011a\u00035b]\u0012dWMR3uG\"$B!!?\u00038!9!Q\u0001\u0013A\u0002\t\u001d\u0011a\u00055b]\u0012dWMR3uG\"\u001cf.\u00199tQ>$H\u0003BA}\u0005{AqA!\u0002&\u0001\u0004\u00119!\u0001\niC:$G.\u001a#fY\u0016$X\rV8qS\u000e\u001cH\u0003BA}\u0005\u0007BqA!\u0002'\u0001\u0004\u00119!\u0001\u0007eK2,G/\u001a+pa&\u001c7\u000f\u0006\u0007\u0003J\t-%Q\u0013BP\u0005G\u0013I\f\u0005\u0004\u0003L\te#QL\u0007\u0003\u0005\u001bRAAa\u0014\u0003R\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\tM#QK\u0001\u0005kRLGN\u0003\u0002\u0003X\u0005!!.\u0019<b\u0013\u0011\u0011YF!\u0014\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0004\u0003`\t\u0005$QM\u0007\u0003\u0005#JAAa\u0019\u0003R\t!A*[:u!\u0011\u00119G!\"\u000f\t\t%$q\u0010\b\u0005\u0005W\u0012YH\u0004\u0003\u0003n\ted\u0002\u0002B8\u0005orAA!\u001d\u0003v9\u0019AOa\u001d\n\u0003)L!\u0001[5\n\u0005\u0005;\u0017bAA\u0006M&!!QPA\u0005\u0003\u001diWm]:bO\u0016LAA!!\u0003\u0004\u0006AB)\u001a7fi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\tu\u0014\u0011B\u0005\u0005\u0005\u000f\u0013II\u0001\u000bEK2,G/\u00192mKR{\u0007/[2SKN,H\u000e\u001e\u0006\u0005\u0005\u0003\u0013\u0019\tC\u0004\u0003\u0006\u001d\u0002\rA!$\u0011\t\t=%\u0011S\u0007\u0003\u0005\u0007KAAa%\u0003\u0004\n9B)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0005/;\u0003\u0019\u0001BM\u0003)\t\u0007/\u001b,feNLwN\u001c\t\u0004\u000b\nm\u0015b\u0001BO\r\n\u0019\u0011J\u001c;\t\u000f\t\u0005v\u00051\u0001\u0002p\u0006q\u0001.Y:DYV\u001cH/\u001a:BkRD\u0007b\u0002BSO\u0001\u0007!qU\u0001\u0015O\u0016$H)Z:de&\u0014\u0017M\u00197f)>\u0004\u0018nY:\u0011\u000f\u0015\u0013IK!,\u00034&\u0019!1\u0016$\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBAC\u0005_\u000b9#\u0003\u0003\u00032\u0006M%\u0001C%uKJ\f'\r\\3\u0011\r\u0005e!QWA\u0014\u0013\u0011\u00119,!\n\u0003\u0007M+G\u000fC\u0004\u0003<\u001e\u0002\rAa*\u0002%\u001d,G\u000fR3mKR\f'\r\\3U_BL7m]\u0001\u0013Q\u0006tG\r\\3De\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0003\u0002z\n\u0005\u0007b\u0002B\u0003Q\u0001\u0007!qA\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\t\u0005\u000f\u0014yMa6\u0003ZB1!1\nB-\u0005\u0013\u0004BAa$\u0003L&!!Q\u001aBB\u0005a\u0019%/Z1uKR{\u0007/[2t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0005\u000bI\u0003\u0019\u0001Bi!\u0011\u0011yIa5\n\t\tU'1\u0011\u0002\u0018\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006DqA!)*\u0001\u0004\ty\u000fC\u0004\u0003\\&\u0002\rAa*\u0002%\u001d,Go\u0011:fCR\f'\r\\3U_BL7m]\u0001\u0019Q\u0006tG\r\\3Ba&4VM]:j_:\u001c(+Z9vKN$H\u0003BA}\u0005CDqA!\u0002+\u0001\u0004\u00119!\u0001\fbkRDwN]5{K\u0006cG/\u001a:SKN|WO]2f)\u0019\u00119Oa=\u0003~B!!\u0011\u001eBx\u001b\t\u0011YO\u0003\u0003\u0003n\u0006%\u0011\u0001\u0003:fcV,7\u000f^:\n\t\tE(1\u001e\u0002\t\u0003BLWI\u001d:pe\"9!Q_\u0016A\u0002\t]\u0018A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0005S\u0014I0\u0003\u0003\u0003|\n-(A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0005\u007f\\\u0003\u0019AB\u0001\u0003!\u0011Xm]8ve\u000e,\u0007\u0003BB\u0002\u0007\u000fi!a!\u0002\u000b\t\u0005\u001d\u0014\u0011B\u0005\u0005\u0007\u0013\u0019)A\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u00021!\fg\u000e\u001a7f\u0019\u0016<\u0017mY=BYR,'oQ8oM&<7\u000f\u0006\u0003\u0002z\u000e=\u0001b\u0002B\u0003Y\u0001\u0007!qA\u0001\u000bQ\u0006tG\r\\3W_R,G\u0003BA}\u0007+AqA!\u0002.\u0001\u0004\u00119!\u0001\fiC:$G.\u001a\"fO&t\u0017+^8sk6,\u0005o\\2i)\u0011\tIpa\u0007\t\u000f\t\u0015a\u00061\u0001\u0003\b\u0005!\u0002.\u00198eY\u0016,e\u000eZ)v_J,X.\u00129pG\"$B!!?\u0004\"!9!QA\u0018A\u0002\t\u001d\u0011\u0001\u00065b]\u0012dW\rR3tGJL'-Z)v_J,X\u000e\u0006\u0003\u0002z\u000e\u001d\u0002b\u0002B\u0003a\u0001\u0007!qA\u0001\u0016Q\u0006tG\r\\3BYR,'/S:s%\u0016\fX/Z:u)\u0011\tIp!\f\t\u000f\t\u0015\u0011\u00071\u0001\u0003\b\u0005a\u0002.\u00198eY\u0016\u0014%o\\6fe\"+\u0017M\u001d;CK\u0006$(+Z9vKN$H\u0003BA}\u0007gAqA!\u00023\u0001\u0004\u00119!\u0001\fiC:$G.Z+oe\u0016<\u0017n\u001d;fe\n\u0013xn[3s)\u0011\tIp!\u000f\t\u000f\t\u00151\u00071\u0001\u0003\b\u0005A\u0002.\u00198eY\u0016\u0014%o\\6feJ+w-[:ue\u0006$\u0018n\u001c8\u0015\t\u0005e8q\b\u0005\b\u0005\u000b!\u0004\u0019\u0001B\u0004\u0003EA\u0017M\u001c3mKJ\u000bg\r\u001e*fcV,7\u000f\u001e\u000b\u0007\u0003s\u001c)ea\u0012\t\u000f\t\u0015Q\u00071\u0001\u0003\b!91\u0011J\u001bA\u0002\r-\u0013!\u00042vS2$'+Z:q_:\u001cX\rE\u0004F\u0005S\u001bie!\u0017\u0011\t\r=3QK\u0007\u0003\u0007#RAaa\u0015\u0002\n\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0004X\rE#AC!qS6+7o]1hKB!!\u0011^B.\u0013\u0011\u0019iFa;\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0017a\u00065b]\u0012dW-\u00117uKJ\u001cE.[3oiF+x\u000e^1t)\u0011\tIpa\u0019\t\u000f\t\u0015a\u00071\u0001\u0003\b\u0005i\u0002.\u00198eY\u0016Len\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000f\u0006\u0003\u0002z\u000e%\u0004b\u0002B\u0003o\u0001\u0007!qA\u0001\u0017Q\u0006tG\r\\3De\u0016\fG/\u001a)beRLG/[8ogR!\u0011\u0011`B8\u0011\u001d\u0011)\u0001\u000fa\u0001\u0005\u000f\t\u0001c\u0019:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0011\rU4qQBH\u0007#\u0003bAa\u0013\u0003Z\r]\u0004C\u0002B0\u0005C\u001aI\b\u0005\u0003\u0004|\r\u0005e\u0002\u0002B5\u0007{JAaa \u0003\u0004\u0006a2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0017\u0002BBB\u0007\u000b\u00131d\u0011:fCR,\u0007+\u0019:uSRLwN\\:U_BL7MU3tk2$(\u0002BB@\u0005\u0007CqA!\u0002:\u0001\u0004\u0019I\t\u0005\u0003\u0003\u0010\u000e-\u0015\u0002BBG\u0005\u0007\u00131d\u0011:fCR,\u0007+\u0019:uSRLwN\\:SKF,Xm\u001d;ECR\f\u0007b\u0002BQs\u0001\u0007\u0011q\u001e\u0005\b\u00057L\u0004\u0019\u0001BT\u0003\u0005B\u0017M\u001c3mK\u0006cG/\u001a:QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;t)\u0011\tIpa&\t\u000f\t\u0015!\b1\u0001\u0003\b\u0005\u0001\u0003.\u00198eY\u0016d\u0015n\u001d;QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;t)\u0011\tIp!(\t\u000f\t\u00151\b1\u0001\u0003\b\u0005\u0001\u0003.\u00198eY\u0016\fE\u000e\\8dCR,\u0007K]8ek\u000e,'/\u00133t%\u0016\fX/Z:u)\u0011\tIpa)\t\u000f\t\u0015A\b1\u0001\u0003\b\u0001")
public class ControllerApis
implements ApiRequestHandler,
Logging {
    private final RequestChannel requestChannel;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private final scala.collection.immutable.Map<String, VersionRange> supportedFeatures;
    private final Controller controller;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final KafkaConfig config;
    private final MetaProperties metaProperties;
    private final Seq<Node> controllerNodes;
    private final ApiVersionManager apiVersionManager;
    private final AuthHelper authHelper;
    private final RequestHandlerHelper requestHelper;
    private final AclApis aclApis;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public Time time() {
        return this.time;
    }

    public scala.collection.immutable.Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Controller controller() {
        return this.controller;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public Seq<Node> controllerNodes() {
        return this.controllerNodes;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    private AclApis aclApis() {
        return this.aclApis;
    }

    public boolean isClosed() {
        return this.aclApis().isClosed();
    }

    public void close() {
        this.aclApis().close();
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        block30: {
            try {
                ApiKeys apiKeys = request.header().apiKey();
                if (ApiKeys.FETCH.equals(apiKeys)) {
                    this.handleFetch(request);
                    break block30;
                }
                if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                    this.handleFetchSnapshot(request);
                    break block30;
                }
                if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                    this.handleCreateTopics(request);
                    break block30;
                }
                if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                    this.handleDeleteTopics(request);
                    break block30;
                }
                if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                    this.handleApiVersionsRequest(request);
                    break block30;
                }
                if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
                    this.handleLegacyAlterConfigs(request);
                    break block30;
                }
                if (ApiKeys.VOTE.equals(apiKeys)) {
                    this.handleVote(request);
                    break block30;
                }
                if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                    this.handleBeginQuorumEpoch(request);
                    break block30;
                }
                if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                    this.handleEndQuorumEpoch(request);
                    break block30;
                }
                if (ApiKeys.DESCRIBE_QUORUM.equals(apiKeys)) {
                    this.handleDescribeQuorum(request);
                    break block30;
                }
                if (ApiKeys.ALTER_ISR.equals(apiKeys)) {
                    this.handleAlterIsrRequest(request);
                    break block30;
                }
                if (ApiKeys.BROKER_REGISTRATION.equals(apiKeys)) {
                    this.handleBrokerRegistration(request);
                    break block30;
                }
                if (ApiKeys.BROKER_HEARTBEAT.equals(apiKeys)) {
                    this.handleBrokerHeartBeatRequest(request);
                    break block30;
                }
                if (ApiKeys.UNREGISTER_BROKER.equals(apiKeys)) {
                    this.handleUnregisterBroker(request);
                    break block30;
                }
                if (ApiKeys.ALTER_CLIENT_QUOTAS.equals(apiKeys)) {
                    this.handleAlterClientQuotas(request);
                    break block30;
                }
                if (ApiKeys.INCREMENTAL_ALTER_CONFIGS.equals(apiKeys)) {
                    this.handleIncrementalAlterConfigs(request);
                    break block30;
                }
                if (ApiKeys.ALTER_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    this.handleAlterPartitionReassignments(request);
                    break block30;
                }
                if (ApiKeys.LIST_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    this.handleListPartitionReassignments(request);
                    break block30;
                }
                if (ApiKeys.ENVELOPE.equals(apiKeys)) {
                    this.handleEnvelopeRequest(request, requestLocal);
                    break block30;
                }
                if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                    this.handleSaslHandshakeRequest(request);
                    break block30;
                }
                if (ApiKeys.SASL_AUTHENTICATE.equals(apiKeys)) {
                    this.handleSaslAuthenticateRequest(request);
                    break block30;
                }
                if (ApiKeys.ALLOCATE_PRODUCER_IDS.equals(apiKeys)) {
                    this.handleAllocateProducerIdsRequest(request);
                    break block30;
                }
                if (ApiKeys.CREATE_PARTITIONS.equals(apiKeys)) {
                    this.handleCreatePartitions(request);
                    break block30;
                }
                if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
                    this.aclApis().handleDescribeAcls(request);
                    break block30;
                }
                if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
                    this.aclApis().handleCreateAcls(request);
                    break block30;
                }
                if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
                    this.aclApis().handleDeleteAcls(request);
                    break block30;
                }
                throw new ApiException(new StringBuilder(19).append("Unsupported ApiKey ").append(request.context().header.apiKey()).toString());
            }
            catch (FatalExitError fatalExitError) {
                throw fatalExitError;
            }
            catch (ExecutionException e) {
                this.requestHelper().handleError(request, e.getCause());
                return;
            }
            catch (Throwable e) {
                this.requestHelper().handleError(request, e);
            }
        }
    }

    public void handleEnvelopeRequest(RequestChannel.Request request, RequestLocal requestLocal) {
        if (!this.authHelper().authorize(request.context(), AclOperation.CLUSTER_ACTION, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            this.requestHelper().sendErrorResponseMaybeThrottle(request, (Throwable)new ClusterAuthorizationException(new StringBuilder(61).append("Principal ").append(request.context().principal).append(" does not have required CLUSTER_ACTION for envelope").toString()));
            return;
        }
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(request, this.requestChannel().metrics(), (Function1<RequestChannel.Request, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            this.handle(x$1, requestLocal);
            return BoxedUnit.UNIT;
        });
    }

    public void handleSaslHandshakeRequest(RequestChannel.Request request) {
        SaslHandshakeResponseData responseData = new SaslHandshakeResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code());
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$2 -> ControllerApis.$anonfun$handleSaslHandshakeRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    public void handleSaslAuthenticateRequest(RequestChannel.Request request) {
        SaslAuthenticateResponseData responseData = new SaslAuthenticateResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code()).setErrorMessage("SaslAuthenticate request received after successful authentication");
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$3 -> ControllerApis.$anonfun$handleSaslAuthenticateRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public void handleFetch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleFetchSnapshot(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleDeleteTopics(RequestChannel.Request request) {
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.deleteTopics(deleteTopicsRequest.data(), request.context().apiVersion(), this.authHelper().authorize(request.context(), AclOperation.DELETE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DELETE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n)).whenComplete((results, exception) -> this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleDeleteTopics$6(exception, deleteTopicsRequest, results, BoxesRunTime.unboxToInt((Object)throttleTimeMs))));
    }

    public CompletableFuture<List<DeleteTopicsResponseData.DeletableTopicResult>> deleteTopics(DeleteTopicsRequestData request, int apiVersion, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDeletableTopics) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config().deleteTopicEnable())) {
            if (apiVersion < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
        long deadlineNs = this.time().nanoseconds() + TimeUnit.NANOSECONDS.convert(request.timeoutMs(), TimeUnit.MILLISECONDS);
        ArrayList responses = new ArrayList();
        HashSet providedNames = new HashSet();
        HashSet duplicateProvidedNames = new HashSet();
        HashSet providedIds = new HashSet();
        HashSet duplicateProvidedIds = new HashSet();
        request.topicNames().forEach(name -> ControllerApis.addProvidedName$1(name, duplicateProvidedNames, providedNames));
        request.topics().forEach(topic -> {
            if (topic.name() == null) {
                if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                    ControllerApis.appendResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                    return;
                }
                if (duplicateProvidedIds.contains(topic.topicId()) || !providedIds.add(topic.topicId())) {
                    duplicateProvidedIds.add(topic.topicId());
                    providedIds.remove(topic.topicId());
                    return;
                }
                return;
            }
            if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                ControllerApis.addProvidedName$1(topic.name(), duplicateProvidedNames, providedNames);
                return;
            }
            ControllerApis.appendResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
        });
        duplicateProvidedNames.forEach(name -> ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses));
        duplicateProvidedIds.forEach(id -> ControllerApis.appendResponse$1(null, id, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses));
        HashSet toAuthenticate = new HashSet();
        toAuthenticate.addAll(providedNames);
        HashMap idToName = new HashMap();
        return this.controller().findTopicNames(deadlineNs, providedIds).thenCompose(topicNames -> {
            void var13_13;
            void var14_14;
            Object object;
            Object object2;
            topicNames.forEach((id, nameOrError) -> {
                if (nameOrError.isError()) {
                    ControllerApis.appendResponse$1(null, id, nameOrError.error(), responses);
                    return;
                }
                toAuthenticate.add(nameOrError.result());
                idToName.put(id, nameOrError.result());
            });
            scala.collection.mutable.Set topicsToAuthenticate = CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)toAuthenticate).asScala();
            if (hasClusterAuth) {
                object2 = topicsToAuthenticate.toSet();
                object = topicsToAuthenticate.toSet();
            } else {
                object2 = getDescribableTopics.apply((Object)topicsToAuthenticate);
                object = getDeletableTopics.apply((Object)topicsToAuthenticate);
            }
            scala.collection.immutable.Set set = object;
            Object describeable = object2;
            scala.collection.immutable.Set deletable = set;
            Iterator iterator = idToName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Uuid id2 = (Uuid)entry.getKey();
                String name = (String)entry.getValue();
                if (var14_14.contains((Object)name)) continue;
                if (var13_13.contains((Object)name)) {
                    ControllerApis.appendResponse$1(name, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                } else {
                    ControllerApis.appendResponse$1(null, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                }
                iterator.remove();
            }
            return this.controller().findTopicIds(deadlineNs, (Collection)providedNames).thenCompose(arg_0 -> ControllerApis.$anonfun$deleteTopics$7(this, (scala.collection.immutable.Set)var13_13, (scala.collection.immutable.Set)var14_14, duplicateProvidedIds, idToName, deadlineNs, responses, arg_0));
        });
    }

    public void handleCreateTopics(RequestChannel.Request request) {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.createTopics(createTopicsRequest.data(), this.authHelper().authorize(request.context(), AclOperation.CREATE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.CREATE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x))).whenComplete((result, exception) -> this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleCreateTopics$4(exception, createTopicsRequest, result, BoxesRunTime.unboxToInt((Object)throttleTimeMs))));
    }

    public CompletableFuture<CreateTopicsResponseData> createTopics(CreateTopicsRequestData request, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getCreatableTopics) {
        HashSet topicNames = new HashSet();
        HashSet duplicateTopicNames = new HashSet();
        request.topics().forEach(topicData -> {
            if (!duplicateTopicNames.contains(topicData.name())) {
                if (!topicNames.add(topicData.name())) {
                    topicNames.remove(topicData.name());
                    duplicateTopicNames.add(topicData.name());
                    return;
                }
                return;
            }
        });
        scala.collection.mutable.Set authorizedTopicNames = hasClusterAuth ? CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala() : (Set)getCreatableTopics.apply((Object)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala());
        CreateTopicsRequestData effectiveRequest = request.duplicate();
        Iterator iterator = effectiveRequest.topics().iterator();
        while (iterator.hasNext()) {
            CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
            if (!duplicateTopicNames.contains(creatableTopic.name()) && authorizedTopicNames.contains((Object)creatableTopic.name())) continue;
            iterator.remove();
        }
        return this.controller().createTopics(effectiveRequest).thenApply(arg_0 -> ControllerApis.$anonfun$createTopics$2(duplicateTopicNames, topicNames, (Set)authorizedTopicNames, arg_0));
    }

    public void handleApiVersionsRequest(RequestChannel.Request request) {
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> this.createResponseCallback$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs), request));
    }

    public ApiError authorizeAlterResource(RequestContext requestContext, ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.BROKER.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, resource.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED);
        }
        return new ApiError(Errors.INVALID_REQUEST, new StringBuilder(26).append("Unexpected resource type ").append(type).append(".").toString());
    }

    public void handleLegacyAlterConfigs(RequestChannel.Request request) {
        AlterConfigsResponseData response = new AlterConfigsResponseData();
        AlterConfigsRequest alterConfigsRequest = (AlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(AlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap configs = new HashMap();
                resource.configs().forEach(config -> configs.put(config.name(), config.value()));
                if (configChanges.put(configResource, configs) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        this.controller().legacyAlterConfigs(configChanges, alterConfigsRequest.data().validateOnly()).whenComplete((controllerResults, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            controllerResults.entrySet().forEach(entry -> response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleLegacyAlterConfigs$5(response, BoxesRunTime.unboxToInt((Object)throttleMs)));
        });
    }

    public void handleVote(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleEndQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleDescribeQuorum(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new DescribeQuorumResponse((DescribeQuorumResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleAlterIsrRequest(RequestChannel.Request request) {
        AlterIsrRequest alterIsrRequest = (AlterIsrRequest)request.body(ClassTag$.MODULE$.apply(AlterIsrRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().alterIsr(alterIsrRequest.data()).whenComplete((result, exception) -> {
            AlterIsrResponse response = exception != null ? alterIsrRequest.getErrorResponse(exception) : new AlterIsrResponse(result);
            this.requestHelper().sendResponseExemptThrottle(request, (AbstractResponse)response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleBrokerHeartBeatRequest(RequestChannel.Request request) {
        BrokerHeartbeatRequest heartbeatRequest = (BrokerHeartbeatRequest)request.body(ClassTag$.MODULE$.apply(BrokerHeartbeatRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().processBrokerHeartbeat(heartbeatRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerHeartBeatRequest$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    public void handleUnregisterBroker(RequestChannel.Request request) {
        UnregisterBrokerRequest decommissionRequest = (UnregisterBrokerRequest)request.body(ClassTag$.MODULE$.apply(UnregisterBrokerRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        this.controller().unregisterBroker(decommissionRequest.data().brokerId()).handle((x$5, e) -> {
            ControllerApis.$anonfun$handleUnregisterBroker$1(this, request, x$5, e);
            return BoxedUnit.UNIT;
        });
    }

    public void handleBrokerRegistration(RequestChannel.Request request) {
        BrokerRegistrationRequest registrationRequest = (BrokerRegistrationRequest)request.body(ClassTag$.MODULE$.apply(BrokerRegistrationRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().registerBroker(registrationRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerRegistration$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    private void handleRaftRequest(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleAlterClientQuotas(RequestChannel.Request request) {
        AlterClientQuotasRequest quotaRequest = (AlterClientQuotasRequest)request.body(ClassTag$.MODULE$.apply(AlterClientQuotasRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER_CONFIGS);
        this.controller().alterClientQuotas((Collection)quotaRequest.entries(), quotaRequest.validateOnly()).whenComplete((results, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterClientQuotas$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public void handleIncrementalAlterConfigs(RequestChannel.Request request) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap altersByName = new HashMap();
                resource.configs().forEach(config -> altersByName.put(config.name(), new AbstractMap.SimpleEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.forId((byte)config.configOperation()), config.value())));
                if (configChanges.put(configResource, altersByName) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        this.controller().incrementalAlterConfigs(configChanges, alterConfigsRequest.data().validateOnly()).whenComplete((controllerResults, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            controllerResults.entrySet().forEach(entry -> response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleIncrementalAlterConfigs$5(response, BoxesRunTime.unboxToInt((Object)throttleMs)));
        });
    }

    public void handleCreatePartitions(RequestChannel.Request request) {
        this.createPartitions(((CreatePartitionsRequest)request.body(ClassTag$.MODULE$.apply(CreatePartitionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).data(), this.authHelper().authorize(request.context(), AclOperation.CREATE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.CREATE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n)).whenComplete((responses, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreatePartitions$4(responses, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(CreatePartitionsRequestData request, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getCreatableTopics) {
        long deadlineNs = this.time().nanoseconds() + TimeUnit.NANOSECONDS.convert(request.timeoutMs(), TimeUnit.MILLISECONDS);
        ArrayList responses = new ArrayList();
        HashSet duplicateTopicNames = new HashSet();
        HashSet topicNames = new HashSet();
        request.topics().forEach(topic -> {
            if (!topicNames.add(topic.name())) {
                duplicateTopicNames.add(topic.name());
                return;
            }
        });
        duplicateTopicNames.forEach(topicName -> {
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."));
            topicNames.remove(topicName);
        });
        scala.collection.mutable.Set authorizedTopicNames = hasClusterAuth ? CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala() : (Set)getCreatableTopics.apply((Object)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala());
        ArrayList topics = new ArrayList();
        topicNames.forEach(arg_0 -> ControllerApis.$anonfun$createPartitions$3((Set)authorizedTopicNames, topics, request, responses, arg_0));
        return this.controller().createPartitions(deadlineNs, topics).thenApply(results -> {
            results.forEach(response -> responses.add(response));
            return responses;
        });
    }

    public void handleAlterPartitionReassignments(RequestChannel.Request request) {
        AlterPartitionReassignmentsRequest alterRequest = (AlterPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        AlterPartitionReassignmentsResponseData response = (AlterPartitionReassignmentsResponseData)this.controller().alterPartitionReassignments(alterRequest.data()).get();
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterPartitionReassignments$1(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public void handleListPartitionReassignments(RequestChannel.Request request) {
        ListPartitionReassignmentsRequest listRequest = (ListPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(ListPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        ListPartitionReassignmentsResponseData response = (ListPartitionReassignmentsResponseData)this.controller().listPartitionReassignments(listRequest.data()).get();
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleListPartitionReassignments$1(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public void handleAllocateProducerIdsRequest(RequestChannel.Request request) {
        AllocateProducerIdsRequest allocatedProducerIdsRequest = (AllocateProducerIdsRequest)request.body(ClassTag$.MODULE$.apply(AllocateProducerIdsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().allocateProducerIds(allocatedProducerIdsRequest.data()).whenComplete((results, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAllocateProducerIdsRequest$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public static final /* synthetic */ SaslHandshakeResponse $anonfun$handleSaslHandshakeRequest$1(SaslHandshakeResponseData responseData$1, int x$2) {
        return new SaslHandshakeResponse(responseData$1);
    }

    public static final /* synthetic */ SaslAuthenticateResponse $anonfun$handleSaslAuthenticateRequest$1(SaslAuthenticateResponseData responseData$2, int x$3) {
        return new SaslAuthenticateResponse(responseData$2);
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleDeleteTopics$6(Throwable exception$1, DeleteTopicsRequest deleteTopicsRequest$1, List results$1, int throttleTimeMs) {
        if (exception$1 != null) {
            return deleteTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$1);
        }
        DeleteTopicsResponseData responseData = new DeleteTopicsResponseData().setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(results$1.iterator())).setThrottleTimeMs(throttleTimeMs);
        return new DeleteTopicsResponse(responseData);
    }

    private static final void appendResponse$1(String name, Uuid id, ApiError error, ArrayList responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private static final void addProvidedName$1(String name, HashSet duplicateProvidedNames$1, HashSet providedNames$1) {
        if (duplicateProvidedNames$1.contains(name) || !providedNames$1.add(name)) {
            duplicateProvidedNames$1.add(name);
            providedNames$1.remove(name);
            return;
        }
    }

    public static final /* synthetic */ CompletableFuture $anonfun$deleteTopics$7(ControllerApis $this, scala.collection.immutable.Set describeable$1, scala.collection.immutable.Set deletable$1, HashSet duplicateProvidedIds$1, HashMap idToName$1, long deadlineNs$1, ArrayList responses$1, Map topicIds) {
        topicIds.forEach((name, idOrError) -> {
            if (!describeable$1.contains(name)) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
                return;
            }
            if (idOrError.isError()) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, idOrError.error(), responses$1);
                return;
            }
            if (deletable$1.contains(name)) {
                Uuid id = (Uuid)idOrError.result();
                if (duplicateProvidedIds$1.contains(id) || idToName$1.put(id, name) != null) {
                    duplicateProvidedIds$1.add(id);
                    idToName$1.remove(id);
                    ControllerApis.appendResponse$1(name, id, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses$1);
                    return;
                }
                return;
            }
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
        });
        return $this.controller().deleteTopics(deadlineNs$1, idToName$1.keySet()).thenApply(idToError -> {
            idToError.forEach((id, error) -> ControllerApis.appendResponse$1((String)idToName$1.get(id), id, error, responses$1));
            Collections.shuffle(responses$1);
            return responses$1;
        });
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleCreateTopics$4(Throwable exception$2, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result$1, int throttleTimeMs) {
        if (exception$2 != null) {
            return createTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$2);
        }
        result$1.setThrottleTimeMs(throttleTimeMs);
        return new CreateTopicsResponse(result$1);
    }

    public static final /* synthetic */ CreateTopicsResponseData $anonfun$createTopics$2(HashSet duplicateTopicNames$1, HashSet topicNames$1, Set authorizedTopicNames$1, CreateTopicsResponseData response) {
        duplicateTopicNames$1.forEach(name -> response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name.")));
        topicNames$1.forEach(name -> {
            if (!authorizedTopicNames$1.contains(name)) {
                response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
                return;
            }
        });
        return response;
    }

    private final ApiVersionsResponse createResponseCallback$1(int requestThrottleMs, RequestChannel.Request request$3) {
        ApiVersionsRequest apiVersionRequest = (ApiVersionsRequest)request$3.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        if (apiVersionRequest.hasUnsupportedRequestVersion()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.UNSUPPORTED_VERSION.exception());
        }
        if (!apiVersionRequest.isValid()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.INVALID_REQUEST.exception());
        }
        return this.apiVersionManager().apiVersionResponse(requestThrottleMs);
    }

    public static final /* synthetic */ AlterConfigsResponse $anonfun$handleLegacyAlterConfigs$5(AlterConfigsResponseData response$2, int throttleMs) {
        return new AlterConfigsResponse(response$2.setThrottleTimeMs(throttleMs));
    }

    private static final BrokerHeartbeatResponse createResponseCallback$2(int requestThrottleMs, BrokerHeartbeatReply reply, Throwable e) {
        if (e != null) {
            return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setIsCaughtUp(reply.isCaughtUp()).setIsFenced(reply.isFenced()).setShouldShutDown(reply.shouldShutDown()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerHeartBeatRequest$1(ControllerApis $this, RequestChannel.Request request$6, BrokerHeartbeatReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$6, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$2(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    private static final UnregisterBrokerResponse createResponseCallback$3(int requestThrottleMs, Throwable e) {
        if (e != null) {
            return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUnregisterBroker$1(ControllerApis $this, RequestChannel.Request request$7, Void x$5, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$7, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$3(BoxesRunTime.unboxToInt((Object)requestThrottleMs), e));
    }

    private static final BrokerRegistrationResponse createResponseCallback$4(int requestThrottleMs, BrokerRegistrationReply reply, Throwable e) {
        if (e != null) {
            return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setBrokerEpoch(reply.epoch()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerRegistration$1(ControllerApis $this, RequestChannel.Request request$8, BrokerRegistrationReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$8, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$4(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    public static final /* synthetic */ AlterClientQuotasResponse $anonfun$handleAlterClientQuotas$2(Map results$2, int requestThrottleMs) {
        return AlterClientQuotasResponse.fromQuotaEntities((Map)results$2, (int)requestThrottleMs);
    }

    public static final /* synthetic */ IncrementalAlterConfigsResponse $anonfun$handleIncrementalAlterConfigs$5(IncrementalAlterConfigsResponseData response$3, int throttleMs) {
        return new IncrementalAlterConfigsResponse(response$3.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ CreatePartitionsResponse $anonfun$handleCreatePartitions$4(List responses$2, int requestThrottleMs) {
        CreatePartitionsResponseData responseData = new CreatePartitionsResponseData().setResults(responses$2).setThrottleTimeMs(requestThrottleMs);
        return new CreatePartitionsResponse(responseData);
    }

    public static final /* synthetic */ void $anonfun$createPartitions$3(Set authorizedTopicNames$2, ArrayList topics$1, CreatePartitionsRequestData request$13, ArrayList responses$3, String topicName) {
        if (authorizedTopicNames$2.contains((Object)topicName)) {
            topics$1.add(request$13.topics().find(topicName));
            return;
        }
        responses$3.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
    }

    public static final /* synthetic */ AlterPartitionReassignmentsResponse $anonfun$handleAlterPartitionReassignments$1(AlterPartitionReassignmentsResponseData response$4, int requestThrottleMs) {
        return new AlterPartitionReassignmentsResponse(response$4.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ ListPartitionReassignmentsResponse $anonfun$handleListPartitionReassignments$1(ListPartitionReassignmentsResponseData response$5, int requestThrottleMs) {
        return new ListPartitionReassignmentsResponse(response$5.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ AllocateProducerIdsResponse $anonfun$handleAllocateProducerIdsRequest$2(AllocateProducerIdsResponseData results$3, int requestThrottleMs) {
        results$3.setThrottleTimeMs(requestThrottleMs);
        return new AllocateProducerIdsResponse(results$3);
    }

    public ControllerApis(RequestChannel requestChannel, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, scala.collection.immutable.Map<String, VersionRange> supportedFeatures, Controller controller, RaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, MetaProperties metaProperties, Seq<Node> controllerNodes, ApiVersionManager apiVersionManager) {
        this.requestChannel = requestChannel;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.time = time;
        this.supportedFeatures = supportedFeatures;
        this.controller = controller;
        this.raftManager = raftManager;
        this.config = config;
        this.metaProperties = metaProperties;
        this.controllerNodes = controllerNodes;
        this.apiVersionManager = apiVersionManager;
        this.authHelper = new AuthHelper(authorizer);
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.aclApis = new AclApis(this.authHelper(), authorizer, this.requestHelper(), "controller", config);
    }
}

