/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import kafka.network.RequestChannel;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ForwardingManager;
import kafka.server.ForwardingManager$;
import kafka.server.ForwardingManagerImpl;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestHeader;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005%4AAB\u0004\u0001\u0019!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0003&\u0001\u0011\u0005c\u0005C\u0003L\u0001\u0011\u0005C\nC\u0003U\u0001\u0011%QKA\u000bG_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJLU\u000e\u001d7\u000b\u0005!I\u0011AB:feZ,'OC\u0001\u000b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0007\u0014/A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000b\u000e\u0003\u001dI!AF\u0004\u0003#\u0019{'o^1sI&tw-T1oC\u001e,'\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0013\u0005)Q\u000f^5mg&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u00039\u0019\u0007.\u00198oK2l\u0015M\\1hKJ\u0004\"\u0001F\u0010\n\u0005\u0001:!\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\fa\u0001P5oSRtDCA\u0012%!\t!\u0002\u0001C\u0003\u001e\u0005\u0001\u0007a$\u0001\bg_J<\u0018M\u001d3SKF,Xm\u001d;\u0015\u0007\u001dRc\u0007\u0005\u0002\u000fQ%\u0011\u0011f\u0004\u0002\u0005+:LG\u000fC\u0003,\u0007\u0001\u0007A&A\u0004sKF,Xm\u001d;\u0011\u00055\u001adB\u0001\u00182\u001b\u0005y#B\u0001\u0019\n\u0003\u001dqW\r^<pe.L!AM\u0018\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011A'\u000e\u0002\b%\u0016\fX/Z:u\u0015\t\u0011t\u0006C\u00038\u0007\u0001\u0007\u0001(\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB!a\"O\u001e(\u0013\tQtBA\u0005Gk:\u001cG/[8ocA\u0019a\u0002\u0010 \n\u0005uz!AB(qi&|g\u000e\u0005\u0002@\u00136\t\u0001I\u0003\u0002B\u0005\u0006A!/Z9vKN$8O\u0003\u0002D\t\u000611m\\7n_:T!AC#\u000b\u0005\u0019;\u0015AB1qC\u000eDWMC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\u0002\u0013\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0002+\r|g\u000e\u001e:pY2,'/\u00119j-\u0016\u00148/[8ogV\tQ\nE\u0002\u000fy9\u0003\"a\u0014*\u000e\u0003AS!!\u0015#\u0002\u000f\rd\u0017.\u001a8ug&\u00111\u000b\u0015\u0002\u0010\u001d>$W-\u00119j-\u0016\u00148/[8og\u0006i\u0001/\u0019:tKJ+7\u000f]8og\u0016$BA\u0010,aI\")q+\u0002a\u00011\u00061!-\u001e4gKJ\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\u00079LwNC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&A\u0003\"zi\u0016\u0014UO\u001a4fe\")1&\u0002a\u0001CB\u0011qHY\u0005\u0003G\u0002\u0013q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\u0006K\u0016\u0001\rAZ\u0001\u0007Q\u0016\fG-\u001a:\u0011\u0005}:\u0017B\u00015A\u00055\u0011V-];fgRDU-\u00193fe\u0002")
public class ForwardingManagerImpl
implements ForwardingManager,
Logging {
    private final BrokerToControllerChannelManager channelManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void forwardRequest(RequestChannel.Request request, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
        ByteBuffer requestBuffer = request.buffer().duplicate();
        requestBuffer.flip();
        EnvelopeRequest.Builder envelopeRequest = ForwardingManager$.MODULE$.buildEnvelopeRequest(request.context(), requestBuffer);
        public class Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1
        extends ControllerRequestCompletionHandler {
            private final /* synthetic */ ForwardingManagerImpl $outer;
            private final RequestChannel.Request request$1;
            private final Function1 responseCallback$1;

            public void onComplete(ClientResponse clientResponse) {
                AbstractResponse abstractResponse;
                Errors envelopeError;
                T requestBody = this.request$1.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
                if (clientResponse.versionMismatch() != null) {
                    this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Returning `UNKNOWN_SERVER_ERROR` in response to request ").append(requestBody).append(" ").append("due to unexpected version error").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> clientResponse.versionMismatch());
                    this.responseCallback$1.apply((Object)new Some((Object)requestBody.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception())));
                    return;
                }
                if (clientResponse.authenticationException() != null) {
                    this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("Returning `UNKNOWN_SERVER_ERROR` in response to request ").append(requestBody).append(" ").append("due to authentication error").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> clientResponse.authenticationException());
                    this.responseCallback$1.apply((Object)new Some((Object)requestBody.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception())));
                    return;
                }
                EnvelopeResponse envelopeResponse = (EnvelopeResponse)clientResponse.responseBody();
                Errors errors = envelopeError = envelopeResponse.error();
                Errors errors2 = Errors.UNSUPPORTED_VERSION;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.responseCallback$1.apply((Object)None$.MODULE$);
                    return;
                }
                Errors errors3 = envelopeError;
                Errors errors4 = Errors.NONE;
                if (errors3 == null ? errors4 != null : !errors3.equals(errors4)) {
                    this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Forwarded request ").append($this.request$1).append(" failed with an error in the envelope response ").append(envelopeError).toString());
                    abstractResponse = requestBody.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception());
                } else {
                    abstractResponse = this.$outer.kafka$server$ForwardingManagerImpl$$parseResponse(envelopeResponse.responseData(), (AbstractRequest)requestBody, this.request$1.header());
                }
                AbstractResponse response = abstractResponse;
                this.responseCallback$1.apply((Object)Option$.MODULE$.apply((Object)response));
            }

            public void onTimeout() {
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Forwarding of the request ").append($this.request$1).append(" failed due to timeout exception").toString());
                AbstractResponse response = this.request$1.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())).getErrorResponse((Throwable)new TimeoutException());
                this.responseCallback$1.apply((Object)Option$.MODULE$.apply((Object)response));
            }

            public Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1(ForwardingManagerImpl $outer, RequestChannel.Request request$1, Function1 responseCallback$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.responseCallback$1 = responseCallback$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.common.requests.AbstractRequest ), $anonfun$onComplete$2(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$3(org.apache.kafka.common.requests.AbstractRequest ), $anonfun$onComplete$4(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$5(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 org.apache.kafka.common.protocol.Errors ), $anonfun$onTimeout$1(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 )}, serializedLambda);
            }
        }
        this.channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)envelopeRequest, new Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1(this, request, responseCallback));
    }

    @Override
    public Option<NodeApiVersions> controllerApiVersions() {
        return this.channelManager.controllerApiVersions();
    }

    public AbstractResponse kafka$server$ForwardingManagerImpl$$parseResponse(ByteBuffer buffer, AbstractRequest request, RequestHeader header) {
        try {
            return AbstractResponse.parseResponse((ByteBuffer)buffer, (RequestHeader)header);
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Failed to parse response from envelope for request with header ").append(header).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return request.getErrorResponse((Throwable)Errors.UNKNOWN_SERVER_ERROR.exception());
        }
    }

    public ForwardingManagerImpl(BrokerToControllerChannelManager channelManager) {
        this.channelManager = channelManager;
    }
}

