/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]d\u0001\u0002\u0016,\u0001AB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\r\u0002!\ta\u0012\u0005\bm\u0002\t\n\u0011\"\u0001x\u0011%\t)\u0001AI\u0001\n\u0003\t9\u0001C\u0005\u0002\f\u0001\t\n\u0011\"\u0001\u0002\u000e!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u0004\u0011%\t9\u0004AI\u0001\n\u0003\tI\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u0013\u0005]\u0003!%A\u0005\u0002\u00055\u0001\"CA-\u0001E\u0005I\u0011AA\u0007\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!!\u001a\u0001\t\u0013\t9\u0007C\u0005\u0002\u0004\u0002\t\n\u0011\"\u0003\u0002\u000e!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003OC\u0011\"a+\u0001#\u0003%\t!!,\t\u0013\u0005E\u0006!%A\u0005\u0002\u00055\u0001bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\n\u0003\u0003\u0004\u0011\u0013!C\u0001\u0003OC\u0011\"a1\u0001#\u0003%\t!!,\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAs\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0003_\u0004A\u0011AAy\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003AqA!\u0003\u0001\t\u0003\u0011Y\u0001C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!Q\u0005\u0001\u0005\u0002\t\u001d\u0002b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005\u007fAqA!\u0012\u0001\t\u0003\u00119\u0005C\u0004\u0003L\u0001!IA!\u0014\t\u000f\te\u0003\u0001\"\u0001\u0003\\!9!\u0011\r\u0001\u0005\u0002\t\r\u0004b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005[\u0002A\u0011\u0001B8\u00055\tE-\\5o5.\u001cE.[3oi*\u0011A&L\u0001\u0003u.T\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aZT\"A\u001d\u000b\u0005ij\u0013!B;uS2\u001c\u0018B\u0001\u001f:\u0005\u001daunZ4j]\u001e\f\u0001B_6DY&,g\u000e\u001e\t\u0003\u007f\u0001k\u0011aK\u0005\u0003\u0003.\u0012QbS1gW\u0006T6n\u00117jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002E\u000bB\u0011q\b\u0001\u0005\u0006{\t\u0001\rAP\u0001\fGJ,\u0017\r^3U_BL7\rF\u0004I\u0017bkv,[9\u0011\u0005IJ\u0015B\u0001&4\u0005\u0011)f.\u001b;\t\u000b1\u001b\u0001\u0019A'\u0002\u000bQ|\u0007/[2\u0011\u00059+fBA(T!\t\u00016'D\u0001R\u0015\t\u0011v&\u0001\u0004=e>|GOP\u0005\u0003)N\na\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011Ak\r\u0005\u00063\u000e\u0001\rAW\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u001a\\\u0013\ta6GA\u0002J]RDQAX\u0002A\u0002i\u000b\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d\u00017\u0001%AA\u0002\u0005\f1\u0002^8qS\u000e\u001cuN\u001c4jOB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0005kRLGNC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'A\u0003)s_B,'\u000f^5fg\"9!n\u0001I\u0001\u0002\u0004Y\u0017!\u0004:bG.\fu/\u0019:f\u001b>$W\r\u0005\u0002m_6\tQN\u0003\u0002o[\u0005)\u0011\rZ7j]&\u0011\u0001/\u001c\u0002\u000e%\u0006\u001c7.Q<be\u0016lu\u000eZ3\t\u000fI\u001c\u0001\u0013!a\u0001g\u0006YQo]3t)>\u0004\u0018nY%e!\t\u0011D/\u0003\u0002vg\t9!i\\8mK\u0006t\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0002q*\u0012\u0011-_\u0016\u0002uB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0013Ut7\r[3dW\u0016$'BA@4\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0007a(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012*TCAA\u0005U\tY\u00170A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005=!FA:z\u0003I9W\r\u001e\"s_.,'/T3uC\u0012\fG/Y:\u0015\r\u0005U\u0011qEA\u0015!\u0019\t9\"!\b\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\u0019\u0014AC2pY2,7\r^5p]&!\u0011qDA\r\u0005\r\u0019V-\u001d\t\u0004Y\u0006\r\u0012bAA\u0013[\nq!I]8lKJlU\r^1eCR\f\u0007b\u00026\b!\u0003\u0005\ra\u001b\u0005\n\u0003W9\u0001\u0013!a\u0001\u0003[\t!B\u0019:pW\u0016\u0014H*[:u!\u0015\u0011\u0014qFA\u001a\u0013\r\t\td\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0005]\u0011Q\u0004.\u00029\u001d,GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005ar-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1tI\u0011,g-Y;mi\u0012\u0012TCAA\u001eU\r\ti#_\u0001\u001aGJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000fF\u0006I\u0003\u0003\n\u0019%a\u0012\u0002R\u0005U\u0003\"\u0002'\u000b\u0001\u0004i\u0005BBA#\u0015\u0001\u0007\u0011-\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003\u0013R\u0001\u0019AA&\u0003i\u0001\u0018M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u001d\t9\"!\u0014[\u0003gIA!a\u0014\u0002\u001a\t\u0019Q*\u00199\t\u0011\u0005M#\u0002%AA\u0002M\f\u0001B^1mS\u0012\fG/\u001a\u0005\be*\u0001\n\u00111\u0001t\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\n1e\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oi\u0012\"WMZ1vYR$S'A\nwC2LG-\u0019;f)>\u0004\u0018nY\"sK\u0006$X\rF\u0004I\u0003?\n\t'a\u0019\t\u000b1k\u0001\u0019A'\t\u000f\u0005%S\u00021\u0001\u0002L!1\u0011QI\u0007A\u0002\u0005\fQd\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\n\u0011\u0006%\u00141NA?\u0003\u0003CQ\u0001\u0014\bA\u00025Cq!!\u001c\u000f\u0001\u0004\ty'A\tsKBd\u0017nY1BgNLwM\\7f]R\u0004r!a\u0006\u0002Ni\u000b\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9(L\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BA>\u0003k\u0012\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u0019\tyH\u0004a\u0001g\u0006A\u0011n]+qI\u0006$X\rC\u0004s\u001dA\u0005\t\u0019A:\u0002O]\u0014\u0018\u000e^3U_BL7\rU1si&$\u0018n\u001c8BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u0001\fI\u0016dW\r^3U_BL7\rF\u0002I\u0003\u0013CQ\u0001\u0014\tA\u00025\u000bQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHCDA&\u0003\u001f\u000b\t*!&\u0002\u001a\u0006u\u0015\u0011\u0015\u0005\u0006\u0019F\u0001\r!\u0014\u0005\b\u0003'\u000b\u0002\u0019AA8\u0003I)\u00070[:uS:<\u0017i]:jO:lWM\u001c;\t\u000f\u0005]\u0015\u00031\u0001\u0002\u0016\u0005Q\u0011\r\u001c7Ce>\\WM]:\t\u0011\u0005m\u0015\u0003%AA\u0002i\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\"CA7#A\u0005\t\u0019AAP!\u0015\u0011\u0014qFA&\u0011!\t\u0019+\u0005I\u0001\u0002\u0004\u0019\u0018\u0001\u0004<bY&$\u0017\r^3P]2L\u0018aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\tIK\u000b\u0002[s\u00069\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H%N\u000b\u0003\u0003_S3!a(z\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$c'A\u000fde\u0016\fG/\u001a(foB\u000b'\u000f^5uS>t7/Q:tS\u001etW.\u001a8u)1\ty'a.\u0002:\u0006m\u0016QXA`\u0011\u0015aU\u00031\u0001N\u0011\u001d\t\u0019*\u0006a\u0001\u0003_Bq!a&\u0016\u0001\u0004\t)\u0002\u0003\u0005\u0002\u001cV\u0001\n\u00111\u0001[\u0011%\ti'\u0006I\u0001\u0002\u0004\ty*A\u0014de\u0016\fG/\u001a(foB\u000b'\u000f^5uS>t7/Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\"\u0014aJ2sK\u0006$XMT3x!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIU\nad\u0019:fCR,\u0007+\u0019:uSRLwN\\:XSRD\u0017i]:jO:lWM\u001c;\u0015\u0011\u0005=\u0014\u0011ZAf\u0003\u001bDQ\u0001\u0014\rA\u00025Cq!a%\u0019\u0001\u0004\ty\u0007C\u0004\u0002Pb\u0001\r!a\u001c\u0002-9,w\u000fU1si&$\u0018n\u001c8BgNLwM\\7f]R\f\u0011D^1mS\u0012\fG/\u001a*fa2L7-Y!tg&<g.\\3oiR9\u0001*!6\u0002X\u0006m\u0007bBA73\u0001\u0007\u00111\n\u0005\u0007\u00033L\u0002\u0019\u0001.\u00023\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\b\u0003;L\u0002\u0019AAp\u0003I\tg/Y5mC\ndWM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\t9\u000b\tOW\u0005\u0004\u0003G<&aA*fi\u0006Y\u0001/\u0019:tK\n\u0013xn[3s)\u0011\tI/a;\u0011\tI\nyC\u0017\u0005\u0007\u0003[T\u0002\u0019A'\u0002\r\t\u0014xn[3s\u00035\u0019\u0007.\u00198hK\u000e{gNZ5hgR9\u0001*a=\u0002x\u0006m\bBBA{7\u0001\u0007Q*\u0001\u0006f]RLG/\u001f+za\u0016Da!!?\u001c\u0001\u0004i\u0015AC3oi&$\u0018PT1nK\"1\u0011Q`\u000eA\u0002\u0005\fqaY8oM&<7/\u0001\u000bdQ\u0006tw-Z\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u000b\u0006\u0011\n\r!q\u0001\u0005\u0007\u0005\u000ba\u0002\u0019A'\u0002#M\fg.\u001b;ju\u0016$7\t\\5f]RLE\r\u0003\u0004\u0002~r\u0001\r!Y\u0001\u001fG\"\fgnZ3Vg\u0016\u0014xJ]+tKJ\u001cE.[3oi&#7i\u001c8gS\u001e$R\u0001\u0013B\u0007\u0005#AaAa\u0004\u001e\u0001\u0004i\u0015aE:b]&$\u0018N_3e\u000b:$\u0018\u000e^=OC6,\u0007BBA\u007f;\u0001\u0007\u0011-\u0001\twC2LG-\u0019;f\u0013B\u001cuN\u001c4jOR)\u0001Ja\u0006\u0003\u001c!1!\u0011\u0004\u0010A\u00025\u000b!!\u001b9\t\r\u0005uh\u00041\u0001b\u00039\u0019\u0007.\u00198hK&\u00038i\u001c8gS\u001e$R\u0001\u0013B\u0011\u0005GAaA!\u0007 \u0001\u0004i\u0005BBA\u007f?\u0001\u0007\u0011-A\nwC2LG-\u0019;f)>\u0004\u0018nY\"p]\u001aLw\rF\u0003I\u0005S\u0011Y\u0003C\u0003MA\u0001\u0007Q\n\u0003\u0004\u0002~\u0002\u0002\r!Y\u0001\u0012G\"\fgnZ3U_BL7mQ8oM&<G#\u0002%\u00032\tM\u0002\"\u0002'\"\u0001\u0004i\u0005BBA\u007fC\u0001\u0007\u0011-\u0001\ndQ\u0006tw-\u001a\"s_.,'oQ8oM&<G#\u0002%\u0003:\tu\u0002b\u0002B\u001eE\u0001\u0007\u00111G\u0001\bEJ|7.\u001a:t\u0011\u0019\tiP\ta\u0001CR)\u0001J!\u0011\u0003D!9\u0011Q^\u0012A\u0002\u0005%\bBBA\u007fG\u0001\u0007\u0011-\u0001\u000bwC2LG-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0004\u0011\n%\u0003BBA\u007fI\u0001\u0007\u0011-\u0001\ndQ\u0006tw-Z#oi&$\u0018pQ8oM&<Gc\u0002%\u0003P\tM#q\u000b\u0005\u0007\u0005#*\u0003\u0019A'\u0002\u001dI|w\u000e^#oi&$\u0018\u0010V=qK\"1!QK\u0013A\u00025\u000bqCZ;mYN\u000bg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\r\u0005uX\u00051\u0001b\u0003E1W\r^2i\u000b:$\u0018\u000e^=D_:4\u0017n\u001a\u000b\u0006C\nu#q\f\u0005\u0007\u0005#2\u0003\u0019A'\t\r\t=a\u00051\u0001N\u0003I9W\r^!mYR{\u0007/[2D_:4\u0017nZ:\u0015\u0005\t\u0015\u0004CBA\f\u0003\u001bj\u0015-A\u000bgKR\u001c\u0007.\u00117m\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\t\t\u0015$1\u000e\u0005\u0007\u0003kD\u0003\u0019A'\u00025\u0019,Go\u00195BY2\u001c\u0005.\u001b7e\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\r\t\u0015$\u0011\u000fB:\u0011\u0019\u0011\t&\u000ba\u0001\u001b\"1!QO\u0015A\u00025\u000bqb\u00195jY\u0012,e\u000e^5usRK\b/\u001a")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesTopicId) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerMetadatas, partitions, replicationFactor, -1, -1);
        boolean x$5 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment, x$5, usesTopicId);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack())))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment, boolean validate, boolean usesTopicId) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)((Map)partitionReplicaAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)v));
            }
            throw new MatchError(null);
        })), false, usesTopicId);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            scala.collection.immutable.Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            scala.collection.immutable.Set collidingTopics = (scala.collection.immutable.Set)allTopics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesTopicId) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ topicIdOpt = usesTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Map<TopicPartition, Seq<Object>>)((Map)assignment.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        TopicPartition k = (TopicPartition)x0$2._1();
                        ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.replicas());
                    }
                    throw new MatchError(null);
                })));
            } else {
                Map<String, Uuid> topicIds = this.zkClient.getTopicIdsForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                this.zkClient.setTopicAssignment(topic, (Option<Uuid>)topicIds.get((Object)topic), (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$4());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment);
        if (validateOnly) {
            return (Map)((MapOps)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions)).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
                }
                throw new MatchError(null);
            });
        }
        return (Map)this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
            }
            throw new MatchError(null);
        });
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        replicaAssignment.foreach((Function1 & Serializable)proposedReplicaAssignment -> {
            this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()))).toSet());
            return BoxedUnit.UNIT;
        });
        return (Map)((Map)replicaAssignment.getOrElse((Function0 & Serializable)() -> {
            int startIndex = package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$5(existingAssignmentPartition0, x$7))));
            return AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)allBrokers, partitionsToAdd, existingAssignmentPartition0.size(), startIndex, existingAssignment.size());
        })).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                int tp = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                Nil$ nil$ = Nil$.MODULE$;
                Nil$ apply_addingReplicas = Nil$.MODULE$;
                Object var3_4 = null;
                nil$ = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)new ReplicaAssignment((Seq<Object>)replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> createNewPartitionsAssignment$default$5() {
        return None$.MODULE$;
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, false);
        return combinedAssignment;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, replicas) -> AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), replicas);
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    Seq replicas = (Seq)x1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                return x1 != null && ((Seq)x1._2()).size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable)x$8 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$8))).getOrElse((Function0 & Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(11).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(11).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(Map partitionReplicaAssignment$2, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$7) {
        return x$7.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Tuple2 $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, Seq replicas) {
        if (replicas.isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (replicas.size() != replicas.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!replicas.toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$8) {
        return Integer.toString(x$8);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(11).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(11).append(path).append('/').append((String)entityName).toString());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }
}

