/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.KafkaRestConfig;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerMetrics {
    private static final Logger log = LoggerFactory.getLogger(ProducerMetrics.class);
    private final String fullyQualifiedRequestSensor;
    private final String fullyQualifiedRequestSizeSensor;
    private final String fullyQualifiedResponseSensor;
    private final String fullyQualifiedRecordErrorSensor;
    private final String fullyQualifiedRequestLatencySensor;
    private final String jmxPrefix;
    private final Metrics metrics;
    private final ConcurrentMap<BeanCoordinate, ProduceMetricMBean> beansByCoordinate = new ConcurrentHashMap<BeanCoordinate, ProduceMetricMBean>();

    public ProducerMetrics(KafkaRestConfig config, Time time) {
        this.metrics = new MetricsBuilder((MetricsContext)config.getMetricsContext()).withTime(time).build();
        this.jmxPrefix = config.getString("metrics.jmx.prefix");
        String sensorNameTemplate = this.jmxPrefix + ":" + "produce-api-metrics" + ":%s";
        this.fullyQualifiedRecordErrorSensor = String.format(sensorNameTemplate, "record-error-sensor");
        this.fullyQualifiedRequestSensor = String.format(sensorNameTemplate, "request-sensor");
        this.fullyQualifiedRequestLatencySensor = String.format(sensorNameTemplate, "request-latency-sensor");
        this.fullyQualifiedRequestSizeSensor = String.format(sensorNameTemplate, "request-size-sensor");
        this.fullyQualifiedResponseSensor = String.format(sensorNameTemplate, "response-sensor");
        this.setupMetricBeans();
    }

    public ProduceMetricMBean mbean(String groupName, Map<String, String> tags) {
        BeanCoordinate beanCoordinate = new BeanCoordinate(groupName, tags);
        this.beansByCoordinate.putIfAbsent(beanCoordinate, new ProduceMetricMBean(beanCoordinate));
        return (ProduceMetricMBean)this.beansByCoordinate.get(beanCoordinate);
    }

    private void setupMetricBeans() {
        ProduceMetricMBean metricMBean = this.mbean("produce-api-metrics", Collections.emptyMap());
        if (metricMBean != null) {
            log.warn("closing pre-existing mBean:" + metricMBean);
            metricMBean.close();
        }
        new SensorBuilder(metricMBean, this.jmxPrefix, "request-sensor").addRate("request-rate", "The average number of requests sent per second.").addWindowedCount("request-count-windowed", "The total number of requests sent within the given window.").build();
        new SensorBuilder(metricMBean, this.jmxPrefix, "request-size-sensor").addAvg("request-size-avg", "The average request size in bytes.").build();
        new SensorBuilder(metricMBean, this.jmxPrefix, "response-sensor").addRate("response-rate", "The average number of responses sent per second.").addWindowedCount("response-count-windowed", "The total number of responses sent in the given window.").build();
        new SensorBuilder(metricMBean, this.jmxPrefix, "record-error-sensor").addRate("record-error-rate", "The average per-second number of record sends that resulted in errors.").addWindowedCount("error-count-windowed", "The total number of record sends that resulted in errors in the given window.").build();
        new SensorBuilder(metricMBean, this.jmxPrefix, "request-latency-sensor").addMax("request-latency-max", "The max request latency").addAvg("request-latency-avg", "The average request latency").addPercentiles("request-latency-avg-", (Map<String, Double>)ImmutableMap.of((Object)"p95", (Object)0.95, (Object)"p99", (Object)0.99, (Object)"p999", (Object)0.999), "Request latency percentiles.").build();
        log.info("Successfully registered kafka-rest produce metrics with JMX");
    }

    public static class MetricsBuilder {
        private MetricsContext metricsContext;
        private JmxReporter reporter;
        private int numSamples = 10;
        private long sampleWindowMs = 10000L;
        private Time time = Time.SYSTEM;
        private Sensor.RecordingLevel level = Sensor.RecordingLevel.INFO;

        public MetricsBuilder(MetricsContext metricsContext) {
            this.metricsContext = metricsContext;
            this.reporter = new JmxReporter();
            this.reporter.contextChange(metricsContext);
        }

        public MetricsBuilder withTime(Time time) {
            this.time = time;
            return this;
        }

        public Metrics build() {
            List<JmxReporter> reporters = Collections.singletonList(this.reporter);
            MetricConfig metricConfig = new MetricConfig().samples(this.numSamples).timeWindow(this.sampleWindowMs, TimeUnit.MILLISECONDS).recordLevel(this.level);
            return new Metrics(metricConfig, reporters, this.time, this.metricsContext);
        }
    }

    private static class MeasuredStatSupplier {
        private MeasuredStatSupplier() {
        }

        public static MeasurableStat avg() {
            return new Avg();
        }

        public static MeasurableStat rate() {
            return new Rate();
        }

        public static MeasurableStat max() {
            return new Max();
        }

        public static MeasurableStat windowedCount() {
            return new WindowedCount();
        }

        public static CompoundStat percentiles(Map<MetricName, Double> percentiles) {
            return new Percentiles(120000, 30000.0, Percentiles.BucketSizing.CONSTANT, (Percentile[])percentiles.entrySet().stream().map(namePercentile -> new Percentile((MetricName)namePercentile.getKey(), ((Double)namePercentile.getValue()).doubleValue())).toArray(Percentile[]::new));
        }
    }

    private static class SensorBuilder {
        private final ProduceMetricMBean bean;
        private final Sensor sensor;

        public SensorBuilder(ProduceMetricMBean bean, String jmxPrefix, String name) {
            this.bean = bean;
            this.sensor = bean.sensor(String.join((CharSequence)":", jmxPrefix, "produce-api-metrics", name));
        }

        public SensorBuilder addAvg(String name, String doc) {
            MetricName metricName = this.getMetricName(name, doc);
            this.sensor.add(metricName, MeasuredStatSupplier.avg());
            return this;
        }

        public SensorBuilder addRate(String name, String doc) {
            MetricName metricName = this.getMetricName(name, doc);
            this.sensor.add(metricName, MeasuredStatSupplier.rate());
            return this;
        }

        public SensorBuilder addMax(String name, String doc) {
            MetricName metricName = this.getMetricName(name, doc);
            this.sensor.add(metricName, MeasuredStatSupplier.max());
            return this;
        }

        public SensorBuilder addWindowedCount(String name, String doc) {
            MetricName metricName = this.getMetricName(name, doc);
            this.sensor.add(metricName, MeasuredStatSupplier.windowedCount());
            return this;
        }

        public SensorBuilder addPercentiles(String name, Map<String, Double> suffixPercentiles, String doc) {
            Map<MetricName, Double> namePercentiles = suffixPercentiles.entrySet().stream().map(suffixPercentile -> new AbstractMap.SimpleImmutableEntry(this.getMetricName(name + (String)suffixPercentile.getKey(), doc), suffixPercentile.getValue())).collect(Collectors.toMap(e -> (MetricName)e.getKey(), e -> (Double)e.getValue()));
            this.sensor.add(MeasuredStatSupplier.percentiles(namePercentiles));
            return this;
        }

        public Sensor build() {
            return this.sensor;
        }

        private MetricName getMetricName(String name, String doc) {
            MetricName metricName = this.bean.metricName(new MetricNameTemplate(name, "produce-api-metrics", doc, Collections.emptySet()));
            return metricName;
        }
    }

    public class ProduceMetricMBean
    implements AutoCloseable {
        private final BeanCoordinate beanCoordinate;

        ProduceMetricMBean(BeanCoordinate beanCoordinate) {
            this.beanCoordinate = Objects.requireNonNull(beanCoordinate);
        }

        public void recordResponse() {
            this.recordMetric(ProducerMetrics.this.fullyQualifiedResponseSensor, 1.0);
        }

        public void recordRequestLatency(long value) {
            this.recordMetric(ProducerMetrics.this.fullyQualifiedRequestLatencySensor, value);
        }

        public void recordError() {
            this.recordMetric(ProducerMetrics.this.fullyQualifiedRecordErrorSensor, 1.0);
        }

        public void recordRequest() {
            this.recordMetric(ProducerMetrics.this.fullyQualifiedRequestSensor, 1.0);
        }

        public void recordRequestSize(double value) {
            this.recordMetric(ProducerMetrics.this.fullyQualifiedRequestSizeSensor, value);
        }

        private void recordMetric(String sensorName, double value) {
            Sensor sensor = ProducerMetrics.this.metrics.getSensor(sensorName);
            if (sensor != null) {
                sensor.record(value);
            }
        }

        public MetricName metricName(MetricNameTemplate template) {
            return ProducerMetrics.this.metrics.metricInstance(template, this.beanCoordinate.tags);
        }

        synchronized Sensor sensor(String name) {
            Sensor sensor = ProducerMetrics.this.metrics.sensor(name);
            return sensor;
        }

        @Override
        public synchronized void close() {
            for (MetricName metricName : new HashSet(ProducerMetrics.this.metrics.metrics().keySet())) {
                if (!metricName.group().equals(this.beanCoordinate.beanName) || !this.beanCoordinate.tags.equals(metricName.tags())) continue;
                ProducerMetrics.this.metrics.removeMetric(metricName);
            }
        }
    }

    private class BeanCoordinate {
        private final String beanName;
        private final Map<String, String> tags;

        public BeanCoordinate(String beanName, Map<String, String> tags) {
            this.beanName = Objects.requireNonNull(beanName);
            this.tags = ImmutableMap.copyOf(tags);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanCoordinate)) {
                return false;
            }
            BeanCoordinate that = (BeanCoordinate)o;
            return Objects.equals(this.beanName, that.beanName) && Objects.equals(this.tags, that.tags);
        }

        public int hashCode() {
            return Objects.hash(this.beanName, this.tags);
        }
    }
}

