/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.resources.v3.ProduceRateLimiter;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ProduceRateLimiters {
    private final int maxRequestsPerSecond;
    private final int maxBytesPerSecond;
    private final Duration gracePeriod;
    private final boolean rateLimitingEnabled;
    private final LoadingCache<String, ProduceRateLimiter> cache;

    @Inject
    public ProduceRateLimiters(@ConfigModule.ProduceGracePeriodConfig Duration produceGracePeriodConfig, @ConfigModule.ProduceRateLimitCountConfig Integer produceRateLimitCountConfig, @ConfigModule.ProduceRateLimitBytesConfig Integer produceRateLimitBytesConfig, final @ConfigModule.ProduceRateLimitEnabledConfig Boolean produceRateLimitEnabledConfig, @ConfigModule.ProduceRateLimitCacheExpiryConfig Duration produceRateLimitCacheExpiryConfig, final Clock time) {
        this.maxRequestsPerSecond = Objects.requireNonNull(produceRateLimitCountConfig);
        this.gracePeriod = Objects.requireNonNull(produceGracePeriodConfig);
        this.rateLimitingEnabled = Objects.requireNonNull(produceRateLimitEnabledConfig);
        this.maxBytesPerSecond = Objects.requireNonNull(produceRateLimitBytesConfig);
        Objects.requireNonNull(time);
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(produceRateLimitCacheExpiryConfig.toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, ProduceRateLimiter>(){

            public ProduceRateLimiter load(String key) {
                return new ProduceRateLimiter(ProduceRateLimiters.this.gracePeriod, ProduceRateLimiters.this.maxRequestsPerSecond, ProduceRateLimiters.this.maxBytesPerSecond, produceRateLimitEnabledConfig, time);
            }
        });
    }

    public Optional<Duration> calculateGracePeriodExceeded(String clusterId, long requestSize) {
        if (!this.rateLimitingEnabled) {
            return Optional.empty();
        }
        ProduceRateLimiter rateLimiter = (ProduceRateLimiter)this.cache.getUnchecked((Object)clusterId);
        Optional<Duration> waitTime = rateLimiter.calculateGracePeriodExceeded(requestSize);
        return waitTime;
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

