/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.PackageVersion;
import io.confluent.kafkarest.entities.v3.ProduceRequest;
import java.io.IOException;

public class ProduceRequestSerdeModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public ProduceRequestSerdeModule() {
        super(PackageVersion.VERSION);
        this.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (beanDesc.getBeanClass() == ProduceRequest.class) {
                    return new ProduceRequestDeserializer(deserializer);
                }
                return deserializer;
            }
        });
    }

    private class ProduceRequestDeserializer
    extends StdDeserializer<ProduceRequest>
    implements ResolvableDeserializer {
        private static final long serialVersionUID = 7923585097068641765L;
        private final JsonDeserializer<?> defaultDeserializer;

        public ProduceRequestDeserializer(JsonDeserializer<?> defaultDeserializer) {
            super(ProduceRequest.class);
            this.defaultDeserializer = defaultDeserializer;
        }

        public ProduceRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            long startPosition = p.getCurrentLocation().getByteOffset() == -1L ? p.getCurrentLocation().getCharOffset() : p.getCurrentLocation().getByteOffset();
            ProduceRequest pr = (ProduceRequest)this.defaultDeserializer.deserialize(p, ctxt);
            long endPosition = p.getCurrentLocation().getByteOffset() == -1L ? p.getCurrentLocation().getCharOffset() : p.getCurrentLocation().getByteOffset();
            long requestSize = startPosition == -1L || endPosition == -1L ? 0L : endPosition - startPosition + 1L;
            return ProduceRequest.fromUnsized(pr, requestSize);
        }

        public void resolve(DeserializationContext ctxt) throws JsonMappingException {
            ((ResolvableDeserializer)this.defaultDeserializer).resolve(ctxt);
        }
    }
}

