/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.backends.kafka;

import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerMetrics;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.utils.Time;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public final class KafkaModule
extends AbstractBinder {
    protected void configure() {
        this.bindFactory(KafkaRestContextFactory.class).to(KafkaRestContext.class).in(Singleton.class);
        this.bindFactory(AdminFactory.class).to(Admin.class).in(Singleton.class);
        this.bindFactory(ProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(Singleton.class);
        this.bindFactory(ProducerMetricsFactory.class, Singleton.class).to(ProducerMetrics.class).in(Singleton.class);
    }

    private static final class ProducerMetricsFactory
    implements Factory<ProducerMetrics> {
        private final Provider<KafkaRestContext> context;
        private volatile ProducerMetrics producerMetrics;

        @Inject
        ProducerMetricsFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProducerMetrics provide() {
            ProducerMetrics localProducerMetrics = this.producerMetrics;
            if (localProducerMetrics == null) {
                ProducerMetricsFactory producerMetricsFactory = this;
                synchronized (producerMetricsFactory) {
                    localProducerMetrics = this.producerMetrics;
                    if (localProducerMetrics == null) {
                        this.producerMetrics = localProducerMetrics = new ProducerMetrics(((KafkaRestContext)this.context.get()).getConfig(), Time.SYSTEM);
                    }
                }
            }
            return localProducerMetrics;
        }

        public void dispose(ProducerMetrics producerMetrics) {
        }
    }

    private static final class ProducerFactory
    implements Factory<Producer<byte[], byte[]>> {
        private final KafkaRestContext context;

        @Inject
        private ProducerFactory(KafkaRestContext context) {
            this.context = Objects.requireNonNull(context);
        }

        public Producer<byte[], byte[]> provide() {
            return this.context.getProducer();
        }

        public void dispose(Producer<byte[], byte[]> producer) {
            producer.close();
        }
    }

    private static final class AdminFactory
    implements Factory<Admin> {
        private final KafkaRestContext context;

        @Inject
        private AdminFactory(KafkaRestContext context) {
            this.context = Objects.requireNonNull(context);
        }

        public Admin provide() {
            return this.context.getAdmin();
        }

        public void dispose(Admin admin) {
            admin.close();
        }
    }

    private static final class KafkaRestContextFactory
    implements Factory<KafkaRestContext> {
        private final KafkaRestConfig config;

        @Inject
        private KafkaRestContextFactory(KafkaRestConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        public KafkaRestContext provide() {
            return new DefaultKafkaRestContext(this.config);
        }

        public void dispose(KafkaRestContext context) {
            context.shutdown();
        }
    }
}

