/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.ProduceRequest;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_ProduceRequest
extends ProduceRequest {
    private final Optional<Integer> partitionId;
    private final ImmutableList<ProduceRequest.ProduceRequestHeader> headers;
    private final Optional<ProduceRequest.ProduceRequestData> key;
    private final Optional<ProduceRequest.ProduceRequestData> value;
    private final Optional<Instant> timestamp;
    private final Optional<Long> originalSize;

    private AutoValue_ProduceRequest(Optional<Integer> partitionId, ImmutableList<ProduceRequest.ProduceRequestHeader> headers, Optional<ProduceRequest.ProduceRequestData> key, Optional<ProduceRequest.ProduceRequestData> value, Optional<Instant> timestamp, Optional<Long> originalSize) {
        this.partitionId = partitionId;
        this.headers = headers;
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
        this.originalSize = originalSize;
    }

    @Override
    @JsonProperty(value="partition_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Integer> getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableList<ProduceRequest.ProduceRequestHeader> getHeaders() {
        return this.headers;
    }

    @Override
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<ProduceRequest.ProduceRequestData> getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<ProduceRequest.ProduceRequestData> getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Instant> getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonIgnore
    public Optional<Long> getOriginalSize() {
        return this.originalSize;
    }

    public String toString() {
        return "ProduceRequest{partitionId=" + this.partitionId + ", headers=" + this.headers + ", key=" + this.key + ", value=" + this.value + ", timestamp=" + this.timestamp + ", originalSize=" + this.originalSize + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProduceRequest) {
            ProduceRequest that = (ProduceRequest)o;
            return this.partitionId.equals(that.getPartitionId()) && this.headers.equals(that.getHeaders()) && this.key.equals(that.getKey()) && this.value.equals(that.getValue()) && this.timestamp.equals(that.getTimestamp()) && this.originalSize.equals(that.getOriginalSize());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.partitionId.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        h$ ^= this.key.hashCode();
        h$ *= 1000003;
        h$ ^= this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestamp.hashCode();
        h$ *= 1000003;
        return h$ ^= this.originalSize.hashCode();
    }

    static final class Builder
    extends ProduceRequest.Builder {
        private Optional<Integer> partitionId = Optional.empty();
        private ImmutableList<ProduceRequest.ProduceRequestHeader> headers;
        private Optional<ProduceRequest.ProduceRequestData> key = Optional.empty();
        private Optional<ProduceRequest.ProduceRequestData> value = Optional.empty();
        private Optional<Instant> timestamp = Optional.empty();
        private Optional<Long> originalSize = Optional.empty();

        Builder() {
        }

        @Override
        public ProduceRequest.Builder setPartitionId(@Nullable Integer partitionId) {
            this.partitionId = Optional.ofNullable(partitionId);
            return this;
        }

        @Override
        public ProduceRequest.Builder setHeaders(List<ProduceRequest.ProduceRequestHeader> headers) {
            this.headers = ImmutableList.copyOf(headers);
            return this;
        }

        @Override
        public ProduceRequest.Builder setKey(@Nullable ProduceRequest.ProduceRequestData key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        public ProduceRequest.Builder setValue(@Nullable ProduceRequest.ProduceRequestData value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        public ProduceRequest.Builder setTimestamp(@Nullable Instant timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        @Override
        public ProduceRequest.Builder setOriginalSize(@Nullable Long originalSize) {
            this.originalSize = Optional.ofNullable(originalSize);
            return this;
        }

        @Override
        public ProduceRequest build() {
            String missing = "";
            if (this.headers == null) {
                missing = missing + " headers";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ProduceRequest(this.partitionId, this.headers, this.key, this.value, this.timestamp, this.originalSize);
        }
    }
}

