/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.AclApis;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.AuthHelper;
import kafka.server.EnvelopeUtils$;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.server.RequestLocal;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r5f\u0001\u0002 @\u0001\u0011C\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005/\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003a\u0011!y\u0007A!b\u0001\n\u0003\u0001\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0015\u0005\u0005\u0001A!b\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\u0014\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"!\u0006\u0001\u0005\u000b\u0007I\u0011AA\f\u0011)\tY\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003{\u0001!Q1A\u0005\u0002\u0005}\u0002BCA&\u0001\t\u0005\t\u0015!\u0003\u0002B!Q\u0011Q\n\u0001\u0003\u0006\u0004%\t!a\u0014\t\u0015\u0005\u001d\u0004A!A!\u0002\u0013\t\t\u0006\u0003\u0006\u0002j\u0001\u0011)\u0019!C\u0001\u0003WB!\"a\u001d\u0001\u0005\u0003\u0005\u000b\u0011BA7\u0011)\t)\b\u0001BC\u0002\u0013\u0005\u0011q\u000f\u0005\u000b\u0003\u007f\u0002!\u0011!Q\u0001\n\u0005e\u0004BCAA\u0001\t\u0015\r\u0011\"\u0001\u0002\u0004\"Q\u0011q\u0014\u0001\u0003\u0002\u0003\u0006I!!\"\t\u0015\u0005\u0005\u0006A!b\u0001\n\u0003\t\u0019\u000b\u0003\u0006\u0002,\u0002\u0011\t\u0011)A\u0005\u0003KCq!!,\u0001\t\u0003\ty\u000bC\u0005\u0002J\u0002\u0011\r\u0011\"\u0001\u0002L\"A\u00111\u001b\u0001!\u0002\u0013\ti\rC\u0005\u0002V\u0002\u0011\r\u0011\"\u0001\u0002X\"A\u0011q\u001c\u0001!\u0002\u0013\tI\u000eC\u0005\u0002b\u0002\u0011\r\u0011\"\u0003\u0002d\"A\u00111\u001e\u0001!\u0002\u0013\t)\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqA!\u000e\u0001\t\u0003\u00119\u0004C\u0004\u0003<\u0001!\tA!\u0010\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B`\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011\u001d\u0011y\u000e\u0001C\u0001\u0005CDqA!:\u0001\t\u0003\u00119\u000fC\u0004\u0004\u000e\u0001!\taa\u0004\t\u000f\rM\u0001\u0001\"\u0001\u0004\u0016!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0010\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007K\u0001A\u0011AB\u0014\u0011\u001d\u0019Y\u0003\u0001C\u0001\u0007[Aqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0004\u00048\u0001!\ta!\u000f\t\u000f\ru\u0002\u0001\"\u0001\u0004@!911\t\u0001\u0005\u0002\r\u0015\u0003bBB%\u0001\u0011%11\n\u0005\b\u0007O\u0002A\u0011AB5\u0011\u001d\u0019i\u0007\u0001C\u0001\u0007_Bqaa\u001d\u0001\t\u0003\u0019)\bC\u0004\u0004z\u0001!\taa\u001f\t\u000f\rm\u0005\u0001\"\u0001\u0004\u001e\"91\u0011\u0015\u0001\u0005\u0002\r\r\u0006bBBT\u0001\u0011\u00051\u0011\u0016\u0002\u000f\u0007>tGO]8mY\u0016\u0014\u0018\t]5t\u0015\t\u0001\u0015)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0005\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001F\u0017>\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a!\u00118z%\u00164\u0007C\u0001'N\u001b\u0005y\u0014B\u0001(@\u0005E\t\u0005/\u001b*fcV,7\u000f\u001e%b]\u0012dWM\u001d\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0006\u000bQ!\u001e;jYNL!\u0001V)\u0003\u000f1{wmZ5oO\u0006q!/Z9vKN$8\t[1o]\u0016dW#A,\u0011\u0005a[V\"A-\u000b\u0005i\u000b\u0015a\u00028fi^|'o[\u0005\u00039f\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003)\tW\u000f\u001e5pe&TXM]\u000b\u0002AB\u0019a)Y2\n\u0005\t<%AB(qi&|g\u000e\u0005\u0002eY6\tQM\u0003\u0002_M*\u0011\u0001i\u001a\u0006\u0003\u0005\"T!!\u001b6\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0017aA8sO&\u0011Q.\u001a\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018aC1vi\"|'/\u001b>fe\u0002\na!];pi\u0006\u001cX#A9\u0011\u0005IdhBA:{\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002x\u0007\u00061AH]8pizJ\u0011AQ\u0005\u0003\u0001\u0006K!a_ \u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005ut(!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002|\u007f\u00059\u0011/^8uCN\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0002\u0011\t\u0005\u001d\u0011qB\u0007\u0003\u0003\u0013Q1AUA\u0006\u0015\r\tiaZ\u0001\u0007G>lWn\u001c8\n\t\u0005E\u0011\u0011\u0002\u0002\u0005)&lW-A\u0003uS6,\u0007%A\ttkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKN,\"!!\u0007\u0011\u0011\u0005m\u00111EA\u0015\u0003_qA!!\b\u0002 A\u0011QoR\u0005\u0004\u0003C9\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002&\u0005\u001d\"aA'ba*\u0019\u0011\u0011E$\u0011\t\u0005m\u00111F\u0005\u0005\u0003[\t9C\u0001\u0004TiJLgn\u001a\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG4\u0002\u00115,G/\u00193bi\u0006LA!!\u000f\u00024\taa+\u001a:tS>t'+\u00198hK\u0006\u00112/\u001e9q_J$X\r\u001a$fCR,(/Z:!\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002H5\u0011\u0011Q\t\u0006\u0004\u0003{9\u0017\u0002BA%\u0003\u000b\u0012!bQ8oiJ|G\u000e\\3s\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003#\u0002b!a\u0015\u0002Z\u0005uSBAA+\u0015\r\t9&Q\u0001\u0005e\u00064G/\u0003\u0003\u0002\\\u0005U#a\u0003*bMRl\u0015M\\1hKJ\u0004B!a\u0018\u0002d5\u0011\u0011\u0011\r\u0006\u0004\u0003\u001b1\u0017\u0002BA3\u0003C\u0012A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0017\u0001\u0004:bMRl\u0015M\\1hKJ\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002nA\u0019A*a\u001c\n\u0007\u0005EtHA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000f[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t+\t\tI\bE\u0002M\u0003wJ1!! @\u00059iU\r^1Qe>\u0004XM\u001d;jKN\fq\"\\3uCB\u0013x\u000e]3si&,7\u000fI\u0001\u0010G>tGO]8mY\u0016\u0014hj\u001c3fgV\u0011\u0011Q\u0011\t\u0007\u0003\u000f\u000b\t*a&\u000f\t\u0005%\u0015Q\u0012\b\u0004k\u0006-\u0015\"\u0001%\n\u0007\u0005=u)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0015Q\u0013\u0002\u0004'\u0016\f(bAAH\u000fB!\u0011\u0011TAN\u001b\t\tY!\u0003\u0003\u0002\u001e\u0006-!\u0001\u0002(pI\u0016\f\u0001cY8oiJ|G\u000e\\3s\u001d>$Wm\u001d\u0011\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'/\u0006\u0002\u0002&B\u0019A*a*\n\u0007\u0005%vHA\tBa&4VM]:j_:l\u0015M\\1hKJ\f!#\u00199j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3sA\u00051A(\u001b8jiz\"\u0002$!-\u00024\u0006U\u0016qWA]\u0003w\u000bi,a0\u0002B\u0006\r\u0017QYAd!\ta\u0005\u0001C\u0003V/\u0001\u0007q\u000bC\u0003_/\u0001\u0007\u0001\rC\u0003p/\u0001\u0007\u0011\u000fC\u0004\u0002\u0002]\u0001\r!!\u0002\t\u000f\u0005Uq\u00031\u0001\u0002\u001a!9\u0011QH\fA\u0002\u0005\u0005\u0003bBA'/\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003S:\u0002\u0019AA7\u0011\u001d\t)h\u0006a\u0001\u0003sBq!!!\u0018\u0001\u0004\t)\tC\u0004\u0002\"^\u0001\r!!*\u0002\u0015\u0005,H\u000f\u001b%fYB,'/\u0006\u0002\u0002NB\u0019A*a4\n\u0007\u0005EwH\u0001\u0006BkRD\u0007*\u001a7qKJ\f1\"Y;uQ\"+G\u000e]3sA\u0005i!/Z9vKN$\b*\u001a7qKJ,\"!!7\u0011\u00071\u000bY.C\u0002\u0002^~\u0012ACU3rk\u0016\u001cH\u000fS1oI2,'\u000fS3ma\u0016\u0014\u0018A\u0004:fcV,7\u000f\u001e%fYB,'\u000fI\u0001\bC\u000ed\u0017\t]5t+\t\t)\u000fE\u0002M\u0003OL1!!;@\u0005\u001d\t5\r\\!qSN\f\u0001\"Y2m\u0003BL7\u000fI\u0001\tSN\u001cEn\\:fIV\u0011\u0011\u0011\u001f\t\u0004\r\u0006M\u0018bAA{\u000f\n9!i\\8mK\u0006t\u0017!B2m_N,GCAA~!\r1\u0015Q`\u0005\u0004\u0003\u007f<%\u0001B+oSR\fa\u0001[1oI2,GCBA~\u0005\u000b\u00119\u0002C\u0004\u0003\b\u0001\u0002\rA!\u0003\u0002\u000fI,\u0017/^3tiB!!1\u0002B\t\u001d\rA&QB\u0005\u0004\u0005\u001fI\u0016A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0005'\u0011)BA\u0004SKF,Xm\u001d;\u000b\u0007\t=\u0011\fC\u0004\u0003\u001a\u0001\u0002\rAa\u0007\u0002\u0019I,\u0017/^3ti2{7-\u00197\u0011\u00071\u0013i\"C\u0002\u0003 }\u0012ABU3rk\u0016\u001cH\u000fT8dC2\fQ\u0003[1oI2,WI\u001c<fY>\u0004XMU3rk\u0016\u001cH\u000f\u0006\u0004\u0002|\n\u0015\"q\u0005\u0005\b\u0005\u000f\t\u0003\u0019\u0001B\u0005\u0011\u001d\u0011I\"\ta\u0001\u00057\t!\u0004[1oI2,7+Y:m\u0011\u0006tGm\u001d5bW\u0016\u0014V-];fgR$B!a?\u0003.!9!q\u0001\u0012A\u0002\t%\u0011!\b5b]\u0012dWmU1tY\u0006+H\u000f[3oi&\u001c\u0017\r^3SKF,Xm\u001d;\u0015\t\u0005m(1\u0007\u0005\b\u0005\u000f\u0019\u0003\u0019\u0001B\u0005\u0003-A\u0017M\u001c3mK\u001a+Go\u00195\u0015\t\u0005m(\u0011\b\u0005\b\u0005\u000f!\u0003\u0019\u0001B\u0005\u0003MA\u0017M\u001c3mK\u001a+Go\u00195T]\u0006\u00048\u000f[8u)\u0011\tYPa\u0010\t\u000f\t\u001dQ\u00051\u0001\u0003\n\u0005\u0011\u0002.\u00198eY\u0016$U\r\\3uKR{\u0007/[2t)\u0011\tYP!\u0012\t\u000f\t\u001da\u00051\u0001\u0003\n\u0005aA-\u001a7fi\u0016$v\u000e]5dgRa!1\nBG\u0005/\u0013\tK!*\u0003<B1!Q\nB.\u0005?j!Aa\u0014\u000b\t\tE#1K\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002B+\u0005/\nA!\u001e;jY*\u0011!\u0011L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003^\t=#!E\"p[BdW\r^1cY\u00164U\u000f^;sKB1!\u0011\rB2\u0005Oj!Aa\u0015\n\t\t\u0015$1\u000b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0003j\t\u001de\u0002\u0002B6\u0005\u0003sAA!\u001c\u0003~9!!q\u000eB>\u001d\u0011\u0011\tH!\u001f\u000f\t\tM$q\u000f\b\u0004k\nU\u0014\"A6\n\u0005%T\u0017B\u0001\"i\u0013\r\tiaZ\u0005\u0005\u0005\u007f\nY!A\u0004nKN\u001c\u0018mZ3\n\t\t\r%QQ\u0001\u0019\t\u0016dW\r^3U_BL7m\u001d*fgB|gn]3ECR\f'\u0002\u0002B@\u0003\u0017IAA!#\u0003\f\n!B)\u001a7fi\u0006\u0014G.\u001a+pa&\u001c'+Z:vYRTAAa!\u0003\u0006\"9!qA\u0014A\u0002\t=\u0005\u0003\u0002BI\u0005'k!A!\"\n\t\tU%Q\u0011\u0002\u0018\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006DqA!'(\u0001\u0004\u0011Y*\u0001\u0006ba&4VM]:j_:\u00042A\u0012BO\u0013\r\u0011yj\u0012\u0002\u0004\u0013:$\bb\u0002BRO\u0001\u0007\u0011\u0011_\u0001\u000fQ\u0006\u001c8\t\\;ti\u0016\u0014\u0018)\u001e;i\u0011\u001d\u00119k\na\u0001\u0005S\u000bAcZ3u\t\u0016\u001c8M]5cC\ndW\rV8qS\u000e\u001c\bc\u0002$\u0003,\n=&QW\u0005\u0004\u0005[;%!\u0003$v]\u000e$\u0018n\u001c82!\u0019\t9I!-\u0002*%!!1WAK\u0005!IE/\u001a:bE2,\u0007CBA\u000e\u0005o\u000bI#\u0003\u0003\u0003:\u0006\u001d\"aA*fi\"9!QX\u0014A\u0002\t%\u0016AE4fi\u0012+G.\u001a;bE2,Gk\u001c9jGN\f!\u0003[1oI2,7I]3bi\u0016$v\u000e]5dgR!\u00111 Bb\u0011\u001d\u00119\u0001\u000ba\u0001\u0005\u0013\tAb\u0019:fCR,Gk\u001c9jGN$\u0002B!3\u0003R\ne'1\u001c\t\u0007\u0005\u001b\u0012YFa3\u0011\t\tE%QZ\u0005\u0005\u0005\u001f\u0014)I\u0001\rDe\u0016\fG/\u001a+pa&\u001c7OU3ta>t7/\u001a#bi\u0006DqAa\u0002*\u0001\u0004\u0011\u0019\u000e\u0005\u0003\u0003\u0012\nU\u0017\u0002\u0002Bl\u0005\u000b\u0013qc\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR$\u0015\r^1\t\u000f\t\r\u0016\u00061\u0001\u0002r\"9!Q\\\u0015A\u0002\t%\u0016AE4fi\u000e\u0013X-\u0019;bE2,Gk\u001c9jGN\f\u0001\u0004[1oI2,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0011\tYPa9\t\u000f\t\u001d!\u00061\u0001\u0003\n\u00051\u0012-\u001e;i_JL'0Z!mi\u0016\u0014(+Z:pkJ\u001cW\r\u0006\u0004\u0003j\nU(q \t\u0005\u0005W\u0014\t0\u0004\u0002\u0003n*!!q^A\u0006\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002Bz\u0005[\u0014\u0001\"\u00119j\u000bJ\u0014xN\u001d\u0005\b\u0005o\\\u0003\u0019\u0001B}\u00039\u0011X-];fgR\u001cuN\u001c;fqR\u0004BAa;\u0003|&!!Q Bw\u00059\u0011V-];fgR\u001cuN\u001c;fqRDqa!\u0001,\u0001\u0004\u0019\u0019!\u0001\u0005sKN|WO]2f!\u0011\u0019)a!\u0003\u000e\u0005\r\u001d!\u0002BA5\u0003\u0017IAaa\u0003\u0004\b\tq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017\u0001\u00075b]\u0012dW\rT3hC\u000eL\u0018\t\u001c;fe\u000e{gNZ5hgR!\u00111`B\t\u0011\u001d\u00119\u0001\fa\u0001\u0005\u0013\t!\u0002[1oI2,gk\u001c;f)\u0011\tYpa\u0006\t\u000f\t\u001dQ\u00061\u0001\u0003\n\u00051\u0002.\u00198eY\u0016\u0014UmZ5o#V|'/^7Fa>\u001c\u0007\u000e\u0006\u0003\u0002|\u000eu\u0001b\u0002B\u0004]\u0001\u0007!\u0011B\u0001\u0015Q\u0006tG\r\\3F]\u0012\fVo\u001c:v[\u0016\u0003xn\u00195\u0015\t\u0005m81\u0005\u0005\b\u0005\u000fy\u0003\u0019\u0001B\u0005\u0003QA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016\fVo\u001c:v[R!\u00111`B\u0015\u0011\u001d\u00119\u0001\ra\u0001\u0005\u0013\t!\u0003[1oI2,W\t\\3di2+\u0017\rZ3sgR!\u00111`B\u0018\u0011\u001d\u00119!\ra\u0001\u0005\u0013\tQ\u0003[1oI2,\u0017\t\u001c;fe&\u001b(OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002|\u000eU\u0002b\u0002B\u0004e\u0001\u0007!\u0011B\u0001\u001dQ\u0006tG\r\\3Ce>\\WM\u001d%fCJ$()Z1u%\u0016\fX/Z:u)\u0011\tYpa\u000f\t\u000f\t\u001d1\u00071\u0001\u0003\n\u00051\u0002.\u00198eY\u0016,fN]3hSN$XM\u001d\"s_.,'\u000f\u0006\u0003\u0002|\u000e\u0005\u0003b\u0002B\u0004i\u0001\u0007!\u0011B\u0001\u0019Q\u0006tG\r\\3Ce>\\WM\u001d*fO&\u001cHO]1uS>tG\u0003BA~\u0007\u000fBqAa\u00026\u0001\u0004\u0011I!A\tiC:$G.\u001a*bMR\u0014V-];fgR$b!a?\u0004N\r=\u0003b\u0002B\u0004m\u0001\u0007!\u0011\u0002\u0005\b\u0007#2\u0004\u0019AB*\u00035\u0011W/\u001b7e%\u0016\u001c\bo\u001c8tKB9aIa+\u0004V\r\u0005\u0004\u0003BB,\u0007;j!a!\u0017\u000b\t\rm\u00131B\u0001\taJ|Go\\2pY&!1qLB-\u0005)\t\u0005/['fgN\fw-\u001a\t\u0005\u0005W\u001c\u0019'\u0003\u0003\u0004f\t5(\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0003]A\u0017M\u001c3mK\u0006cG/\u001a:DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u0002|\u000e-\u0004b\u0002B\u0004o\u0001\u0007!\u0011B\u0001\u001eQ\u0006tG\r\\3J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgR!\u00111`B9\u0011\u001d\u00119\u0001\u000fa\u0001\u0005\u0013\ta\u0003[1oI2,7I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003w\u001c9\bC\u0004\u0003\be\u0002\rA!\u0003\u0002!\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cHCBB?\u0007\u001f\u001b9\n\u0005\u0004\u0003N\tm3q\u0010\t\u0007\u0005C\u0012\u0019g!!\u0011\t\r\r5\u0011\u0012\b\u0005\u0005W\u001a))\u0003\u0003\u0004\b\n\u0015\u0015\u0001H\"sK\u0006$X\rU1si&$\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0007\u0017\u001biIA\u000eDe\u0016\fG/\u001a)beRLG/[8ogR{\u0007/[2SKN,H\u000e\u001e\u0006\u0005\u0007\u000f\u0013)\tC\u0004\u0003\bi\u0002\ra!%\u0011\t\tE51S\u0005\u0005\u0007+\u0013)IA\u000eDe\u0016\fG/\u001a)beRLG/[8ogJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u00073S\u0004\u0019\u0001BU\u0003a9W\r^!mi\u0016\u0014\u0018)\u001e;i_JL'0\u001a3U_BL7m]\u0001\"Q\u0006tG\r\\3BYR,'\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGo\u001d\u000b\u0005\u0003w\u001cy\nC\u0004\u0003\bm\u0002\rA!\u0003\u0002A!\fg\u000e\u001a7f\u0019&\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGo\u001d\u000b\u0005\u0003w\u001c)\u000bC\u0004\u0003\bq\u0002\rA!\u0003\u0002A!\fg\u000e\u001a7f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fcV,7\u000f\u001e\u000b\u0005\u0003w\u001cY\u000bC\u0004\u0003\bu\u0002\rA!\u0003")
public class ControllerApis
implements ApiRequestHandler,
Logging {
    private final RequestChannel requestChannel;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private final scala.collection.immutable.Map<String, VersionRange> supportedFeatures;
    private final Controller controller;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final KafkaConfig config;
    private final MetaProperties metaProperties;
    private final Seq<Node> controllerNodes;
    private final ApiVersionManager apiVersionManager;
    private final AuthHelper authHelper;
    private final RequestHandlerHelper requestHelper;
    private final AclApis aclApis;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public Time time() {
        return this.time;
    }

    public scala.collection.immutable.Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Controller controller() {
        return this.controller;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public Seq<Node> controllerNodes() {
        return this.controllerNodes;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    private AclApis aclApis() {
        return this.aclApis;
    }

    public boolean isClosed() {
        return this.aclApis().isClosed();
    }

    public void close() {
        this.aclApis().close();
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        block31: {
            try {
                ApiKeys apiKeys = request.header().apiKey();
                if (ApiKeys.FETCH.equals(apiKeys)) {
                    this.handleFetch(request);
                    break block31;
                }
                if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                    this.handleFetchSnapshot(request);
                    break block31;
                }
                if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                    this.handleCreateTopics(request);
                    break block31;
                }
                if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                    this.handleDeleteTopics(request);
                    break block31;
                }
                if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                    this.handleApiVersionsRequest(request);
                    break block31;
                }
                if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
                    this.handleLegacyAlterConfigs(request);
                    break block31;
                }
                if (ApiKeys.VOTE.equals(apiKeys)) {
                    this.handleVote(request);
                    break block31;
                }
                if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                    this.handleBeginQuorumEpoch(request);
                    break block31;
                }
                if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                    this.handleEndQuorumEpoch(request);
                    break block31;
                }
                if (ApiKeys.DESCRIBE_QUORUM.equals(apiKeys)) {
                    this.handleDescribeQuorum(request);
                    break block31;
                }
                if (ApiKeys.ALTER_ISR.equals(apiKeys)) {
                    this.handleAlterIsrRequest(request);
                    break block31;
                }
                if (ApiKeys.BROKER_REGISTRATION.equals(apiKeys)) {
                    this.handleBrokerRegistration(request);
                    break block31;
                }
                if (ApiKeys.BROKER_HEARTBEAT.equals(apiKeys)) {
                    this.handleBrokerHeartBeatRequest(request);
                    break block31;
                }
                if (ApiKeys.UNREGISTER_BROKER.equals(apiKeys)) {
                    this.handleUnregisterBroker(request);
                    break block31;
                }
                if (ApiKeys.ALTER_CLIENT_QUOTAS.equals(apiKeys)) {
                    this.handleAlterClientQuotas(request);
                    break block31;
                }
                if (ApiKeys.INCREMENTAL_ALTER_CONFIGS.equals(apiKeys)) {
                    this.handleIncrementalAlterConfigs(request);
                    break block31;
                }
                if (ApiKeys.ALTER_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    this.handleAlterPartitionReassignments(request);
                    break block31;
                }
                if (ApiKeys.LIST_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    this.handleListPartitionReassignments(request);
                    break block31;
                }
                if (ApiKeys.ENVELOPE.equals(apiKeys)) {
                    this.handleEnvelopeRequest(request, requestLocal);
                    break block31;
                }
                if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                    this.handleSaslHandshakeRequest(request);
                    break block31;
                }
                if (ApiKeys.SASL_AUTHENTICATE.equals(apiKeys)) {
                    this.handleSaslAuthenticateRequest(request);
                    break block31;
                }
                if (ApiKeys.ALLOCATE_PRODUCER_IDS.equals(apiKeys)) {
                    this.handleAllocateProducerIdsRequest(request);
                    break block31;
                }
                if (ApiKeys.CREATE_PARTITIONS.equals(apiKeys)) {
                    this.handleCreatePartitions(request);
                    break block31;
                }
                if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
                    this.aclApis().handleDescribeAcls(request);
                    break block31;
                }
                if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
                    this.aclApis().handleCreateAcls(request);
                    break block31;
                }
                if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
                    this.aclApis().handleDeleteAcls(request);
                    break block31;
                }
                if (ApiKeys.ELECT_LEADERS.equals(apiKeys)) {
                    this.handleElectLeaders(request);
                    break block31;
                }
                throw new ApiException(new StringBuilder(19).append("Unsupported ApiKey ").append(request.context().header.apiKey()).toString());
            }
            catch (FatalExitError fatalExitError) {
                throw fatalExitError;
            }
            catch (ExecutionException e) {
                this.requestHelper().handleError(request, e.getCause());
                return;
            }
            catch (Throwable e) {
                this.requestHelper().handleError(request, e);
            }
        }
    }

    public void handleEnvelopeRequest(RequestChannel.Request request, RequestLocal requestLocal) {
        if (!this.authHelper().authorize(request.context(), AclOperation.CLUSTER_ACTION, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            this.requestHelper().sendErrorResponseMaybeThrottle(request, (Throwable)new ClusterAuthorizationException(new StringBuilder(61).append("Principal ").append(request.context().principal).append(" does not have required CLUSTER_ACTION for envelope").toString()));
            return;
        }
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(request, this.requestChannel().metrics(), (Function1<RequestChannel.Request, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            this.handle(x$1, requestLocal);
            return BoxedUnit.UNIT;
        });
    }

    public void handleSaslHandshakeRequest(RequestChannel.Request request) {
        SaslHandshakeResponseData responseData = new SaslHandshakeResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code());
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$2 -> ControllerApis.$anonfun$handleSaslHandshakeRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    public void handleSaslAuthenticateRequest(RequestChannel.Request request) {
        SaslAuthenticateResponseData responseData = new SaslAuthenticateResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code()).setErrorMessage("SaslAuthenticate request received after successful authentication");
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$3 -> ControllerApis.$anonfun$handleSaslAuthenticateRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public void handleFetch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleFetchSnapshot(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleDeleteTopics(RequestChannel.Request request) {
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.deleteTopics(deleteTopicsRequest.data(), request.context().apiVersion(), this.authHelper().authorize(request.context(), AclOperation.DELETE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DELETE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n)).whenComplete((results, exception) -> this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleDeleteTopics$6(exception, deleteTopicsRequest, results, BoxesRunTime.unboxToInt((Object)throttleTimeMs))));
    }

    public CompletableFuture<List<DeleteTopicsResponseData.DeletableTopicResult>> deleteTopics(DeleteTopicsRequestData request, int apiVersion, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDeletableTopics) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config().deleteTopicEnable())) {
            if (apiVersion < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
        long deadlineNs = this.time().nanoseconds() + TimeUnit.NANOSECONDS.convert(request.timeoutMs(), TimeUnit.MILLISECONDS);
        ArrayList responses = new ArrayList();
        HashSet providedNames = new HashSet();
        HashSet duplicateProvidedNames = new HashSet();
        HashSet providedIds = new HashSet();
        HashSet duplicateProvidedIds = new HashSet();
        request.topicNames().forEach(name -> ControllerApis.addProvidedName$1(name, duplicateProvidedNames, providedNames));
        request.topics().forEach(topic -> {
            if (topic.name() == null) {
                if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                    ControllerApis.appendResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                    return;
                }
                if (duplicateProvidedIds.contains(topic.topicId()) || !providedIds.add(topic.topicId())) {
                    duplicateProvidedIds.add(topic.topicId());
                    providedIds.remove(topic.topicId());
                    return;
                }
                return;
            }
            if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                ControllerApis.addProvidedName$1(topic.name(), duplicateProvidedNames, providedNames);
                return;
            }
            ControllerApis.appendResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
        });
        duplicateProvidedNames.forEach(name -> ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses));
        duplicateProvidedIds.forEach(id -> ControllerApis.appendResponse$1(null, id, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses));
        HashSet toAuthenticate = new HashSet();
        toAuthenticate.addAll(providedNames);
        HashMap idToName = new HashMap();
        return this.controller().findTopicNames(deadlineNs, providedIds).thenCompose(topicNames -> {
            void var13_13;
            void var14_14;
            Object object;
            Object object2;
            topicNames.forEach((id, nameOrError) -> {
                if (nameOrError.isError()) {
                    ControllerApis.appendResponse$1(null, id, nameOrError.error(), responses);
                    return;
                }
                toAuthenticate.add(nameOrError.result());
                idToName.put(id, nameOrError.result());
            });
            scala.collection.mutable.Set topicsToAuthenticate = CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)toAuthenticate).asScala();
            if (hasClusterAuth) {
                object2 = topicsToAuthenticate.toSet();
                object = topicsToAuthenticate.toSet();
            } else {
                object2 = getDescribableTopics.apply((Object)topicsToAuthenticate);
                object = getDeletableTopics.apply((Object)topicsToAuthenticate);
            }
            scala.collection.immutable.Set set = object;
            Object describeable = object2;
            scala.collection.immutable.Set deletable = set;
            Iterator iterator = idToName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Uuid id2 = (Uuid)entry.getKey();
                String name = (String)entry.getValue();
                if (var14_14.contains((Object)name)) continue;
                if (var13_13.contains((Object)name)) {
                    ControllerApis.appendResponse$1(name, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                } else {
                    ControllerApis.appendResponse$1(null, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                }
                iterator.remove();
            }
            return this.controller().findTopicIds(deadlineNs, (Collection)providedNames).thenCompose(arg_0 -> ControllerApis.$anonfun$deleteTopics$7(this, (scala.collection.immutable.Set)var13_13, (scala.collection.immutable.Set)var14_14, duplicateProvidedIds, idToName, deadlineNs, responses, arg_0));
        });
    }

    public void handleCreateTopics(RequestChannel.Request request) {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.createTopics(createTopicsRequest.data(), this.authHelper().authorize(request.context(), AclOperation.CREATE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.CREATE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x))).whenComplete((result, exception) -> this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleCreateTopics$4(exception, createTopicsRequest, result, BoxesRunTime.unboxToInt((Object)throttleTimeMs))));
    }

    public CompletableFuture<CreateTopicsResponseData> createTopics(CreateTopicsRequestData request, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getCreatableTopics) {
        HashSet topicNames = new HashSet();
        HashSet duplicateTopicNames = new HashSet();
        request.topics().forEach(topicData -> {
            if (!duplicateTopicNames.contains(topicData.name())) {
                if (!topicNames.add(topicData.name())) {
                    topicNames.remove(topicData.name());
                    duplicateTopicNames.add(topicData.name());
                    return;
                }
                return;
            }
        });
        scala.collection.mutable.Set authorizedTopicNames = hasClusterAuth ? CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala() : (Set)getCreatableTopics.apply((Object)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala());
        CreateTopicsRequestData effectiveRequest = request.duplicate();
        Iterator iterator = effectiveRequest.topics().iterator();
        while (iterator.hasNext()) {
            CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
            if (!duplicateTopicNames.contains(creatableTopic.name()) && authorizedTopicNames.contains((Object)creatableTopic.name())) continue;
            iterator.remove();
        }
        return this.controller().createTopics(effectiveRequest).thenApply(arg_0 -> ControllerApis.$anonfun$createTopics$2(duplicateTopicNames, topicNames, (Set)authorizedTopicNames, arg_0));
    }

    public void handleApiVersionsRequest(RequestChannel.Request request) {
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> this.createResponseCallback$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs), request));
    }

    public ApiError authorizeAlterResource(RequestContext requestContext, ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.BROKER.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, resource.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED);
        }
        return new ApiError(Errors.INVALID_REQUEST, new StringBuilder(26).append("Unexpected resource type ").append(type).append(".").toString());
    }

    public void handleLegacyAlterConfigs(RequestChannel.Request request) {
        AlterConfigsResponseData response = new AlterConfigsResponseData();
        AlterConfigsRequest alterConfigsRequest = (AlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(AlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap configs = new HashMap();
                resource.configs().forEach(config -> configs.put(config.name(), config.value()));
                if (configChanges.put(configResource, configs) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        this.controller().legacyAlterConfigs(configChanges, alterConfigsRequest.data().validateOnly()).whenComplete((controllerResults, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            controllerResults.entrySet().forEach(entry -> response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleLegacyAlterConfigs$5(response, BoxesRunTime.unboxToInt((Object)throttleMs)));
        });
    }

    public void handleVote(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleEndQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleDescribeQuorum(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new DescribeQuorumResponse((DescribeQuorumResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleElectLeaders(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ElectLeadersRequest electLeadersRequest = (ElectLeadersRequest)request.body(ClassTag$.MODULE$.apply(ElectLeadersRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.controller().electLeaders(electLeadersRequest.data()).whenComplete((responseData, exception) -> {
            if (exception != null) {
                this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> electLeadersRequest.getErrorResponse(BoxesRunTime.unboxToInt((Object)throttleMs), exception));
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleElectLeaders$3(responseData, BoxesRunTime.unboxToInt((Object)throttleMs)));
        });
    }

    public void handleAlterIsrRequest(RequestChannel.Request request) {
        AlterIsrRequest alterIsrRequest = (AlterIsrRequest)request.body(ClassTag$.MODULE$.apply(AlterIsrRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().alterIsr(alterIsrRequest.data()).whenComplete((result, exception) -> {
            AlterIsrResponse response = exception != null ? alterIsrRequest.getErrorResponse(exception) : new AlterIsrResponse(result);
            this.requestHelper().sendResponseExemptThrottle(request, (AbstractResponse)response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleBrokerHeartBeatRequest(RequestChannel.Request request) {
        BrokerHeartbeatRequest heartbeatRequest = (BrokerHeartbeatRequest)request.body(ClassTag$.MODULE$.apply(BrokerHeartbeatRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().processBrokerHeartbeat(heartbeatRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerHeartBeatRequest$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    public void handleUnregisterBroker(RequestChannel.Request request) {
        UnregisterBrokerRequest decommissionRequest = (UnregisterBrokerRequest)request.body(ClassTag$.MODULE$.apply(UnregisterBrokerRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        this.controller().unregisterBroker(decommissionRequest.data().brokerId()).handle((x$5, e) -> {
            ControllerApis.$anonfun$handleUnregisterBroker$1(this, request, x$5, e);
            return BoxedUnit.UNIT;
        });
    }

    public void handleBrokerRegistration(RequestChannel.Request request) {
        BrokerRegistrationRequest registrationRequest = (BrokerRegistrationRequest)request.body(ClassTag$.MODULE$.apply(BrokerRegistrationRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().registerBroker(registrationRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerRegistration$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    private void handleRaftRequest(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.raftManager().handleRequest(request.header(), requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleAlterClientQuotas(RequestChannel.Request request) {
        AlterClientQuotasRequest quotaRequest = (AlterClientQuotasRequest)request.body(ClassTag$.MODULE$.apply(AlterClientQuotasRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER_CONFIGS);
        this.controller().alterClientQuotas((Collection)quotaRequest.entries(), quotaRequest.validateOnly()).whenComplete((results, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterClientQuotas$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public void handleIncrementalAlterConfigs(RequestChannel.Request request) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap altersByName = new HashMap();
                resource.configs().forEach(config -> altersByName.put(config.name(), new AbstractMap.SimpleEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.forId((byte)config.configOperation()), config.value())));
                if (configChanges.put(configResource, altersByName) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        this.controller().incrementalAlterConfigs(configChanges, alterConfigsRequest.data().validateOnly()).whenComplete((controllerResults, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            controllerResults.entrySet().forEach(entry -> response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleIncrementalAlterConfigs$5(response, BoxesRunTime.unboxToInt((Object)throttleMs)));
        });
    }

    public void handleCreatePartitions(RequestChannel.Request request) {
        this.createPartitions(((CreatePartitionsRequest)request.body(ClassTag$.MODULE$.apply(CreatePartitionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).data(), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)topics -> this.filterAlterAuthorizedTopics$1((Iterable)topics, request)).whenComplete((responses, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreatePartitions$4(responses, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(CreatePartitionsRequestData request, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getAlterAuthorizedTopics) {
        long deadlineNs = this.time().nanoseconds() + TimeUnit.NANOSECONDS.convert(request.timeoutMs(), TimeUnit.MILLISECONDS);
        ArrayList responses = new ArrayList();
        HashSet duplicateTopicNames = new HashSet();
        HashSet topicNames = new HashSet();
        request.topics().forEach(topic -> {
            if (!topicNames.add(topic.name())) {
                duplicateTopicNames.add(topic.name());
                return;
            }
        });
        duplicateTopicNames.forEach(topicName -> {
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."));
            topicNames.remove(topicName);
        });
        scala.collection.immutable.Set authorizedTopicNames = (scala.collection.immutable.Set)getAlterAuthorizedTopics.apply((Object)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala());
        ArrayList topics = new ArrayList();
        topicNames.forEach(topicName -> {
            if (authorizedTopicNames.contains(topicName)) {
                topics.add(request.topics().find(topicName));
                return;
            }
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
        });
        return this.controller().createPartitions(deadlineNs, topics).thenApply(results -> {
            results.forEach(response -> responses.add(response));
            return responses;
        });
    }

    public void handleAlterPartitionReassignments(RequestChannel.Request request) {
        AlterPartitionReassignmentsRequest alterRequest = (AlterPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        AlterPartitionReassignmentsResponseData response = (AlterPartitionReassignmentsResponseData)this.controller().alterPartitionReassignments(alterRequest.data()).get();
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterPartitionReassignments$1(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public void handleListPartitionReassignments(RequestChannel.Request request) {
        ListPartitionReassignmentsRequest listRequest = (ListPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(ListPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        ListPartitionReassignmentsResponseData response = (ListPartitionReassignmentsResponseData)this.controller().listPartitionReassignments(listRequest.data()).get();
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleListPartitionReassignments$1(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public void handleAllocateProducerIdsRequest(RequestChannel.Request request) {
        AllocateProducerIdsRequest allocatedProducerIdsRequest = (AllocateProducerIdsRequest)request.body(ClassTag$.MODULE$.apply(AllocateProducerIdsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().allocateProducerIds(allocatedProducerIdsRequest.data()).whenComplete((results, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAllocateProducerIdsRequest$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public static final /* synthetic */ SaslHandshakeResponse $anonfun$handleSaslHandshakeRequest$1(SaslHandshakeResponseData responseData$1, int x$2) {
        return new SaslHandshakeResponse(responseData$1);
    }

    public static final /* synthetic */ SaslAuthenticateResponse $anonfun$handleSaslAuthenticateRequest$1(SaslAuthenticateResponseData responseData$2, int x$3) {
        return new SaslAuthenticateResponse(responseData$2);
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleDeleteTopics$6(Throwable exception$1, DeleteTopicsRequest deleteTopicsRequest$1, List results$1, int throttleTimeMs) {
        if (exception$1 != null) {
            return deleteTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$1);
        }
        DeleteTopicsResponseData responseData = new DeleteTopicsResponseData().setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(results$1.iterator())).setThrottleTimeMs(throttleTimeMs);
        return new DeleteTopicsResponse(responseData);
    }

    private static final void appendResponse$1(String name, Uuid id, ApiError error, ArrayList responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private static final void addProvidedName$1(String name, HashSet duplicateProvidedNames$1, HashSet providedNames$1) {
        if (duplicateProvidedNames$1.contains(name) || !providedNames$1.add(name)) {
            duplicateProvidedNames$1.add(name);
            providedNames$1.remove(name);
            return;
        }
    }

    public static final /* synthetic */ CompletableFuture $anonfun$deleteTopics$7(ControllerApis $this, scala.collection.immutable.Set describeable$1, scala.collection.immutable.Set deletable$1, HashSet duplicateProvidedIds$1, HashMap idToName$1, long deadlineNs$1, ArrayList responses$1, Map topicIds) {
        topicIds.forEach((name, idOrError) -> {
            if (!describeable$1.contains(name)) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
                return;
            }
            if (idOrError.isError()) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, idOrError.error(), responses$1);
                return;
            }
            if (deletable$1.contains(name)) {
                Uuid id = (Uuid)idOrError.result();
                if (duplicateProvidedIds$1.contains(id) || idToName$1.put(id, name) != null) {
                    duplicateProvidedIds$1.add(id);
                    idToName$1.remove(id);
                    ControllerApis.appendResponse$1(name, id, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses$1);
                    return;
                }
                return;
            }
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
        });
        return $this.controller().deleteTopics(deadlineNs$1, idToName$1.keySet()).thenApply(idToError -> {
            idToError.forEach((id, error) -> ControllerApis.appendResponse$1((String)idToName$1.get(id), id, error, responses$1));
            Collections.shuffle(responses$1);
            return responses$1;
        });
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleCreateTopics$4(Throwable exception$2, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result$1, int throttleTimeMs) {
        if (exception$2 != null) {
            return createTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$2);
        }
        result$1.setThrottleTimeMs(throttleTimeMs);
        return new CreateTopicsResponse(result$1);
    }

    public static final /* synthetic */ CreateTopicsResponseData $anonfun$createTopics$2(HashSet duplicateTopicNames$1, HashSet topicNames$1, Set authorizedTopicNames$1, CreateTopicsResponseData response) {
        duplicateTopicNames$1.forEach(name -> response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name.")));
        topicNames$1.forEach(name -> {
            if (!authorizedTopicNames$1.contains(name)) {
                response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
                return;
            }
        });
        return response;
    }

    private final ApiVersionsResponse createResponseCallback$1(int requestThrottleMs, RequestChannel.Request request$3) {
        ApiVersionsRequest apiVersionRequest = (ApiVersionsRequest)request$3.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        if (apiVersionRequest.hasUnsupportedRequestVersion()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.UNSUPPORTED_VERSION.exception());
        }
        if (!apiVersionRequest.isValid()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.INVALID_REQUEST.exception());
        }
        return this.apiVersionManager().apiVersionResponse(requestThrottleMs);
    }

    public static final /* synthetic */ AlterConfigsResponse $anonfun$handleLegacyAlterConfigs$5(AlterConfigsResponseData response$2, int throttleMs) {
        return new AlterConfigsResponse(response$2.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ ElectLeadersResponse $anonfun$handleElectLeaders$3(ElectLeadersResponseData responseData$3, int throttleMs) {
        return new ElectLeadersResponse(responseData$3.setThrottleTimeMs(throttleMs));
    }

    private static final BrokerHeartbeatResponse createResponseCallback$2(int requestThrottleMs, BrokerHeartbeatReply reply, Throwable e) {
        if (e != null) {
            return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setIsCaughtUp(reply.isCaughtUp()).setIsFenced(reply.isFenced()).setShouldShutDown(reply.shouldShutDown()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerHeartBeatRequest$1(ControllerApis $this, RequestChannel.Request request$7, BrokerHeartbeatReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$7, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$2(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    private static final UnregisterBrokerResponse createResponseCallback$3(int requestThrottleMs, Throwable e) {
        if (e != null) {
            return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUnregisterBroker$1(ControllerApis $this, RequestChannel.Request request$8, Void x$5, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$8, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$3(BoxesRunTime.unboxToInt((Object)requestThrottleMs), e));
    }

    private static final BrokerRegistrationResponse createResponseCallback$4(int requestThrottleMs, BrokerRegistrationReply reply, Throwable e) {
        if (e != null) {
            return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setBrokerEpoch(reply.epoch()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerRegistration$1(ControllerApis $this, RequestChannel.Request request$9, BrokerRegistrationReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$9, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$4(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    public static final /* synthetic */ AlterClientQuotasResponse $anonfun$handleAlterClientQuotas$2(Map results$2, int requestThrottleMs) {
        return AlterClientQuotasResponse.fromQuotaEntities((Map)results$2, (int)requestThrottleMs);
    }

    public static final /* synthetic */ IncrementalAlterConfigsResponse $anonfun$handleIncrementalAlterConfigs$5(IncrementalAlterConfigsResponseData response$3, int throttleMs) {
        return new IncrementalAlterConfigsResponse(response$3.setThrottleTimeMs(throttleMs));
    }

    private final scala.collection.immutable.Set filterAlterAuthorizedTopics$1(Iterable topics, RequestChannel.Request request$13) {
        return this.authHelper().filterByAuthorized(request$13.context(), AclOperation.ALTER, ResourceType.TOPIC, topics, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n);
    }

    public static final /* synthetic */ CreatePartitionsResponse $anonfun$handleCreatePartitions$4(List responses$2, int requestThrottleMs) {
        CreatePartitionsResponseData responseData = new CreatePartitionsResponseData().setResults(responses$2).setThrottleTimeMs(requestThrottleMs);
        return new CreatePartitionsResponse(responseData);
    }

    public static final /* synthetic */ AlterPartitionReassignmentsResponse $anonfun$handleAlterPartitionReassignments$1(AlterPartitionReassignmentsResponseData response$4, int requestThrottleMs) {
        return new AlterPartitionReassignmentsResponse(response$4.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ ListPartitionReassignmentsResponse $anonfun$handleListPartitionReassignments$1(ListPartitionReassignmentsResponseData response$5, int requestThrottleMs) {
        return new ListPartitionReassignmentsResponse(response$5.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ AllocateProducerIdsResponse $anonfun$handleAllocateProducerIdsRequest$2(AllocateProducerIdsResponseData results$3, int requestThrottleMs) {
        results$3.setThrottleTimeMs(requestThrottleMs);
        return new AllocateProducerIdsResponse(results$3);
    }

    public ControllerApis(RequestChannel requestChannel, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, scala.collection.immutable.Map<String, VersionRange> supportedFeatures, Controller controller, RaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, MetaProperties metaProperties, Seq<Node> controllerNodes, ApiVersionManager apiVersionManager) {
        this.requestChannel = requestChannel;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.time = time;
        this.supportedFeatures = supportedFeatures;
        this.controller = controller;
        this.raftManager = raftManager;
        this.config = config;
        this.metaProperties = metaProperties;
        this.controllerNodes = controllerNodes;
        this.apiVersionManager = apiVersionManager;
        this.authHelper = new AuthHelper(authorizer);
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.aclApis = new AclApis(this.authHelper(), authorizer, this.requestHelper(), "controller", config);
    }
}

